/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ConfigurationPanel
extends JPanel {
    DataProspector parent;
    boolean driverLoaded = false;
    private Connection connection = null;
    private JLabel jLabel4;
    private JLabel jLabel1;
    private JComboBox databaseComboBox;
    private JLabel jLabel3;
    private JComboBox userComboBox;
    private JCheckBox autoloadCheckBox;
    private JLabel jLabel2;
    private JCheckBox readOnlyCheckBox;
    private JCheckBox savePasswordCheckBox;
    private JButton quitButton;
    private JComboBox hostComboBox;
    private JTextField passwordTextField;
    private JComboBox driverComboBox;
    private JComboBox tableComboBox;
    private JLabel jLabel6;
    private JLabel jLabel5;

    public ConfigurationPanel(DataProspector p) {
        this.parent = p;
        this.initComponents();
        ((JPasswordField)this.passwordTextField).setEchoChar('*');
    }

    public void setupComboBoxes(boolean save) {
        this.setupOptions(save);
        this.parent.getDataPane().setupOptions(save);
    }

    private void setupDriverTag() {
        String[] array;
        String driverTag = (String)this.hostComboBox.getSelectedItem();
        driverTag = driverTag != null ? ((array = driverTag.split(":")).length >= 3 ? array[1] : "mysql") : "mysql";
        this.parent.driverTag = driverTag;
    }

    private void updateUserData(boolean preserveTable) {
        if (this.fetchDatabases(preserveTable)) {
            this.parent.addComboItem(this.hostComboBox);
            this.parent.addComboItem(this.driverComboBox);
            this.parent.addComboItem(this.userComboBox);
            this.parent.addComboItem(this.databaseComboBox);
            this.parent.addComboItem(this.tableComboBox);
        }
    }

    public boolean fetchDatabases(boolean preserveTable) {
        ResultSet rs;
        boolean result = this.makeConnection();
        if (result && (rs = this.executeQuery(this.parent.configHandler.getSingleValue("ShowDatabases_" + this.parent.driverTag))) != null) {
            String sel = (String)this.databaseComboBox.getSelectedItem();
            try {
                while (rs.next()) {
                    String field = rs.getString(1);
                    this.parent.addComboItem(this.databaseComboBox, field);
                }
                this.parent.setSelectedItem(this.databaseComboBox, sel);
                this.parent.clearMessage();
                if (preserveTable) {
                    this.tableChanged();
                } else {
                    this.databaseChanged();
                }
            }
            catch (SQLException e) {
                this.parent.putMessage("Fetch Databases", e);
            }
        }
        return result;
    }

    private boolean databaseChanged() {
        ResultSet rs;
        boolean result = this.makeConnection();
        if (result && (rs = this.executeQuery(this.parent.configHandler.getSingleValue("ShowTables_" + this.parent.driverTag))) != null) {
            this.tableComboBox.removeAllItems();
            try {
                while (rs.next()) {
                    String field = rs.getString(1);
                    this.parent.addComboItem(this.tableComboBox, field);
                }
                this.parent.setSelectedIndex(this.tableComboBox, 0);
                this.parent.clearMessage();
                this.tableChanged();
            }
            catch (SQLException e) {
                this.parent.putMessage("Fetch Tables", e);
            }
        }
        return result;
    }

    private boolean tableChanged() {
        this.parent.setSelectedItem(this.tableComboBox, (String)this.tableComboBox.getSelectedItem());
        boolean result = this.makeConnection();
        if (result) {
            String database = (String)this.databaseComboBox.getSelectedItem();
            String table = (String)this.tableComboBox.getSelectedItem();
            if (database != null && database.length() > 0 && table != null && table.length() > 0) {
                if (this.autoloadCheckBox.isSelected()) {
                    this.parent.getDataPane().populateTable(table);
                } else {
                    this.parent.getDataPane().setSQLStatement(table);
                }
            }
        }
        return result;
    }

    public void setupOptions(boolean save) {
        if (save) {
            this.parent.configHandler.putComboBox("User", this.userComboBox);
            this.parent.configHandler.putComboBox("Driver", this.driverComboBox);
            this.parent.configHandler.putComboBox("Host", this.hostComboBox);
            this.parent.configHandler.putComboBox("Database", this.databaseComboBox);
            this.parent.configHandler.putComboBox("Table", this.tableComboBox);
            this.parent.configHandler.putSingleValue("SelectedDatabase", (String)this.databaseComboBox.getSelectedItem());
            this.parent.configHandler.putSingleValue("SelectedTable", (String)this.tableComboBox.getSelectedItem());
            this.parent.configHandler.putSingleValue("SelectedHost", (String)this.hostComboBox.getSelectedItem());
            this.parent.configHandler.putSingleValue("SelectedDriver", (String)this.driverComboBox.getSelectedItem());
            this.parent.configHandler.putCheckBox("AutoLoad", this.autoloadCheckBox);
            this.parent.configHandler.putCheckBox("ReadOnly", this.readOnlyCheckBox);
            this.parent.configHandler.putCheckBox("SavePassword", this.savePasswordCheckBox);
            if (this.savePasswordCheckBox.isSelected()) {
                String alternateFormat = this.charToInt(this.formatString(this.passwordTextField.getText()));
                this.parent.configHandler.putSingleValue("AlternateFormat", alternateFormat);
            }
            this.parent.configHandler.putSingleValue("FormRows", (String)this.parent.dataPane.getOptionsBox().getSelectedItem());
            this.parent.configHandler.putSingleInt("DataEditMode", this.parent.dataPane.dataTabbedPane.getSelectedIndex());
            this.parent.configHandler.putCheckBox("LogLongForm", this.parent.logPanel.longFormCheckBox);
        } else {
            this.parent.configHandler.getComboBox("User", this.userComboBox);
            this.parent.configHandler.getComboBox("Driver", this.driverComboBox);
            this.parent.configHandler.getComboBox("Host", this.hostComboBox);
            this.parent.configHandler.getComboBox("Database", this.databaseComboBox);
            this.parent.configHandler.getComboBox("Table", this.tableComboBox);
            String sel = this.parent.configHandler.getSingleValue("SelectedDatabase");
            if (sel != null) {
                this.parent.setSelectedItem(this.databaseComboBox, sel);
            }
            if ((sel = this.parent.configHandler.getSingleValue("SelectedTable")) != null) {
                this.parent.setSelectedItem(this.tableComboBox, sel);
            }
            if ((sel = this.parent.configHandler.getSingleValue("SelectedHost")) != null) {
                this.parent.setSelectedItem(this.hostComboBox, sel);
            }
            if ((sel = this.parent.configHandler.getSingleValue("SelectedDriver")) != null) {
                this.parent.setSelectedItem(this.driverComboBox, sel);
            }
            this.parent.configHandler.getCheckBox("AutoLoad", this.autoloadCheckBox);
            this.parent.configHandler.getCheckBox("ReadOnly", this.readOnlyCheckBox);
            this.parent.configHandler.getCheckBox("SavePassword", this.savePasswordCheckBox);
            if (this.savePasswordCheckBox.isSelected()) {
                this.passwordTextField.setText(this.formatString(this.intToChar(this.parent.configHandler.getSingleValue("AlternateFormat"))));
            }
            if ((sel = this.parent.configHandler.getSingleValue("FormRows")) != null) {
                this.parent.dataPane.getOptionsBox().setSelectedItem(sel);
            }
            this.parent.dataPane.dataTabbedPane.setSelectedIndex(this.parent.configHandler.getSingleInt("DataEditMode"));
            this.parent.configHandler.getCheckBox("LogLongForm", this.parent.logPanel.longFormCheckBox);
        }
    }

    private boolean makeConnection() {
        return this.getConnection((String)this.hostComboBox.getSelectedItem(), (String)this.databaseComboBox.getSelectedItem(), (String)this.userComboBox.getSelectedItem(), this.passwordTextField.getText());
    }

    public boolean getConnection(String host, String database, String user, String password) {
        this.setupDriverTag();
        boolean result = false;
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.parent.clearMessage();
            }
            catch (SQLException e) {
                this.parent.putMessage("Close old connection", e);
                return result;
            }
        }
        if (!this.driverLoaded) {
            this.loadDriver();
        }
        try {
            String url = null;
            if (host != null) {
                url = host + "/";
                url = url.replaceAll("//$", "/");
            }
            if (database != null && database.length() > 0) {
                url = url + database;
            }
            if (url != null && url.length() > 1) {
                this.connection = DriverManager.getConnection(url, user, password);
                result = true;
            }
            this.parent.clearMessage();
        }
        catch (SQLException e) {
            this.parent.putMessage("GetConnection", e);
            return result;
        }
        return result;
    }

    private void loadDriver() {
        String driver = this.getDriverName();
        if (driver != null && driver.length() > 0) {
            try {
                Class.forName(driver);
                this.driverLoaded = true;
                this.parent.clearMessage();
            }
            catch (ClassNotFoundException e) {
                this.parent.putMessage("Load Driver", e);
            }
        }
    }

    public boolean executeUpdate(String sqlStatement) {
        boolean result = false;
        if (this.connection == null) {
            return result;
        }
        try {
            Statement s = this.connection.createStatement();
            s.execute(sqlStatement);
            s.close();
            result = true;
            this.parent.clearMessage();
        }
        catch (SQLException e) {
            this.parent.putMessage("SQL Update", e);
        }
        return result;
    }

    public ResultSet executeQuery(String sqlStatement) {
        ResultSet rs = null;
        if (this.connection == null) {
            return rs;
        }
        try {
            Statement s = this.connection.createStatement(1004, 1008);
            rs = s.executeQuery(sqlStatement);
            this.parent.clearMessage();
        }
        catch (SQLException e) {
            this.parent.putMessage("SQL Query", e);
        }
        return rs;
    }

    public String getDriverName() {
        return (String)this.driverComboBox.getSelectedItem();
    }

    String charToInt(String s) {
        StringBuffer sb = new StringBuffer();
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                sb.append((i > 0 ? "," : "") + "" + Integer.toHexString(s.charAt(i)));
            }
        }
        return sb.toString();
    }

    String intToChar(String s) {
        StringBuffer sb = new StringBuffer();
        if (s != null) {
            String[] tokens = s.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                try {
                    int c = Integer.parseInt(tokens[i], 16);
                    sb.append((char)c);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    String formatString(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            sb.append((char)(c ^= i + 63));
        }
        return sb.toString();
    }

    public void checkReadOnly() {
        this.parent.readOnly = this.readOnlyCheckBox.isSelected();
        this.parent.dataPane.checkReadOnly();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.userComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.driverComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.databaseComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.tableComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.hostComboBox = new JComboBox();
        this.autoloadCheckBox = new JCheckBox();
        this.savePasswordCheckBox = new JCheckBox();
        this.readOnlyCheckBox = new JCheckBox();
        this.quitButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Configuration"));
        this.jLabel1.setText("User");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.userComboBox.setEditable(true);
        this.userComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.userComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.userComboBox, gridBagConstraints);
        this.jLabel2.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.passwordTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.passwordTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.passwordTextField, gridBagConstraints);
        this.jLabel3.setText("Driver");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.driverComboBox.setEditable(true);
        this.driverComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.driverComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.driverComboBox, gridBagConstraints);
        this.jLabel4.setText("Database");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.databaseComboBox.setEditable(true);
        this.databaseComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.databaseComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.databaseComboBox, gridBagConstraints);
        this.jLabel5.setText("Table");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 11;
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.tableComboBox.setEditable(true);
        this.tableComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.tableComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tableComboBox, gridBagConstraints);
        this.jLabel6.setText("Host");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.hostComboBox.setEditable(true);
        this.hostComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.hostComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        this.autoloadCheckBox.setText("AutoLoad");
        this.autoloadCheckBox.setToolTipText("Automatically load tables");
        this.autoloadCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.autoloadCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 11;
        this.add((Component)this.autoloadCheckBox, gridBagConstraints);
        this.savePasswordCheckBox.setText("Store Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.savePasswordCheckBox, gridBagConstraints);
        this.readOnlyCheckBox.setText("Read-Only");
        this.readOnlyCheckBox.setToolTipText("Don't allow changes to databases");
        this.readOnlyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.readOnlyCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.readOnlyCheckBox, gridBagConstraints);
        this.quitButton.setText("Quit");
        this.quitButton.setToolTipText("Exit DataProspector");
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.quitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.quitButton, gridBagConstraints);
    }

    private void quitButtonActionPerformed(ActionEvent evt) {
        this.parent.performExit();
    }

    private void readOnlyCheckBoxActionPerformed(ActionEvent evt) {
        this.checkReadOnly();
    }

    private void autoloadCheckBoxActionPerformed(ActionEvent evt) {
        this.updateUserData(true);
    }

    private void hostComboBoxActionPerformed(ActionEvent evt) {
        this.updateUserData(false);
    }

    private void driverComboBoxActionPerformed(ActionEvent evt) {
        this.driverLoaded = false;
        this.updateUserData(false);
    }

    private void userComboBoxActionPerformed(ActionEvent evt) {
        this.updateUserData(false);
    }

    private void passwordTextFieldActionPerformed(ActionEvent evt) {
        this.updateUserData(false);
    }

    private void tableComboBoxActionPerformed(ActionEvent evt) {
        this.updateUserData(true);
    }

    private void databaseComboBoxActionPerformed(ActionEvent evt) {
        this.updateUserData(false);
    }
}

