/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.Complex;
import fftexplorer.FFTPrecalc;
import java.util.Vector;

public final class FFT {
    private int size = 0;
    private boolean valid = false;
    private Complex[] in_data = null;
    private Complex[] out_data = null;
    private Vector<FFTPrecalc> fftPrecalc;
    FFTPrecalc tcalc;
    private final double pi2 = Math.PI * 2;
    private double scale;
    private double fft_pi2;
    private boolean inverse;

    boolean test_pwr2(int n2) {
        return n2 >= 2 && (n2 & n2 - 1) == 0;
    }

    int rev_bits(int index, int size) {
        int rev = 0;
        while (size > 1) {
            rev = rev << 1 | index & 1;
            index >>= 1;
            size >>= 1;
        }
        return rev;
    }

    public void initialize(int n2, boolean inverse) {
        this.inverse = inverse;
        this.fft_pi2 = inverse ? Math.PI * -2 : Math.PI * 2;
        try {
            if (this.size != n2) {
                if (!this.test_pwr2(n2)) {
                    throw new Exception("Error: array size is not a power of 2\n");
                }
                this.size = n2;
                this.valid = true;
                this.in_data = new Complex[n2];
                this.out_data = new Complex[n2];
                this.scale = 1.0 / (double)this.size;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Complex tc = new Complex();
                    int rb = this.rev_bits(i2, n2);
                    this.in_data[i2] = tc;
                    this.out_data[rb] = tc;
                }
                this.fftPrecalc = new Vector();
                int imax = 1;
                while (imax < this.size) {
                    this.tcalc = new FFTPrecalc(imax, this.fft_pi2);
                    this.fftPrecalc.add(this.tcalc);
                    imax = this.tcalc.istep;
                }
            }
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ": Error: " + e2);
        }
    }

    void resize(int n2, boolean inverse) {
        this.initialize(n2, inverse);
    }

    boolean valid() {
        return this.valid;
    }

    int size() {
        return this.size;
    }

    public Complex[] inputArray() {
        return this.in_data;
    }

    public Complex[] outputArray() {
        return this.out_data;
    }

    void fft1() {
        if (this.valid && this.out_data != null) {
            Complex tc = new Complex();
            for (FFTPrecalc this.tcalc : this.fftPrecalc) {
                int imax = this.tcalc.imax;
                int istep = this.tcalc.istep;
                double wpr = this.tcalc.wpr;
                double wpi = this.tcalc.wpi;
                double wr = 1.0;
                double wi = 0.0;
                for (int m2 = 0; m2 < imax; ++m2) {
                    for (int i2 = m2; i2 < this.size; i2 += istep) {
                        int j2 = i2 + imax;
                        Complex ac = this.out_data[j2];
                        Complex bc = this.out_data[i2];
                        tc.re = wr * ac.re - wi * ac.im;
                        tc.im = wr * ac.im + wi * ac.re;
                        ac.re = bc.re - tc.re;
                        ac.im = bc.im - tc.im;
                        bc.add(tc);
                    }
                    double wtemp = wr;
                    wr = wtemp * wpr - wi * wpi + wr;
                    wi = wi * wpr + wtemp * wpi + wi;
                }
            }
            if (!this.inverse) {
                for (int k2 = 0; k2 < this.size; ++k2) {
                    this.out_data[k2].mult(this.scale);
                }
            }
        }
    }
}

