/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.AudioFileFilter;
import fftexplorer.FFTExplorer;
import java.io.File;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JFileChooser;

public class MP3Stream {
    boolean playing = false;
    boolean suspend = false;
    FFTExplorer parent;
    Thread streamThread = null;
    int sampleRate;

    public MP3Stream(FFTExplorer p) {
        this.parent = p;
    }

    public boolean playing() {
        return this.playing;
    }

    public int sampleRate() {
        return this.sampleRate;
    }

    public void suspend(boolean susp) {
        this.suspend = susp;
    }

    public void stopStream() {
        this.playing = false;
        if (this.streamThread != null) {
            try {
                this.streamThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamThread = null;
        }
        this.parent.streamMP3ButtonControl(false);
    }

    String chooseSoundFile(String currentSelection) {
        String result = null;
        JFileChooser chooser = new JFileChooser();
        boolean changed = this.parent.changeLookAndFeel(chooser);
        AudioFileFilter filter = new AudioFileFilter();
        chooser.setFileFilter(filter);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(this.parent.appName + ": Choose Sound File");
        chooser.setApproveButtonText("Accept");
        chooser.setCurrentDirectory(new File(this.parent.sv_soundSourceDirectory));
        if (currentSelection != null) {
            chooser.setSelectedFile(new File(currentSelection));
        }
        int returnVal = chooser.showOpenDialog(this.parent);
        if (changed) {
            this.parent.restoreSystemLookAndFeel();
        }
        if (returnVal == 0) {
            try {
                this.parent.sv_soundSourceDirectory = chooser.getSelectedFile().getCanonicalPath();
                result = chooser.getSelectedFile().toString();
            }
            catch (Exception e2) {
                System.out.println(e2);
            }
        }
        return result;
    }

    public void streamMP3(final int arraySize) {
        this.stopStream();
        this.playing = true;
        final String filePath = this.chooseSoundFile(this.parent.sv_soundSourceDirectory);
        if (filePath != null) {
            this.streamThread = new Thread(){

                public void run() {
                    MP3Stream.this.streamMP3Thread(filePath, arraySize);
                }
            };
            this.streamThread.start();
        }
    }

    public void streamMP3Thread(String filePath, int arraySize) {
        try {
            this.suspend = false;
            this.parent.signalProcessor.initialize(false);
            Vector<Float> vf = new Vector<Float>();
            AudioInputStream in = AudioSystem.getAudioInputStream(new File(filePath));
            AudioFormat baseFormat = in.getFormat();
            this.sampleRate = (int)baseFormat.getSampleRate();
            this.parent.setSampleRate();
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            AudioInputStream stream = AudioSystem.getAudioInputStream(decodedFormat, in);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, decodedFormat);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(decodedFormat);
            if (line != null) {
                byte[] data = new byte[arraySize];
                line.start();
                int nBytesRead = 0;
                this.parent.mp3StreamProgressBar.setString("Relative Length");
                this.parent.mp3StreamProgressBar.setStringPainted(true);
                while (this.playing && nBytesRead != -1) {
                    if (this.suspend) {
                        Thread.sleep(250L);
                        continue;
                    }
                    nBytesRead = stream.read(data, 0, data.length);
                    if (nBytesRead == -1) continue;
                    line.write(data, 0, nBytesRead);
                    int msp = (int)line.getMicrosecondPosition() / 1000000;
                    this.parent.mp3StreamProgressBar.setValue(msp %= 100);
                    for (int i2 = 0; i2 < nBytesRead; i2 += 4) {
                        float a2 = data[i2 + 1] << 8 | data[i2] & 0xFF;
                        float b2 = data[i2 + 3] << 8 | data[i2 + 2] & 0xFF;
                        vf.add(Float.valueOf((a2 + b2) / 2.0f));
                    }
                    this.parent.signalProcessor.readAudio(vf);
                }
            } else {
                throw new Exception("streamMP3Thread: line.open() failed");
            }
            line.drain();
            line.stop();
            line.close();
            line = null;
            stream.close();
            this.parent.streamMP3ButtonControl(false);
        }
        catch (Exception e2) {
            System.out.println("Problem playing file " + filePath + ": " + e2);
            e2.printStackTrace();
        }
    }
}

