/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package fftexplorer;

import java.io.File.*;
import javax.swing.filechooser.*;

/**
 *
 * @author lutusp
 */
public class AudioFileFilter extends FileFilter {

    //Accept all directories and all gif, jpg, tiff, or png files.
    public boolean accept(java.io.File f) {
        if (f.isDirectory()) {
            return true;
        }

        String extension = getExtension(f.getName());
        if (extension != null) {
            if (extension.equals("mp3") ||
                    extension.equals("mpeg3") ||
                    extension.equals("aiff") ||
                    extension.equals("aifc") ||
                    extension.equals("au") ||
                    extension.equals("snd") ||
                    extension.equals("wav")) {
                return true;
            } else {
                return false;
            }
        }

        return false;
    }

    String getExtension(String s) {
        return s.replaceFirst(".*\\.(.*)", "$1").toLowerCase();
    }

    public String getDescription() {
        return "Audio Files";
    }
}
