/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fftexplorer;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author lutusp
 */
public class ColorButton {

    Color col;
    JButton button;
    FFTExplorer parent;

    public ColorButton(FFTExplorer p, JButton button, Color col, String tip) {
        this.col = col;
        init(p, button, tip);
    }

    public ColorButton(FFTExplorer p, JButton button, String s, String tip) {
        this.col = new Color(Integer.parseInt(s));
        init(p, button, tip);
    }

    public ColorButton(FFTExplorer p, JButton button, int c, String tip) {
        this.col = new Color(c);
        init(p, button, tip);
    }

    void init(FFTExplorer p, JButton button, String tip) {
        this.parent = p;
        this.button = button;
        button.setToolTipText(tip);

        button.addMouseListener(new java.awt.event.MouseAdapter() {

            @Override
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                handleMouseClicked(evt);
            }
        });
        paintButton();
    }

    // all this because you can't define colors
    // for Swing buttons
    void paintButton() {
        int rgb = col.getRGB();
        String hex = Integer.toHexString(rgb);
        if (hex.length() == 8) {
            hex = hex.substring(2, 8);
        }
        String str = "<html><span style=\"background:#" +
                hex + ";\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>";
        button.setText(str);
        parent.repaint();
    }

    void handleMouseClicked(MouseEvent evt) {
        Color cc = JColorChooser.showDialog(parent, "Choose a color", col);
        if (cc != null) {
            col = cc;
            paintButton();
        }
    }

    @Override
    public String toString() {
        return "" + col.getRGB();
    }

    public void setColor(String s) {
        col = new Color(Integer.parseInt(s));
        paintButton();
    }

    public void setColor(Color c) {
        col = c;
        paintButton();
    }

    public Color getColor() {
        return col;
    }
}
