/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package fftexplorer;

import javax.swing.*;
import java.awt.event.*;

/**
 *
 * @author lutusp
 */
final public class ComboControl {

    JComboBox box;
    GraphicControl parent;
    String tip = "Spin mouse wheel to change";

    public ComboControl(GraphicControl p, JComboBox box) {
        parent = p;
        this.box = box;
        box.setToolTipText(tip);
        box.addMouseWheelListener(new java.awt.event.MouseWheelListener() {

            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                handleMouseWheelMoved(evt);
            }
        });
    }

    void handleMouseWheelMoved(MouseWheelEvent evt) {
        int n = box.getSelectedIndex();
        int top = box.getItemCount();
        int delta = evt.getWheelRotation();
        n -= delta;
        n = Math.max(0, n);
        n = Math.min(n, top - 1);
        box.setSelectedIndex(n);
        parent.adjustControls();
    }
}
