/*
 * Decompiled with CFR 0.152.
 */
package jdbclient;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import jdbclient.Beep;
import jdbclient.ConfigManager;
import jdbclient.CustomJPanel;
import jdbclient.EditFunctions;
import jdbclient.Executable;
import jdbclient.ExportMethods;
import jdbclient.HistoryEngine;
import jdbclient.MyHelpPane;
import jdbclient.MyJTable;
import jdbclient.MySplitPane;
import jdbclient.MyTableCellRenderer;
import jdbclient.ParseComLine;
import jdbclient.QueryControlRow;
import jdbclient.QueryProcessor;
import jdbclient.TerminalFunctions;

public final class JDBClient
extends JFrame
implements Executable {
    boolean debug = false;
    final String VERSION = "2.7";
    static final long serialVersionUID = 1128L;
    final String appName;
    final String programName;
    String appDir;
    String appPath;
    String fileSep;
    String lineSep;
    String userDir;
    String userPath;
    String initPath;
    String webPageDir = "web_pages";
    String webPagePath;
    final String[] queryTableToolTips;
    ConfigManager config;
    String serverName = null;
    String userName = null;
    String password = null;
    String serverPort = null;
    boolean inhibit = true;
    ArrayList<String> dbNames;
    ArrayList<String> tableNames;
    QueryProcessor tableDescriptionQuery = null;
    QueryProcessor sv_currentQuery = null;
    QueryProcessor logQuery;
    int charWidth;
    int charHeight;
    int[] logColumnWidths;
    int tablePaddingConstant = 4;
    Color tableBorderColor;
    Color tableHeaderColor;
    Color selectedColor;
    Color hoverColor;
    Color[] oddeven;
    JFrame sv_mainFrame;
    ParseComLine parseComs;
    Font baseFont;
    int maxFontSize = 32;
    String baseFontName = "Monospaced";
    EditFunctions editFunctions;
    Component currentTab = null;
    int oldDatabaseIndex = -1;
    int oldTableIndex = -1;
    Color changedColor;
    Color changedBColor;
    TerminalFunctions terminal;
    String unicodeSpec = "useUnicode=true&characterEncoding=utf8";
    double sv_dividerLocation = 0.5;
    MyHelpPane sv_helpPane;
    boolean allFieldsSelected;
    Image appIcon;
    final String[][] escapeChars;
    HistoryEngine sv_termEngine;
    HistoryEngine sv_prefixEngine;
    HistoryEngine sv_postfixEngine;
    MyTableCellRenderer mtcr = null;
    private JButton addKeyButton;
    protected JLabel changedRecordsLabel;
    private JButton clearHistoriesButton;
    private JButton clearHistoryButton;
    protected JButton connectButton;
    private JButton copyHTMLButton;
    private JButton copyQueryButton;
    private JButton copyTSVButton;
    private JPanel editButtonPanel;
    protected JButton editCancelButton;
    protected JButton editCommitButton;
    protected JPanel editControlPanel;
    protected JButton editCopyButton;
    protected JButton editDeleteButton;
    protected JButton editNewButton;
    protected JScrollPane editScrollPane;
    protected JPanel editingPanel;
    private JButton helpButton;
    private JPanel helpPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JButton launchBrowserButton;
    private JButton logCclearButton;
    private JButton logCopyButton;
    private JLabel logEntriesLabel;
    private JTable logTable;
    private JScrollPane logTableScrollPane;
    private JSplitPane mainSplitPane;
    protected JButton nextButton;
    private JLabel passwordLabel;
    protected JTextField passwordTextField;
    private JLabel portLabel;
    protected JButton priorButton;
    private JPanel queryBottomPanel;
    private JButton queryButton;
    private JButton queryClearButton;
    protected JPanel queryLayoutPanel;
    protected JPanel queryMiddlePanel;
    private JPanel queryPanel;
    protected JTable queryResultTable;
    protected JScrollPane queryScrollPane;
    private JLabel queryShowLabel;
    private JPanel queryTopPanel;
    private JButton quitButton;
    private JButton restartButton;
    protected JLabel selectedRecordLabel;
    private JLabel serverLabel;
    private JPanel setupLogPanel;
    private JPanel setupPanelTop;
    private JPanel setupSubPanel;
    private JLabel statusLabel;
    private JPanel statusMainPanel;
    protected JComboBox<String> sv_databaseComboBox;
    protected JCheckBox sv_editAllowCheckBox;
    protected JComboBox<Integer> sv_fontSizeComboBox;
    protected JCheckBox sv_logEllipsizeCheckBox;
    protected JTabbedPane sv_mainTabbedPane;
    protected JTextField sv_portTextField;
    protected JTextField sv_serverTextField;
    protected JComboBox<String> sv_tableComboBox;
    protected JCheckBox sv_tableDescriptionEllipsizeCheckBox;
    protected JCheckBox sv_tableEllipsizeCheckBox;
    protected JCheckBox sv_termWrapCheckBox;
    protected JTextField sv_userTextField;
    protected JCheckBox sv_wordWrapCheckBox;
    private JPanel tabbedPanel;
    private JButton tableBackupButton;
    private JPanel tableDescriptionBottomPanel;
    private JButton tableDescriptionCopyButton;
    private JLabel tableDescriptionLabel;
    private JPanel tableDescriptionMainPanel;
    private JPanel tableDescriptionPanel;
    private JScrollPane tableDescriptionScrollPane;
    private JTable tableDescriptionTable;
    private JPanel tablePanel;
    private JScrollPane tableScrollPane;
    private JPanel tableTabPanel;
    private JButton termCopyButton;
    private JButton terminalClearButton;
    protected JTextField terminalCommandTextField;
    private JPanel terminalControlPanel;
    private JPanel terminalMainPanel;
    private JPanel terminalPanel;
    protected JTextArea terminalTextDisplay;
    private JPanel topControlPanel;
    private JLabel userLabel;

    public JDBClient(String[] args) {
        this.parseComs = new ParseComLine(this, args);
        this.inhibit = true;
        this.queryTableToolTips = new String[]{"The table field to which this row applies", "Logical \"And\"", "Logical \"Or\"", "<html>Enter first query argument for \"%s\" field<br/>May be blank, \"Enter\" executes, arrow keys move vertically", "Logical \"And\"", "Logical \"Or\"", "<html>Enter second query argument for \"%s\" field<br/>May be blank, \"Enter\" executes, arrow keys move vertically", "Include \"%s\" field in query result table"};
        this.escapeChars = new String[][]{{"\\\\b", "\b"}, {"\\\\t", "\t"}, {"\\\\n", "\n"}, {"\\\\f", "\f"}, {"\\\\r", "\r"}};
        this.appName = this.getClass().getSimpleName();
        URL url = this.getClass().getResource(this.appName + ".class");
        this.appPath = url.getPath().replaceFirst("(.*?)!.*", "$1");
        this.appPath = this.appPath.replaceFirst("file:", "");
        this.appPath = new File(this.appPath).getPath();
        this.appDir = new File(this.appPath).getParent();
        this.programName = this.appName + " Version " + "2.7";
        this.setTitle(this.programName);
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.userDir = System.getProperty("user.home");
        this.userPath = this.userDir + this.fileSep + "." + this.appName;
        this.initPath = this.userPath + this.fileSep + this.appName + ".ini";
        new File(this.userPath).mkdirs();
        this.webPagePath = this.userDir + this.fileSep + "." + this.appName + this.fileSep + this.webPageDir;
        new File(this.webPagePath).mkdirs();
        this.initComponents();
        this.mtcr = new MyTableCellRenderer(this, true, false);
        this.setTabToolTips();
        this.setSize(800, 400);
        this.tableBorderColor = new Color(0, 0, 0);
        this.tableHeaderColor = new Color(150, 177, 131);
        this.hoverColor = new Color(255, 239, 152);
        this.selectedColor = new Color(192, 240, 255);
        this.changedColor = new Color(160, 0, 0);
        this.changedBColor = new Color(255, 240, 240);
        this.oddeven = new Color[]{new Color(191, 222, 185), new Color(246, 255, 218)};
        this.appIcon = new ImageIcon(this.getClass().getResource("icons/" + this.appName + ".png")).getImage();
        this.setIconImage(this.appIcon);
        this.preConfigInitialize();
        this.sv_helpPane = new MyHelpPane(this);
        this.helpPanel.add(this.sv_helpPane);
        this.config = new ConfigManager(this);
        this.config.read();
        this.setDefaultTableContent(this.queryResultTable, "Select a database");
        this.setDefaultTableContent(this.tableDescriptionTable, "Select a table");
        this.instantiateJDBC();
        this.inhibit = false;
        this.parseComs.process1();
        this.resetFontSize(false);
        this.setDefaultLogTableContent();
        this.logTable.setDefaultRenderer(Object.class, new MyTableCellRenderer(this, false, true));
        this.tableDescriptionTable.setDefaultRenderer(Object.class, new MyTableCellRenderer(this, false, true));
        this.editFunctions = new EditFunctions(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDBClient.this.readDatabaseList(true);
                JDBClient.this.parseComs.process2();
                JDBClient.this.performTabActions(null);
            }
        });
    }

    @Override
    public void execute(String text) {
        this.formatRunQuery();
    }

    protected String makeDBUrl(String sdb) {
        String result = sdb == null ? String.format("jdbc:mysql://%s:%s?%s", this.serverName, this.serverPort, this.unicodeSpec) : String.format("jdbc:mysql://%s:%s/%s?%s", this.serverName, this.serverPort, sdb, this.unicodeSpec);
        if (this.debug) {
            this.p("connection url: " + result);
        }
        return result;
    }

    private void resetFontSize(boolean commit) {
        if (!this.inhibit) {
            this.baseFont = new Font(this.baseFontName, 0, (Integer)this.sv_fontSizeComboBox.getSelectedItem());
            this.setFont(this.baseFont);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.charWidth = fontMetrics.charWidth('X');
            this.charHeight = fontMetrics.getHeight();
            if (commit && this.tableDescriptionQuery != null && this.logQuery != null) {
                this.sv_currentQuery.populateResultTable(false);
                this.tableDescriptionQuery.populateResultTable(false);
                this.logQuery.populateResultTable(true);
                this.sv_currentQuery.populateQueryPanel(this.tableDescriptionQuery);
            }
            this.terminal.setFont();
            this.sv_helpPane.setFont();
        }
    }

    private void setTabToolTips() {
        String[] tips = new String[]{"Setup server, user, password and read system log", "View query result table", "Edit and enter records", "Perform queries", "Examine table descriptions", "Execute SQL commands in a terminal", "Read help file"};
        int i = 0;
        for (String s : tips) {
            this.sv_mainTabbedPane.setToolTipTextAt(i, s);
            ++i;
        }
    }

    private void instantiateJDBC() {
        block2: {
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (!this.debug) break block2;
                e.printStackTrace(System.out);
            }
        }
    }

    private int testState() {
        int state = 0;
        this.serverName = this.getTextFieldContent(this.sv_serverTextField);
        this.userName = this.getTextFieldContent(this.sv_userTextField);
        this.password = this.getTextFieldContent(this.passwordTextField);
        this.serverPort = this.getTextFieldContent(this.sv_portTextField);
        if (this.stringIsValid(this.serverName)) {
            ++state;
        }
        if (this.stringIsValid(this.userName)) {
            ++state;
        }
        if (this.stringIsValid(this.password)) {
            ++state;
        }
        return state;
    }

    protected boolean readDatabaseList(boolean proceed) {
        if (!this.inhibit) {
            if (this.testState() < 3) {
                this.sv_mainTabbedPane.setSelectedIndex(0);
            } else {
                try {
                    this.reset();
                    QueryProcessor qr = new QueryProcessor(this, null, false);
                    this.getQueryResult(qr, "", "", "show databases", null, false);
                    this.dbNames = new ArrayList();
                    this.populateComboBox(qr, this.sv_databaseComboBox, this.dbNames);
                    this.setDefaultTableContent(this.queryResultTable, "Select a database");
                    if (proceed) {
                        this.readTableList();
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        return false;
    }

    protected boolean askAbandonEdit() {
        return this.editFunctions == null || this.editFunctions.askAbandonEdit();
    }

    protected void readTableList() {
        if (!this.inhibit) {
            if (this.askAbandonEdit()) {
                this.reset();
                this.oldDatabaseIndex = this.sv_databaseComboBox.getSelectedIndex();
                String db = (String)this.sv_databaseComboBox.getSelectedItem();
                QueryProcessor qr = new QueryProcessor(this, null, false);
                this.getQueryResult(qr, db, "", "show tables", null, false);
                this.tableNames = new ArrayList();
                this.populateComboBox(qr, this.sv_tableComboBox, this.tableNames);
                this.setDefaultTableContent(this.queryResultTable, "Select a table");
            } else {
                this.inhibit = true;
                this.sv_databaseComboBox.setSelectedIndex(this.oldDatabaseIndex);
                this.inhibit = false;
            }
        }
    }

    protected void tableSelected() {
        if (!this.inhibit) {
            if (this.askAbandonEdit()) {
                this.reset();
                this.oldTableIndex = this.sv_tableComboBox.getSelectedIndex();
                this.getTableDescription(true);
                this.setDefaultTableContent(this.queryResultTable, "Run query");
            } else {
                this.inhibit = true;
                this.sv_tableComboBox.setSelectedIndex(this.oldTableIndex);
                this.inhibit = false;
            }
        }
    }

    protected void reset() {
        this.sv_currentQuery.reset();
        this.sv_currentQuery.populateQueryPanel(null);
        if (this.editFunctions != null) {
            this.editFunctions.reset();
        }
    }

    protected void getTableDescription(boolean populateQuery) {
        String db = (String)this.sv_databaseComboBox.getSelectedItem();
        String table = (String)this.sv_tableComboBox.getSelectedItem();
        String query = String.format("describe `%s`.`%s`", db, table);
        this.tableDescriptionQuery = new QueryProcessor(this, this.sv_tableDescriptionEllipsizeCheckBox, false);
        this.getQueryResult(this.tableDescriptionQuery, db, table, query, this.tableDescriptionTable, false);
        this.tableDescriptionQuery.populateResultTable(false);
        this.tableDescriptionQuery.tableDescSetup();
        this.addKeyButton.setEnabled(this.tableDescriptionQuery.primaryKeyFields.isEmpty());
        this.tableDescriptionLabel.setText(String.format("Table: `%s`.`%s`", db, table));
        if (populateQuery || this.sv_currentQuery.sqlColNames.isEmpty()) {
            this.sv_currentQuery.populateQueryPanel(this.tableDescriptionQuery);
        }
    }

    protected String dataType(String key) {
        try {
            return this.tableDescriptionQuery.getRecordByFieldName(key).get(1).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    protected boolean validString(String s) {
        return s != null && s.length() > 0;
    }

    protected void backupTable() {
        String db = (String)this.sv_databaseComboBox.getSelectedItem();
        String table = (String)this.sv_tableComboBox.getSelectedItem();
        if (this.validString(db) && this.validString(table) && this.askUser(String.format("Okay to make a backup copy of \"%s.%s\"?", db, table))) {
            String newTable = String.format("%s_backup", table);
            QueryProcessor qr = new QueryProcessor(this, null, false);
            qr.setup(this.serverName, this.userName, this.password, this.serverPort, db, null, null);
            String query = String.format("CREATE TABLE `%s`.`%s` LIKE `%s`.`%s`", db, newTable, db, table);
            qr.execMySQLUpdate(query);
            query = String.format("INSERT `%s`.`%s` SELECT * FROM `%s`.`%s`", db, newTable, db, table);
            qr.execMySQLUpdate(query);
            this.readTableList();
        }
    }

    protected void queryDisp(String query) {
        this.queryShowLabel.setText(String.format("Query: %s", query));
    }

    private QueryProcessor readTable(String arg, String spec) {
        String string = spec = spec == null ? "*" : spec;
        if (!this.inhibit) {
            this.getTableDescription(false);
            String db = (String)this.sv_databaseComboBox.getSelectedItem();
            String table = (String)this.sv_tableComboBox.getSelectedItem();
            String query = String.format("SELECT %s FROM `%s`.`%s` %s", spec, db, table, arg);
            this.queryDisp(query);
            this.getQueryResult(this.sv_currentQuery, db, table, query, this.queryResultTable, true);
            this.sv_currentQuery.populateResultTable(false);
            boolean bl = this.allFieldsSelected = this.sv_currentQuery.sqlColNames.size() == this.tableDescriptionQuery.sqlData.size();
            if (this.editFunctions != null) {
                this.editFunctions.activateEdit(-1);
            }
        }
        return this.sv_currentQuery;
    }

    private void populateComboBox(QueryProcessor qr, JComboBox<String> box, ArrayList<String> array) {
        boolean old_inhibit = this.inhibit;
        this.inhibit = true;
        int index = box.getSelectedIndex();
        box.removeAllItems();
        for (ArrayList<Object> obj : qr.getData()) {
            String s = obj.get(0).toString();
            box.addItem(s);
            array.add(s);
        }
        int count = box.getItemCount();
        if (count > 0) {
            index = Math.min(index, count - 1);
            index = Math.max(0, index);
            box.setSelectedIndex(index);
        }
        this.inhibit = old_inhibit;
    }

    private void clearHistories() {
        this.sv_prefixEngine.clearHistory();
        this.sv_postfixEngine.clearHistory();
    }

    private void preConfigInitialize() {
        this.sv_mainFrame = this;
        this.sv_currentQuery = new QueryProcessor(this, this.sv_tableEllipsizeCheckBox, true);
        this.terminal = new TerminalFunctions(this);
        this.sv_prefixEngine = new HistoryEngine(this, this.sv_currentQuery.prefix, false);
        this.sv_postfixEngine = new HistoryEngine(this, this.sv_currentQuery.postfix, false);
        ArrayList<JComboBox<String>> boxen = new ArrayList<JComboBox<String>>();
        boxen.add(this.sv_databaseComboBox);
        boxen.add(this.sv_tableComboBox);
        for (JComboBox jComboBox : boxen) {
            this.setDefaultComboBoxContent(jComboBox);
        }
        this.sv_fontSizeComboBox.removeAllItems();
        for (int i = 8; i <= this.maxFontSize; ++i) {
            this.sv_fontSizeComboBox.addItem(i);
        }
        this.sv_fontSizeComboBox.setSelectedIndex(6);
        InputMap im = this.queryScrollPane.getInputMap(1);
        im.put(KeyStroke.getKeyStroke("UP"), "none");
        im.put(KeyStroke.getKeyStroke("DOWN"), "none");
        im.put(KeyStroke.getKeyStroke("LEFT"), "none");
        im.put(KeyStroke.getKeyStroke("RIGHT"), "none");
    }

    private void setDefaultComboBoxContent(JComboBox<String> box) {
        int index = box.getSelectedIndex();
        box.removeAllItems();
        for (int i = 1; i <= 50; ++i) {
            String s = String.format("-- n/a %d --", i);
            box.addItem(s);
        }
        box.setSelectedIndex(index);
    }

    private boolean stringIsValid(String s) {
        return s != null && s.length() > 0;
    }

    private String getTextFieldContent(JTextField tf) {
        String result = null;
        if (tf != null && tf.getText().length() > 0) {
            result = tf.getText();
        }
        return result;
    }

    private void getQueryResult(QueryProcessor qr, String dbName, String tableName, String query, JTable table, boolean primary) {
        qr.setup(this.serverName, this.userName, this.password, this.serverPort, dbName, tableName, table);
        qr.execMySQLQuery(query);
        if (primary) {
            dbName = dbName == null ? "" : String.format("from `%s`.", dbName);
            if (tableName == null) {
                tableName = "";
            }
            String et = this.gcFromTimeMS(qr.endTime - qr.startTime);
            this.setStatus(String.format("Read %d records %s`%s` (%s)", qr.getRecordCount(), dbName, tableName, et));
        }
    }

    protected String joinStringCollection(AbstractCollection<String> array, String token) {
        String result = null;
        Iterator<String> iter = array.iterator();
        if (iter.hasNext()) {
            StringBuilder sb = new StringBuilder(iter.next());
            while (iter.hasNext()) {
                sb.append(token).append(iter.next());
            }
            result = sb.toString();
        }
        return result;
    }

    protected void formatRunQuery() {
        this.formatRunQuery2();
        if (this.sv_currentQuery.canRestore()) {
            this.sv_currentQuery.restore();
            this.formatRunQuery2();
        }
    }

    protected String escapeQueryArg(String s) {
        for (String[] pair : this.escapeChars) {
            s = s.replaceAll(pair[0], pair[1]);
        }
        return s;
    }

    protected void formatRunQuery2() {
        String s;
        String free2;
        ArrayList<String> incFields = new ArrayList<String>();
        ArrayList<String> args = new ArrayList<String>();
        for (QueryControlRow row : this.sv_currentQuery.queryRows) {
            args = row.buildQuery(args);
            if (!row.getInclude()) continue;
            incFields.add(String.format("`%s`", row.getFieldName()));
        }
        String fields = "*";
        if (incFields.size() != this.sv_currentQuery.queryRows.size()) {
            fields = this.joinStringCollection(incFields, ",");
        }
        StringBuilder sb = new StringBuilder();
        for (String s2 : args) {
            sb.append(" ");
            sb.append(s2);
        }
        String arg = sb.toString().trim();
        String string = arg = arg.length() > 0 ? "WHERE " + arg : arg;
        if (this.sv_currentQuery.postfix != null && (free2 = this.sv_currentQuery.postfix.getText().trim()).length() > 0) {
            arg = arg + " " + free2;
        }
        String result = fields;
        if (this.sv_currentQuery.prefix != null && (s = this.sv_currentQuery.prefix.getText().trim()).length() > 0) {
            result = s;
        }
        this.readTable(arg, result);
    }

    private void setEllipsize(QueryProcessor qr, MouseEvent evt) {
        if (qr != null) {
            qr.setEllipsize((JCheckBox)evt.getSource());
        }
    }

    private void setDefaultTableContent(JTable table, String prompt) {
        table.setDefaultRenderer(Object.class, this.mtcr);
        table.setRowHeight(64);
        table.setBorder(new LineBorder(Color.red, 0));
        table.setModel(new DefaultTableModel(new Object[][]{{prompt}}, new String[]{""}));
        table.getParent().setBackground(Color.white);
        table.setAutoResizeMode(1);
    }

    protected int tableRowHeight(int n) {
        return (this.charHeight == 0 ? 12 : this.charHeight) * n + this.tablePaddingConstant * 2;
    }

    private void clearLog() {
        if (this.askUser("Okay to clear system log?")) {
            this.setDefaultLogTableContent();
        }
    }

    private void setDefaultLogTableContent() {
        String[] headers = new String[]{"DateTime", "Command", "Elapsed", "Errors"};
        this.logQuery = new QueryProcessor(this, this.sv_logEllipsizeCheckBox, false);
        this.logQuery.setup(this.serverName, this.userName, this.password, this.serverPort, null, null, this.logTable);
        this.logQuery.setup(headers);
        this.logQuery.populateResultTable(true);
        this.logEntriesLabel.setText(String.format("%d log entries", 0));
    }

    protected void logEventAction(String query, long st, long et, String errorText) {
        if (this.logQuery != null) {
            boolean error = errorText != null && errorText.length() > 0;
            this.queryShowLabel.setForeground(error ? this.changedColor : Color.black);
            if (error) {
                Beep.beep();
            }
            if (query == null) {
                query = "(none)";
            }
            String elt = this.gcFromTimeMS(et - st);
            errorText = errorText == null ? "(none)" : errorText;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            String timeStamp = sdf.format(new Date());
            String[] logEntry = new String[]{timeStamp, query, elt, errorText};
            this.logQuery.addRecord(logEntry);
            int rows = this.logTable.getRowCount();
            this.logTable.scrollRectToVisible(this.logTable.getCellRect(rows - 1, 0, true));
            this.logEntriesLabel.setText(String.format("%d log entries", rows));
        }
    }

    protected void copyQueryTableTSV() {
        if (this.queryResultTable != null) {
            String result = ExportMethods.tableToDelimText(this.queryResultTable, this.lineSep, "\t");
            this.writeToClipboard(result);
        }
    }

    protected String createHTML() {
        String result = null;
        if (this.queryResultTable != null) {
            String db = (String)this.sv_databaseComboBox.getSelectedItem();
            String table = (String)this.sv_tableComboBox.getSelectedItem();
            String title = db + "." + table;
            result = ExportMethods.tableToHTML(title, this.queryResultTable, this.lineSep, this.sv_tableEllipsizeCheckBox.isSelected());
        }
        return result;
    }

    protected void copyQueryTableHTML() {
        if (this.queryResultTable != null) {
            this.writeToClipboard(this.createHTML());
        }
    }

    protected void createTableWebPage() {
        if (this.queryResultTable != null) {
            String page = this.createHTML();
            String db = (String)this.sv_databaseComboBox.getSelectedItem();
            String table = (String)this.sv_tableComboBox.getSelectedItem();
            String path = String.format("%s/%s.%s.html", this.webPagePath, db, table);
            if (this.writeToFile(path, page)) {
                this.launchBrowser("file://" + path);
            }
        }
    }

    protected void copyQueryString() {
        if (this.sv_currentQuery != null) {
            this.writeToClipboard(this.sv_currentQuery.query);
        }
    }

    protected void copyTableDescription() {
        if (this.tableDescriptionQuery != null) {
            String result = ExportMethods.tableToDelimText(this.tableDescriptionQuery.displayTable, this.lineSep, "\t");
            this.writeToClipboard(result);
        }
    }

    protected void copyLogTable() {
        if (this.logQuery != null) {
            String result = ExportMethods.tableToDelimText(this.logQuery.displayTable, this.lineSep, "\t");
            this.writeToClipboard(result);
        }
    }

    protected void writeToClipboard(String s) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(s);
        clipboard.setContents(transferable, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeToFile(String path, String data) {
        try (FileWriter fw = new FileWriter(new File(path));){
            fw.write(data);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    protected void setStatus(String s) {
        this.statusLabel.setText(s);
    }

    public void launchBrowser(String url) {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace(System.out);
        }
    }

    protected GridBagConstraints createConstraints(int x, int y, int width, float weight, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = weight;
        gbc.weighty = 0.0;
        gbc.insets = insets != null ? insets : new Insets(0, 2, 0, 2);
        return gbc;
    }

    protected boolean askUser(String prompt) {
        Beep.beep();
        int choice = JOptionPane.showConfirmDialog(this, prompt);
        return choice == 0;
    }

    protected void tellUser(String prompt) {
        Beep.beep();
        JOptionPane.showMessageDialog(this, prompt);
    }

    protected String getUserInput(String prompt) {
        Beep.beep();
        return JOptionPane.showInputDialog(this, (Object)prompt);
    }

    protected String getUserPassword(String prompt) {
        Beep.beep();
        String pw = null;
        JLabel lbl = new JLabel(prompt);
        final JPasswordField jpf = new JPasswordField(20);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)lbl, "North");
        panel.add((Component)jpf, "South");
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        JDialog dialog = pane.createDialog(this.programName);
        dialog.setIconImage(this.appIcon);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jpf.requestFocusInWindow();
                    }
                });
            }
        });
        dialog.setVisible(true);
        if (pane != null) {
            int result = (Integer)pane.getValue();
            dialog.dispose();
            if (result == 0) {
                pw = new String(jpf.getPassword());
            }
        }
        return pw;
    }

    protected void restoreTabs() {
        this.tabbedPanel.setVisible(true);
    }

    protected void resizeEvent() {
        this.performTabActions(null);
    }

    protected int getDividerMaxLocation() {
        try {
            this.tableTabPanel.setVisible(true);
            Point hp = this.mainSplitPane.getLocationOnScreen();
            Point tp = this.tableTabPanel.getLocationOnScreen();
            int th = this.tableTabPanel.getHeight();
            int delta = tp.y + th - 10 - hp.y;
            return delta;
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (x - xa) * (yb - ya) / (xb - xa) + ya;
    }

    protected void adjustUserDividerPosition() {
        if (!this.inhibit) {
            double v;
            int max = this.mainSplitPane.getMaximumDividerLocation();
            int min = this.mainSplitPane.getMinimumDividerLocation();
            int p = this.mainSplitPane.getDividerLocation();
            double d = v = max - min == 0 ? 0.5 : this.ntrp(p, min, max, 0.0, 1.0);
            if (v >= 0.1 && v <= 0.9) {
                this.sv_dividerLocation = v;
            }
        }
    }

    protected int getUserDividerPosition() {
        int max = this.mainSplitPane.getMaximumDividerLocation();
        int min = this.mainSplitPane.getMinimumDividerLocation();
        return (int)this.ntrp(this.sv_dividerLocation, 0.0, 1.0, min, max);
    }

    protected boolean performTabActions(Component comp) {
        if (!this.inhibit) {
            String tabName;
            this.inhibit = true;
            Component ctab = comp == null ? this.sv_mainTabbedPane.getSelectedComponent() : comp;
            if (this.currentTab == this.editingPanel && ctab != this.editingPanel && !this.askAbandonEdit()) {
                this.sv_mainTabbedPane.setSelectedComponent(this.currentTab);
                this.inhibit = false;
                return false;
            }
            if (ctab == this.editingPanel && !this.allFieldsSelected) {
                if (this.currentTab != null) {
                    this.tellUser("Cannot edit records unless all fields\nare present in the query result.");
                    this.sv_mainTabbedPane.setSelectedComponent(this.currentTab);
                } else {
                    this.sv_mainTabbedPane.setSelectedComponent(this.queryPanel);
                }
                this.inhibit = false;
                return false;
            }
            this.sv_mainTabbedPane.setSelectedComponent(ctab);
            switch (tabName = ctab.getName()) {
                case "Setup": {
                    this.mainSplitPane.setDividerLocation(0);
                    break;
                }
                case "Edit": {
                    this.mainSplitPane.setDividerLocation(this.getUserDividerPosition());
                    break;
                }
                case "Query": 
                case "TableDesc": {
                    this.mainSplitPane.setDividerLocation(this.getUserDividerPosition());
                    break;
                }
                case "Table": {
                    this.mainSplitPane.setDividerLocation(this.getDividerMaxLocation());
                    break;
                }
                case "Terminal": {
                    this.mainSplitPane.setDividerLocation(0);
                    this.terminalCommandTextField.grabFocus();
                    break;
                }
                case "Help": {
                    this.mainSplitPane.setDividerLocation(0);
                }
            }
            this.currentTab = ctab;
            this.inhibit = false;
        }
        return true;
    }

    protected void manageWordWrap() {
        if (this.editFunctions != null && this.askAbandonEdit()) {
            this.editFunctions.populateEditPane();
        }
    }

    protected void toResizeEvent() {
        if (this.editFunctions != null) {
            this.editFunctions.resizeEvent();
        }
    }

    protected String gcFromTimeMS(long timeMS) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(timeMS);
        SimpleDateFormat sdf = new SimpleDateFormat(timeMS < 3600000L ? "mm:ss.SSS" : "HH:mm:ss.SSS");
        return sdf.format(gc.getTime());
    }

    private void closeApp() {
        if (this.askAbandonEdit()) {
            this.config.write();
            System.exit(0);
        }
    }

    public void p(String s) {
        System.out.println(s);
    }

    private void initComponents() {
        this.mainSplitPane = new MySplitPane(this);
        this.tablePanel = new JPanel();
        this.topControlPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.sv_databaseComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.sv_tableComboBox = new JComboBox();
        this.sv_tableEllipsizeCheckBox = new JCheckBox();
        this.tableScrollPane = new JScrollPane();
        this.queryResultTable = new MyJTable(this);
        this.tabbedPanel = new JPanel();
        this.sv_mainTabbedPane = new JTabbedPane();
        this.setupLogPanel = new JPanel();
        this.setupPanelTop = new JPanel();
        this.serverLabel = new JLabel();
        this.sv_serverTextField = new JTextField();
        this.userLabel = new JLabel();
        this.sv_userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.sv_portTextField = new JTextField();
        this.portLabel = new JLabel();
        this.setupSubPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.sv_fontSizeComboBox = new JComboBox();
        this.restartButton = new JButton();
        this.logEntriesLabel = new JLabel();
        this.sv_logEllipsizeCheckBox = new JCheckBox();
        this.logCopyButton = new JButton();
        this.logCclearButton = new JButton();
        this.logTableScrollPane = new JScrollPane();
        this.logTable = new MyJTable(this);
        this.tableTabPanel = new JPanel();
        this.editingPanel = new JPanel();
        this.editScrollPane = new JScrollPane();
        this.editControlPanel = new CustomJPanel();
        this.editButtonPanel = new JPanel();
        this.selectedRecordLabel = new JLabel();
        this.changedRecordsLabel = new JLabel();
        this.editDeleteButton = new JButton();
        this.editNewButton = new JButton();
        this.editCopyButton = new JButton();
        this.editCommitButton = new JButton();
        this.editCancelButton = new JButton();
        this.sv_editAllowCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.sv_wordWrapCheckBox = new JCheckBox();
        this.priorButton = new JButton();
        this.nextButton = new JButton();
        this.queryPanel = new JPanel();
        this.queryMiddlePanel = new JPanel();
        this.queryTopPanel = new JPanel();
        this.queryShowLabel = new JLabel();
        this.copyQueryButton = new JButton();
        this.queryClearButton = new JButton();
        this.clearHistoriesButton = new JButton();
        this.copyTSVButton = new JButton();
        this.copyHTMLButton = new JButton();
        this.launchBrowserButton = new JButton();
        this.queryScrollPane = new JScrollPane();
        this.queryLayoutPanel = new JPanel();
        this.queryBottomPanel = new JPanel();
        this.tableDescriptionPanel = new JPanel();
        this.tableDescriptionMainPanel = new JPanel();
        this.tableDescriptionScrollPane = new JScrollPane();
        this.tableDescriptionTable = new MyJTable(this);
        this.tableDescriptionBottomPanel = new JPanel();
        this.tableDescriptionLabel = new JLabel();
        this.sv_tableDescriptionEllipsizeCheckBox = new JCheckBox();
        this.addKeyButton = new JButton();
        this.tableBackupButton = new JButton();
        this.tableDescriptionCopyButton = new JButton();
        this.terminalPanel = new JPanel();
        this.terminalMainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.terminalTextDisplay = new JTextArea();
        this.terminalControlPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.terminalCommandTextField = new JTextField();
        this.sv_termWrapCheckBox = new JCheckBox();
        this.terminalClearButton = new JButton();
        this.termCopyButton = new JButton();
        this.connectButton = new JButton();
        this.clearHistoryButton = new JButton();
        this.helpPanel = new JPanel();
        this.statusMainPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.queryButton = new JButton();
        this.helpButton = new JButton();
        this.quitButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JDBClient.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JDBClient.this.formComponentResized(evt);
            }
        });
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.setToolTipText("Adjust this divider location to meet your needs");
        this.mainSplitPane.setMaximumSize(new Dimension(800, 800));
        this.tablePanel.setLayout(new BorderLayout());
        this.topControlPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Database:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.topControlPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.sv_databaseComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_databaseComboBox.setToolTipText("Choose a database");
        this.sv_databaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_databaseComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.topControlPanel.add(this.sv_databaseComboBox, gridBagConstraints);
        this.jLabel2.setText("Table:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.topControlPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.sv_tableComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_tableComboBox.setToolTipText("Choose a table");
        this.sv_tableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_tableComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.topControlPanel.add(this.sv_tableComboBox, gridBagConstraints);
        this.sv_tableEllipsizeCheckBox.setSelected(true);
        this.sv_tableEllipsizeCheckBox.setText("Ellipsize");
        this.sv_tableEllipsizeCheckBox.setToolTipText("Truncate table fields with ellipsis (...)");
        this.sv_tableEllipsizeCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.sv_tableEllipsizeCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.topControlPanel.add((Component)this.sv_tableEllipsizeCheckBox, gridBagConstraints);
        this.tablePanel.add((Component)this.topControlPanel, "North");
        this.queryResultTable.setAutoCreateRowSorter(true);
        this.queryResultTable.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.queryResultTable.setToolTipText("");
        this.queryResultTable.setAutoResizeMode(4);
        this.tableScrollPane.setViewportView(this.queryResultTable);
        this.tablePanel.add((Component)this.tableScrollPane, "Center");
        this.mainSplitPane.setTopComponent(this.tablePanel);
        this.tabbedPanel.setLayout(new BorderLayout());
        this.sv_mainTabbedPane.setTabPlacement(3);
        this.sv_mainTabbedPane.setName("sv_mainTabbedPane");
        this.sv_mainTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JDBClient.this.sv_mainTabbedPaneStateChanged(evt);
            }
        });
        this.setupLogPanel.setName("Setup");
        this.setupLogPanel.setLayout(new BorderLayout());
        this.setupPanelTop.setLayout(new GridBagLayout());
        this.serverLabel.setText("Server:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.setupPanelTop.add((Component)this.serverLabel, gridBagConstraints);
        this.sv_serverTextField.setText("localhost");
        this.sv_serverTextField.setToolTipText("Name of MySQL server");
        this.sv_serverTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_serverTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.setupPanelTop.add((Component)this.sv_serverTextField, gridBagConstraints);
        this.userLabel.setText("User:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.setupPanelTop.add((Component)this.userLabel, gridBagConstraints);
        this.sv_userTextField.setText("guest");
        this.sv_userTextField.setToolTipText("Name of user known to MySQL");
        this.sv_userTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_userTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.setupPanelTop.add((Component)this.sv_userTextField, gridBagConstraints);
        this.passwordLabel.setText("Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.setupPanelTop.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordTextField.setToolTipText("User's MySQL password");
        this.passwordTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.passwordTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.setupPanelTop.add((Component)this.passwordTextField, gridBagConstraints);
        this.sv_portTextField.setHorizontalAlignment(4);
        this.sv_portTextField.setText("3306");
        this.sv_portTextField.setToolTipText("MySQL server access port");
        this.sv_portTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_portTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.setupPanelTop.add((Component)this.sv_portTextField, gridBagConstraints);
        this.portLabel.setText("Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.setupPanelTop.add((Component)this.portLabel, gridBagConstraints);
        this.setupSubPanel.setLayout(new GridBagLayout());
        this.jLabel6.setText("Font size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.setupSubPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.sv_fontSizeComboBox.setToolTipText("Table display font size");
        this.sv_fontSizeComboBox.setMinimumSize(new Dimension(60, 24));
        this.sv_fontSizeComboBox.setPreferredSize(new Dimension(60, 24));
        this.sv_fontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_fontSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.setupSubPanel.add(this.sv_fontSizeComboBox, gridBagConstraints);
        this.restartButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/start.png")));
        this.restartButton.setText("Start/Restart");
        this.restartButton.setToolTipText("Refresh system state with new entries");
        this.restartButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.restartButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.setupSubPanel.add((Component)this.restartButton, gridBagConstraints);
        this.logEntriesLabel.setText("Log Entries");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 2);
        this.setupSubPanel.add((Component)this.logEntriesLabel, gridBagConstraints);
        this.sv_logEllipsizeCheckBox.setSelected(true);
        this.sv_logEllipsizeCheckBox.setText("Ellipsize");
        this.sv_logEllipsizeCheckBox.setToolTipText("Truncate table fields with ellipsis (...)");
        this.sv_logEllipsizeCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.sv_logEllipsizeCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.setupSubPanel.add((Component)this.sv_logEllipsizeCheckBox, gridBagConstraints);
        this.logCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/record_copy.png")));
        this.logCopyButton.setText("Copy Log");
        this.logCopyButton.setToolTipText("Copy log entries to system clipboard");
        this.logCopyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.logCopyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.setupSubPanel.add((Component)this.logCopyButton, gridBagConstraints);
        this.logCclearButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/mail-replied.png")));
        this.logCclearButton.setText("Clear Log");
        this.logCclearButton.setToolTipText("Clear log entry table");
        this.logCclearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.logCclearButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.setupSubPanel.add((Component)this.logCclearButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.setupPanelTop.add((Component)this.setupSubPanel, gridBagConstraints);
        this.setupLogPanel.add((Component)this.setupPanelTop, "North");
        this.logTable.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.logTable.setName("Log Table");
        this.logTable.setRowSelectionAllowed(false);
        this.logTableScrollPane.setViewportView(this.logTable);
        this.setupLogPanel.add((Component)this.logTableScrollPane, "Center");
        this.sv_mainTabbedPane.addTab("Setup/Log", new ImageIcon(this.getClass().getResource("/jdbclient/icons/preferences-system.png")), this.setupLogPanel);
        this.tableTabPanel.setName("Table");
        this.sv_mainTabbedPane.addTab("Table", new ImageIcon(this.getClass().getResource("/jdbclient/icons/document-edit-verify.png")), this.tableTabPanel, "View query result table");
        this.editingPanel.setName("Edit");
        this.editingPanel.setLayout(new BorderLayout());
        this.editScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JDBClient.this.editScrollPaneComponentResized(evt);
            }
        });
        this.editControlPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.editControlPanel.setLayout(new GridBagLayout());
        this.editScrollPane.setViewportView(this.editControlPanel);
        this.editingPanel.add((Component)this.editScrollPane, "Center");
        this.editButtonPanel.setLayout(new GridBagLayout());
        this.selectedRecordLabel.setText("Selected record: --");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.editButtonPanel.add((Component)this.selectedRecordLabel, gridBagConstraints);
        this.changedRecordsLabel.setText("Changed records: --");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.editButtonPanel.add((Component)this.changedRecordsLabel, gridBagConstraints);
        this.editDeleteButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/delete.png")));
        this.editDeleteButton.setText("Delete ...");
        this.editDeleteButton.setToolTipText("Delete the selected record");
        this.editDeleteButton.setIconTextGap(2);
        this.editDeleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.editDeleteButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.editDeleteButton, gridBagConstraints);
        this.editNewButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/new.png")));
        this.editNewButton.setText("New");
        this.editNewButton.setToolTipText("Create a new, empty record");
        this.editNewButton.setIconTextGap(2);
        this.editNewButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.editNewButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.editNewButton, gridBagConstraints);
        this.editCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/record_copy.png")));
        this.editCopyButton.setText("Copy");
        this.editCopyButton.setToolTipText("<html>Make a copy of a record within the table<br/>\n(Only enabled for tables with a primary key)");
        this.editCopyButton.setIconTextGap(2);
        this.editCopyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.editCopyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.editCopyButton, gridBagConstraints);
        this.editCommitButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/checkmark.png")));
        this.editCommitButton.setText("Commit");
        this.editCommitButton.setToolTipText("Commit edits to the database");
        this.editCommitButton.setIconTextGap(2);
        this.editCommitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.editCommitButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.editCommitButton, gridBagConstraints);
        this.editCancelButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/cancel.png")));
        this.editCancelButton.setText("Cancel ...");
        this.editCancelButton.setToolTipText("Cancel edit, restore original data");
        this.editCancelButton.setIconTextGap(2);
        this.editCancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.editCancelButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.editCancelButton, gridBagConstraints);
        this.sv_editAllowCheckBox.setToolTipText("This prevents inadvertent edits");
        this.sv_editAllowCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_editAllowCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.editButtonPanel.add((Component)this.sv_editAllowCheckBox, gridBagConstraints);
        this.jLabel4.setText("Allow Edits");
        this.jLabel4.setToolTipText("This prevents inadvertent edits");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.editButtonPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.sv_wordWrapCheckBox.setText("Wrap");
        this.sv_wordWrapCheckBox.setToolTipText("Wrap lines on long records");
        this.sv_wordWrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBClient.this.sv_wordWrapCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.editButtonPanel.add((Component)this.sv_wordWrapCheckBox, gridBagConstraints);
        this.priorButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/go-previous.png")));
        this.priorButton.setToolTipText("Prior record");
        this.priorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.priorButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.priorButton, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/go-next.png")));
        this.nextButton.setToolTipText("Next record");
        this.nextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.nextButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.editButtonPanel.add((Component)this.nextButton, gridBagConstraints);
        this.editingPanel.add((Component)this.editButtonPanel, "South");
        this.sv_mainTabbedPane.addTab("Edit/Enter", new ImageIcon(this.getClass().getResource("/jdbclient/icons/allow_edit.png")), this.editingPanel);
        this.queryPanel.setName("Query");
        this.queryPanel.setLayout(new GridBagLayout());
        this.queryMiddlePanel.setLayout(new BorderLayout());
        this.queryTopPanel.setLayout(new GridBagLayout());
        this.queryShowLabel.setText("Query:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.queryTopPanel.add((Component)this.queryShowLabel, gridBagConstraints);
        this.copyQueryButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/record_copy.png")));
        this.copyQueryButton.setText("Copy Q");
        this.copyQueryButton.setToolTipText("<html>Copy the text of the query to the system clipboard<br/>(also see the log on the setup/log tab)");
        this.copyQueryButton.setIconTextGap(2);
        this.copyQueryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.copyQueryButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.queryTopPanel.add((Component)this.copyQueryButton, gridBagConstraints);
        this.queryClearButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/mail-replied.png")));
        this.queryClearButton.setText("Clear Q");
        this.queryClearButton.setToolTipText("Reset query panel to defaults");
        this.queryClearButton.setIconTextGap(2);
        this.queryClearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.queryClearButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.queryTopPanel.add((Component)this.queryClearButton, gridBagConstraints);
        this.clearHistoriesButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/delete.png")));
        this.clearHistoriesButton.setText("Clear H");
        this.clearHistoriesButton.setToolTipText("Clear \"Prefix\" and \"Postfix\" entry histories");
        this.clearHistoriesButton.setIconTextGap(2);
        this.clearHistoriesButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.clearHistoriesButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.queryTopPanel.add((Component)this.clearHistoriesButton, gridBagConstraints);
        this.copyTSVButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/text-csv.png")));
        this.copyTSVButton.setText("Copy TSV");
        this.copyTSVButton.setToolTipText("Copy Tab-Separated-Values (TSV) version of result table to system clipboard");
        this.copyTSVButton.setIconTextGap(2);
        this.copyTSVButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.copyTSVButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.queryTopPanel.add((Component)this.copyTSVButton, gridBagConstraints);
        this.copyHTMLButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/text-html.png")));
        this.copyHTMLButton.setText("Copy HTML");
        this.copyHTMLButton.setToolTipText("Copy HTML version of result table to system clipboard");
        this.copyHTMLButton.setIconTextGap(2);
        this.copyHTMLButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.copyHTMLButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.queryTopPanel.add((Component)this.copyHTMLButton, gridBagConstraints);
        this.launchBrowserButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/browser.png")));
        this.launchBrowserButton.setText("Browser");
        this.launchBrowserButton.setToolTipText("Launch system browser showing HTML result table");
        this.launchBrowserButton.setIconTextGap(2);
        this.launchBrowserButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.launchBrowserButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.queryTopPanel.add((Component)this.launchBrowserButton, gridBagConstraints);
        this.queryMiddlePanel.add((Component)this.queryTopPanel, "First");
        this.queryLayoutPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.queryLayoutPanel.setLayout(new GridBagLayout());
        this.queryScrollPane.setViewportView(this.queryLayoutPanel);
        this.queryMiddlePanel.add((Component)this.queryScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.queryPanel.add((Component)this.queryMiddlePanel, gridBagConstraints);
        this.queryBottomPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.queryPanel.add((Component)this.queryBottomPanel, gridBagConstraints);
        this.sv_mainTabbedPane.addTab("Query", new ImageIcon(this.getClass().getResource("/jdbclient/icons/edit-find.png")), this.queryPanel);
        this.tableDescriptionPanel.setName("TableDesc");
        this.tableDescriptionPanel.setLayout(new BorderLayout());
        this.tableDescriptionMainPanel.setName("tableDescriptionMainPanel");
        this.tableDescriptionMainPanel.setLayout(new BorderLayout());
        this.tableDescriptionTable.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.tableDescriptionTable.setToolTipText("This panel shows the current table's technical definition");
        this.tableDescriptionTable.setIntercellSpacing(new Dimension(0, 0));
        this.tableDescriptionTable.setRowSelectionAllowed(false);
        this.tableDescriptionScrollPane.setViewportView(this.tableDescriptionTable);
        this.tableDescriptionMainPanel.add((Component)this.tableDescriptionScrollPane, "Center");
        this.tableDescriptionPanel.add((Component)this.tableDescriptionMainPanel, "Center");
        this.tableDescriptionBottomPanel.setLayout(new GridBagLayout());
        this.tableDescriptionLabel.setText("Table:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 2);
        this.tableDescriptionBottomPanel.add((Component)this.tableDescriptionLabel, gridBagConstraints);
        this.sv_tableDescriptionEllipsizeCheckBox.setSelected(true);
        this.sv_tableDescriptionEllipsizeCheckBox.setText("Ellipsize");
        this.sv_tableDescriptionEllipsizeCheckBox.setToolTipText("Truncate table fields with ellipsis (...)");
        this.sv_tableDescriptionEllipsizeCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.sv_tableDescriptionEllipsizeCheckBoxMouseClicked(evt);
            }
        });
        this.tableDescriptionBottomPanel.add((Component)this.sv_tableDescriptionEllipsizeCheckBox, new GridBagConstraints());
        this.addKeyButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/insert-link.png")));
        this.addKeyButton.setText("Add Key");
        this.addKeyButton.setToolTipText("Add primary key to this table");
        this.addKeyButton.setEnabled(false);
        this.addKeyButton.setIconTextGap(2);
        this.addKeyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.addKeyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.tableDescriptionBottomPanel.add((Component)this.addKeyButton, gridBagConstraints);
        this.tableBackupButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/document-save-as.png")));
        this.tableBackupButton.setText("Backup ...");
        this.tableBackupButton.setToolTipText("Make a backup copy of this table");
        this.tableBackupButton.setIconTextGap(2);
        this.tableBackupButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.tableBackupButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.tableDescriptionBottomPanel.add((Component)this.tableBackupButton, gridBagConstraints);
        this.tableDescriptionCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/record_copy.png")));
        this.tableDescriptionCopyButton.setText("Copy");
        this.tableDescriptionCopyButton.setToolTipText("Copy table description to system clipboard");
        this.tableDescriptionCopyButton.setIconTextGap(2);
        this.tableDescriptionCopyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.tableDescriptionCopyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.tableDescriptionBottomPanel.add((Component)this.tableDescriptionCopyButton, gridBagConstraints);
        this.tableDescriptionPanel.add((Component)this.tableDescriptionBottomPanel, "South");
        this.sv_mainTabbedPane.addTab("Table Description", new ImageIcon(this.getClass().getResource("/jdbclient/icons/code-class.png")), this.tableDescriptionPanel);
        this.terminalPanel.setName("Terminal");
        this.terminalPanel.setLayout(new BorderLayout());
        this.terminalMainPanel.setLayout(new BorderLayout());
        this.terminalTextDisplay.setColumns(20);
        this.terminalTextDisplay.setRows(5);
        this.terminalTextDisplay.setToolTipText("<html>To copy content from this display, click the \"Copy\" button below,<br/>\nor drag the mouse cursor across an area of interest and type Ctrl+C (Copy).");
        this.jScrollPane1.setViewportView(this.terminalTextDisplay);
        this.terminalMainPanel.add((Component)this.jScrollPane1, "Center");
        this.terminalPanel.add((Component)this.terminalMainPanel, "Center");
        this.terminalControlPanel.setLayout(new GridBagLayout());
        this.jLabel5.setText("Command:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.terminalControlPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.terminalCommandTextField.setToolTipText("<html>Type SQL commands<br/>\"Enter\" executes, arrow keys browse history");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.terminalControlPanel.add((Component)this.terminalCommandTextField, gridBagConstraints);
        this.sv_termWrapCheckBox.setText("Wrap lines");
        this.sv_termWrapCheckBox.setToolTipText("Enable line wrapping in terminal window");
        this.sv_termWrapCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.sv_termWrapCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.terminalControlPanel.add((Component)this.sv_termWrapCheckBox, gridBagConstraints);
        this.terminalClearButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/mail-replied.png")));
        this.terminalClearButton.setText("Clear Display");
        this.terminalClearButton.setToolTipText("Erase the terminal windows's contents");
        this.terminalClearButton.setIconTextGap(2);
        this.terminalClearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.terminalClearButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.terminalControlPanel.add((Component)this.terminalClearButton, gridBagConstraints);
        this.termCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/record_copy.png")));
        this.termCopyButton.setText("Copy");
        this.termCopyButton.setToolTipText("Copy terminal output to system clipboard");
        this.termCopyButton.setIconTextGap(2);
        this.termCopyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.termCopyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.terminalControlPanel.add((Component)this.termCopyButton, gridBagConstraints);
        this.connectButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/start.png")));
        this.connectButton.setText("Connect");
        this.connectButton.setToolTipText("<html>Connect / disconnect using the information<br/>entered on the Setup/Log pane");
        this.connectButton.setIconTextGap(2);
        this.connectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.connectButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.terminalControlPanel.add((Component)this.connectButton, gridBagConstraints);
        this.clearHistoryButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/delete.png")));
        this.clearHistoryButton.setText("Clear History");
        this.clearHistoryButton.setToolTipText("Clear command history");
        this.clearHistoryButton.setIconTextGap(2);
        this.clearHistoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.clearHistoryButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.terminalControlPanel.add((Component)this.clearHistoryButton, gridBagConstraints);
        this.terminalPanel.add((Component)this.terminalControlPanel, "South");
        this.sv_mainTabbedPane.addTab("SQL Terminal", new ImageIcon(this.getClass().getResource("/jdbclient/icons/kig.png")), this.terminalPanel);
        this.helpPanel.setName("Help");
        this.helpPanel.setLayout(new BorderLayout());
        this.sv_mainTabbedPane.addTab("Help", new ImageIcon(this.getClass().getResource("/jdbclient/icons/help.png")), this.helpPanel);
        this.tabbedPanel.add((Component)this.sv_mainTabbedPane, "Center");
        this.mainSplitPane.setBottomComponent(this.tabbedPanel);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.statusMainPanel.setLayout(new GridBagLayout());
        this.statusLabel.setText("Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 2);
        this.statusMainPanel.add((Component)this.statusLabel, gridBagConstraints);
        this.queryButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/checkmark.png")));
        this.queryButton.setText("Query");
        this.queryButton.setToolTipText("Execute the current query");
        this.queryButton.setIconTextGap(2);
        this.queryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.queryButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.statusMainPanel.add((Component)this.queryButton, gridBagConstraints);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/help.png")));
        this.helpButton.setText("Help");
        this.helpButton.setToolTipText("Visit the JDBClient home page");
        this.helpButton.setIconTextGap(2);
        this.helpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.helpButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.statusMainPanel.add((Component)this.helpButton, gridBagConstraints);
        this.quitButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/quitIcon.png")));
        this.quitButton.setText("Quit");
        this.quitButton.setToolTipText("EXit JDBClient");
        this.quitButton.setIconTextGap(2);
        this.quitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDBClient.this.quitButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.statusMainPanel.add((Component)this.quitButton, gridBagConstraints);
        this.getContentPane().add((Component)this.statusMainPanel, "South");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeApp();
    }

    private void sv_tableEllipsizeCheckBoxMouseClicked(MouseEvent evt) {
        this.setEllipsize(this.sv_currentQuery, evt);
    }

    private void restartButtonMouseClicked(MouseEvent evt) {
        this.readDatabaseList(true);
    }

    private void sv_serverTextFieldActionPerformed(ActionEvent evt) {
        this.readDatabaseList(true);
    }

    private void sv_userTextFieldActionPerformed(ActionEvent evt) {
        this.readDatabaseList(true);
    }

    private void passwordTextFieldActionPerformed(ActionEvent evt) {
        this.readDatabaseList(true);
    }

    private void sv_databaseComboBoxActionPerformed(ActionEvent evt) {
        this.readTableList();
    }

    private void sv_tableComboBoxActionPerformed(ActionEvent evt) {
        this.tableSelected();
    }

    private void sv_logEllipsizeCheckBoxMouseClicked(MouseEvent evt) {
        this.setEllipsize(this.logQuery, evt);
    }

    private void queryButtonMouseClicked(MouseEvent evt) {
        this.formatRunQuery();
    }

    private void quitButtonMouseClicked(MouseEvent evt) {
        this.closeApp();
    }

    private void helpButtonMouseClicked(MouseEvent evt) {
        this.launchBrowser("http://arachnoid.com/JDBClient");
    }

    private void sv_tableDescriptionEllipsizeCheckBoxMouseClicked(MouseEvent evt) {
        this.setEllipsize(this.tableDescriptionQuery, evt);
    }

    private void copyTSVButtonMouseClicked(MouseEvent evt) {
        this.copyQueryTableTSV();
    }

    private void copyHTMLButtonMouseClicked(MouseEvent evt) {
        this.copyQueryTableHTML();
    }

    private void launchBrowserButtonMouseClicked(MouseEvent evt) {
        this.createTableWebPage();
    }

    private void sv_fontSizeComboBoxActionPerformed(ActionEvent evt) {
        this.resetFontSize(true);
    }

    private void copyQueryButtonMouseClicked(MouseEvent evt) {
        this.copyQueryString();
    }

    private void tableDescriptionCopyButtonMouseClicked(MouseEvent evt) {
        this.copyTableDescription();
    }

    private void addKeyButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.addPrimaryKey();
    }

    private void logCopyButtonMouseClicked(MouseEvent evt) {
        this.copyLogTable();
    }

    private void sv_mainTabbedPaneStateChanged(ChangeEvent evt) {
        this.performTabActions(null);
    }

    private void sv_editAllowCheckBoxActionPerformed(ActionEvent evt) {
        this.editFunctions.setAllowEditState();
    }

    private void editCancelButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.cancelEdit();
    }

    private void editCopyButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.copyRecord();
    }

    private void editDeleteButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.deleteRecord();
    }

    private void editNewButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.newRecord();
    }

    private void editCommitButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.commitEdit();
    }

    private void connectButtonMouseClicked(MouseEvent evt) {
        this.terminal.connectDisconnect();
    }

    private void terminalClearButtonMouseClicked(MouseEvent evt) {
        this.terminal.clear();
    }

    private void sv_termWrapCheckBoxMouseClicked(MouseEvent evt) {
        this.terminal.wrapControl();
    }

    private void termCopyButtonMouseClicked(MouseEvent evt) {
        this.terminal.copyToClipboard();
    }

    private void queryClearButtonMouseClicked(MouseEvent evt) {
        this.sv_currentQuery.populateQueryPanel(this.tableDescriptionQuery);
    }

    private void clearHistoryButtonMouseClicked(MouseEvent evt) {
        this.sv_termEngine.clearHistory();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.resizeEvent();
    }

    private void tableBackupButtonMouseClicked(MouseEvent evt) {
        this.backupTable();
    }

    private void clearHistoriesButtonMouseClicked(MouseEvent evt) {
        this.clearHistories();
    }

    private void sv_portTextFieldActionPerformed(ActionEvent evt) {
        this.readDatabaseList(true);
    }

    private void logCclearButtonMouseClicked(MouseEvent evt) {
        this.clearLog();
    }

    private void sv_wordWrapCheckBoxActionPerformed(ActionEvent evt) {
        this.manageWordWrap();
    }

    private void editScrollPaneComponentResized(ComponentEvent evt) {
        this.toResizeEvent();
    }

    private void priorButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.moveToTableRowDelta(-1);
    }

    private void nextButtonMouseClicked(MouseEvent evt) {
        this.editFunctions.moveToTableRowDelta(1);
    }

    public static void main(final String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JDBClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JDBClient(args).setVisible(true);
            }
        });
    }
}

