/*
 * Decompiled with CFR 0.152.
 */
package jdbclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;
import jdbclient.Beep;
import jdbclient.Configurable;
import jdbclient.JDBClient;

public final class MyHelpPane
extends JPanel
implements Configurable {
    JDBClient parent;
    static final long serialVersionUID = 1299L;
    Stack<Integer> undoStack;
    Stack<Integer> redoStack;
    Document doc;
    String oldSearch = "";
    int oldPos = 0;
    Object oldHighlight = null;
    Highlighter highlighter;
    Highlighter.HighlightPainter highlightPainter;
    int vScrollPos = 0;
    private JTextField findTextField;
    private JScrollPane helpScrollPane;
    private JTextPane helpTextPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton redoButton;
    private JButton undoButton;

    public MyHelpPane(JDBClient p) {
        this.parent = p;
        this.initComponents();
        this.doc = this.helpTextPane.getDocument();
        this.helpTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.helpScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.highlighter = this.helpTextPane.getHighlighter();
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 255, 200));
        this.setupHelp();
        this.setButtons();
        this.setFocus();
    }

    void setFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyHelpPane.this.findTextField.requestFocus();
                MyHelpPane.this.helpScrollPane.getVerticalScrollBar().setValue(MyHelpPane.this.vScrollPos);
                MyHelpPane.this.setFont();
            }
        });
    }

    protected void setFont() {
        this.helpTextPane.setFont(this.parent.baseFont);
    }

    void setupHelp() {
        String fn = "help/JDBClientHelp.html";
        try {
            StringBuilder sb;
            try (InputStream is = this.parent.getClass().getResourceAsStream(fn);){
                String line;
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            String s = sb.toString();
            s = s.replaceAll("\\(application path\\)", this.parent.appPath.replaceAll("\\\\", "&#92;"));
            s = s.replaceAll("\\(application dir\\)", this.parent.appDir.replaceAll("\\\\", "&#92;"));
            s = s.replaceAll("\\(configuration path\\)", this.parent.initPath.replaceAll("\\\\", "&#92;"));
            s = s.replaceAll("\\(webpage path\\)", this.parent.webPagePath.replaceAll("\\\\", "&#92;"));
            s = s.replaceAll("\\(user home directory\\)", this.parent.userDir.replaceAll("\\\\", "&#92;"));
            s = s.replaceAll("\\(version\\)", this.parent.VERSION);
            this.helpTextPane.setText(s);
            this.helpTextPane.select(0, 0);
            URL url = this.parent.getClass().getResource(fn).toURI().toURL();
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(url);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace(System.out);
        }
    }

    void manageHyperlinks(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String surl = evt.getURL().toString();
            if (surl.matches("http://.*")) {
                try {
                    Desktop.getDesktop().browse(URI.create(surl));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else if (surl.matches(".*#.*")) {
                try {
                    this.pushUndo();
                    this.helpTextPane.scrollToReference(url.getRef());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    void undo() {
        if (this.undoStack.size() > 0) {
            this.removeOldHighlight();
            this.pushRedo();
            this.helpScrollPane.getVerticalScrollBar().setValue(this.undoStack.pop());
            this.setButtons();
        } else {
            Beep.beep();
        }
    }

    void redo() {
        if (this.redoStack.size() > 0) {
            this.removeOldHighlight();
            this.pushUndo();
            this.helpScrollPane.getVerticalScrollBar().setValue(this.redoStack.pop());
            this.setButtons();
        } else {
            Beep.beep();
        }
    }

    void pushUndo() {
        this.undoStack.push(this.helpScrollPane.getVerticalScrollBar().getValue());
        this.setButtons();
    }

    void pushRedo() {
        this.redoStack.push(this.helpScrollPane.getVerticalScrollBar().getValue());
        this.setButtons();
    }

    void setButtons() {
        this.undoButton.setEnabled(this.undoStack.size() > 0);
        this.redoButton.setEnabled(this.redoStack.size() > 0);
    }

    void removeOldHighlight() {
        if (this.oldHighlight != null) {
            this.highlighter.removeHighlight(this.oldHighlight);
            this.oldHighlight = null;
        }
    }

    void manageHelpTextField(KeyEvent evt) {
        String code = KeyEvent.getKeyText(evt.getKeyCode());
        if (!code.matches("F\\d")) {
            try {
                this.removeOldHighlight();
                this.doc = this.helpTextPane.getDocument();
                int len = this.doc.getLength();
                String content = this.doc.getText(0, len).toLowerCase();
                String search = this.findTextField.getText().toLowerCase();
                if (!search.equals(this.oldSearch)) {
                    this.oldPos = 0;
                }
                this.oldSearch = search;
                int p = content.indexOf(search, this.oldPos);
                if (p == -1) {
                    this.oldPos = 0;
                    p = content.indexOf(search, this.oldPos);
                }
                if (p >= 0) {
                    this.pushUndo();
                    int slen = search.length();
                    Rectangle r = this.helpTextPane.modelToView(p);
                    int pos = r.y - this.helpScrollPane.getHeight() / 2;
                    pos = pos < 0 ? 0 : pos;
                    this.helpScrollPane.getVerticalScrollBar().setValue(pos);
                    this.oldHighlight = this.highlighter.addHighlight(p, p + slen, this.highlightPainter);
                    this.oldPos = p + 1;
                } else {
                    Beep.beep();
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void fromString(String vs) {
        try {
            this.vScrollPos = Integer.parseInt(vs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        int vpos = this.helpScrollPane.getVerticalScrollBar().getValue();
        return String.format("%d", vpos);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.jLabel1 = new JLabel();
        this.findTextField = new JTextField();
        this.helpScrollPane = new JScrollPane();
        this.helpTextPane = new JTextPane();
        this.setLayout(new GridBagLayout());
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/go-previous.png")));
        this.undoButton.setToolTipText("Go back");
        this.undoButton.setFocusable(false);
        this.undoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MyHelpPane.this.undoButtonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.undoButton);
        this.redoButton.setIcon(new ImageIcon(this.getClass().getResource("/jdbclient/icons/go-next.png")));
        this.redoButton.setToolTipText("Go forward");
        this.redoButton.setFocusable(false);
        this.redoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MyHelpPane.this.redoButtonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.redoButton);
        this.jLabel1.setText("Search:");
        this.jPanel1.add(this.jLabel1);
        this.findTextField.setToolTipText("<html>Quick search: type a search string,<br/>press Enter to find the next case</html>");
        this.findTextField.setFocusCycleRoot(true);
        this.findTextField.setMinimumSize(new Dimension(150, 27));
        this.findTextField.setPreferredSize(new Dimension(150, 27));
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyHelpPane.this.findTextFieldKeyReleased(evt);
            }
        });
        this.jPanel1.add(this.findTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.helpScrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.helpTextPane.setEditable(false);
        this.helpTextPane.setContentType("text/html");
        this.helpTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                MyHelpPane.this.helpTextPaneHyperlinkUpdate(evt);
            }
        });
        this.helpScrollPane.setViewportView(this.helpTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.helpScrollPane, gridBagConstraints);
    }

    private void helpTextPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.manageHyperlinks(evt);
    }

    private void undoButtonMouseClicked(MouseEvent evt) {
        this.undo();
    }

    private void redoButtonMouseClicked(MouseEvent evt) {
        this.redo();
    }

    private void findTextFieldKeyReleased(KeyEvent evt) {
        this.manageHelpTextField(evt);
    }
}

