/*
 * Decompiled with CFR 0.152.
 */
package jdbclient;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jdbclient.JDBClient;
import jdbclient.MyJTable;

public final class MyTableCellRenderer
extends DefaultTableCellRenderer {
    JDBClient parent;
    static final long serialVersionUID = 67433L;
    String rightJustify;
    int rjLen;
    boolean title;
    boolean errorDisp = false;
    Border cb = null;
    Font font;
    boolean needEllipse = false;
    EmptyBorder emptyBorder;
    LineBorder lineBorder;

    public MyTableCellRenderer(JDBClient p, boolean title, boolean errorDisp) {
        this.parent = p;
        this.title = title;
        this.errorDisp = errorDisp;
        this.rightJustify = "                           ";
        this.rjLen = this.rightJustify.length();
        if (title) {
            this.font = new Font("Monospaced", 1, 16);
        } else {
            this.cb = new EmptyBorder(this.parent.tablePaddingConstant + 2, this.parent.tablePaddingConstant + 2, this.parent.tablePaddingConstant, this.parent.tablePaddingConstant);
            this.lineBorder = new LineBorder(this.parent.tableBorderColor);
            this.font = this.parent.baseFont;
        }
    }

    private String ellipsizeString(String sv, int pixw) {
        boolean needFix;
        int stringLen = sv.length();
        int sw = stringLen * this.parent.charWidth;
        boolean bl = needFix = sw >= pixw;
        if (needFix) {
            int ni = pixw / this.parent.charWidth - 3;
            ni = Math.max(0, ni);
            sv = sv.substring(0, ni) + "...";
            this.needEllipse |= needFix;
        }
        return sv;
    }

    private String ellipsizeTest(String sv, int pixw) {
        String[] array = sv.split("\n");
        if (array.length < 2) {
            return this.ellipsizeString(sv, pixw);
        }
        StringBuilder sb = new StringBuilder();
        for (String sa : array) {
            sb.append(this.ellipsizeString(sa, pixw));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.needEllipse = false;
        String sv = value == null ? "NULL" : value.toString();
        sv = sv.replaceAll("\t", "        ");
        int stringLen = sv.length();
        int colw = table.getColumnModel().getColumn(column).getWidth();
        int pixw = colw - this.parent.tablePaddingConstant;
        sv = this.ellipsizeTest(sv, pixw);
        if (!this.needEllipse && !(value instanceof String)) {
            StringBuilder sb = new StringBuilder();
            int chw = colw / this.parent.charWidth - 1;
            int delta = chw - stringLen;
            if (delta > 0) {
                if (delta < this.rjLen) {
                    sb.append(this.rightJustify.substring(0, delta));
                } else {
                    sb.append(this.rightJustify);
                    delta -= this.rjLen;
                    while (delta > 0) {
                        sb.append(" ");
                        --delta;
                    }
                }
            }
            sv = new String(sb.append(sv));
        }
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        ta.setLineWrap(false);
        if (this.font != null) {
            ta.setFont(this.font);
        }
        if (!this.title) {
            if (this.errorDisp && column == 3 && !sv.equals("(none)")) {
                ta.setForeground(this.parent.changedColor);
            }
            if (isSelected) {
                ta.setBackground(this.parent.selectedColor);
            } else if (table instanceof MyJTable) {
                if (row == ((MyJTable)table).hoverRow) {
                    ta.setBackground(this.parent.hoverColor);
                } else {
                    ta.setBackground(this.parent.oddeven[row % 2]);
                }
            }
        } else {
            int lm = (table.getWidth() - sv.length() * this.parent.charWidth) / 2;
            this.cb = new EmptyBorder(16, lm, 0, 0);
        }
        ta.setBorder(this.cb);
        ta.setText(sv);
        return ta;
    }

    private void p(String s) {
        System.out.println(s);
    }
}

