/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.util.HashMap;
import java.util.HashSet;

public final class CCIR476 {
    private HashMap<Integer, Integer> code_figs;
    private HashMap<Integer, Integer> code_ltrs;
    private HashMap<Integer, Integer> ltrs_code;
    private HashMap<Integer, Integer> figs_code;
    private HashSet<Integer> valid_codes;
    private boolean shift = false;
    private char[][] ltrs = new char[][]{{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'}, {'_', '_', '_', '_', '_', '_', '_', 'J', '_', '_', '_', 'F', '_', 'C', 'K', '_'}, {'_', '_', '_', '_', '_', '_', '_', 'W', '_', '_', '_', 'Y', '_', 'P', 'Q', '_'}, {'_', '_', '_', '_', '_', 'G', '_', '_', '_', 'M', 'X', '_', 'V', '_', '_', '_'}, {'_', '_', '_', '_', '_', '_', '_', 'A', '_', '_', '_', 'S', '_', 'I', 'U', '_'}, {'_', '_', '_', 'D', '_', 'R', 'E', '_', '_', 'N', '_', '_', ' ', '_', '_', '_'}, {'_', '_', '_', 'Z', '_', 'L', '_', '_', '_', 'H', '_', '_', '\n', '_', '_', '_'}, {'_', 'O', 'B', '_', 'T', '_', '_', '_', '\r', '_', '_', '_', '_', '_', '_', '_'}};
    private char[][] figs = new char[][]{{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'}, {'_', '_', '_', '_', '_', '_', '_', '\'', '_', '_', '_', '!', '_', ':', '(', '_'}, {'_', '_', '_', '_', '_', '_', '_', '2', '_', '_', '_', '6', '_', '0', '1', '_'}, {'_', '_', '_', '_', '_', '&', '_', '_', '_', '.', '/', '_', ';', '_', '_', '_'}, {'_', '_', '_', '_', '_', '_', '_', '-', '_', '_', '_', '\u0007', '_', '8', '7', '_'}, {'_', '_', '_', '$', '_', '4', '3', '_', '_', ',', '_', '_', ' ', '_', '_', '_'}, {'_', '_', '_', '\"', '_', ')', '_', '_', '_', '#', '_', '_', '\n', '_', '_', '_'}, {'_', '9', '?', '_', '5', '_', '_', '_', '\r', '_', '_', '_', '_', '_', '_', '_'}};

    public CCIR476() {
        this.code_figs = new HashMap();
        this.code_ltrs = new HashMap();
        this.ltrs_code = new HashMap();
        this.figs_code = new HashMap();
        this.valid_codes = new HashSet();
        for (int code = 0; code < 128; ++code) {
            if (!CCIR476.check_bits(code)) continue;
            this.valid_codes.add(code);
            int x = code & 0xF;
            int y = code >> 4;
            char figv = this.figs[y][x];
            char ltrv = this.ltrs[y][x];
            if ((char)figv != '_') {
                this.code_figs.put(code, Integer.valueOf(figv));
                this.figs_code.put(Integer.valueOf(figv), code);
            }
            if ((char)ltrv == '_') continue;
            this.code_ltrs.put(code, Integer.valueOf(ltrv));
            this.ltrs_code.put(Integer.valueOf(ltrv), code);
        }
    }

    public boolean get_shift() {
        return this.shift;
    }

    public boolean check_valid(int code) {
        return this.valid_codes.contains(code);
    }

    public int char_to_code(int ch, boolean ex_shift) {
        ch = Character.toUpperCase(ch);
        int code = -ch;
        if (ex_shift && this.figs_code.containsKey(ch)) {
            code = this.figs_code.get(ch);
        } else if (!ex_shift && this.ltrs_code.containsKey(ch)) {
            code = this.ltrs_code.get(ch);
        } else if (this.figs_code.containsKey(ch)) {
            this.shift = true;
            code = this.figs_code.get(ch);
        } else if (this.ltrs_code.containsKey(ch)) {
            this.shift = false;
            code = this.ltrs_code.get(ch);
        }
        return code;
    }

    public int code_to_char(int code, boolean shift) {
        HashMap<Integer, Integer> target;
        int ch = -code;
        HashMap<Integer, Integer> hashMap = target = shift ? this.code_figs : this.code_ltrs;
        if (target.containsKey(code)) {
            ch = target.get(code);
        }
        return ch;
    }

    public static boolean check_bits(int v) {
        int bc = 0;
        while (v != 0) {
            ++bc;
            v &= v - 1;
        }
        return bc == 4;
    }
}

