/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jnx.ComboBoxController;
import jnx.ComboBoxTextController;
import jnx.ConfigManager;
import jnx.FrameController;
import jnx.HelpPane;
import jnx.MessageFilter;
import jnx.MessageFilterDialog;
import jnx.NavtexReceiver;
import jnx.ScopePanel;
import jnx.SpectrumDisplayManager;
import jnx.TabPanelController;
import jnx.TextFieldController;
import jnx.ToggleButtonController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JNX
extends JFrame
implements ClipboardOwner {
    final String app_version = "1.4";
    boolean debug = false;
    List<String> data_rates = Arrays.asList("12000", "16000", "24000", "32000", "48000", "96000");
    List<String> spectrum_choices = Arrays.asList("No filter", "Space filter", "Mark filter");
    final String app_path;
    final String app_name;
    final String program_name;
    final String user_dir;
    final String data_path;
    final String init_path;
    final String file_sep;
    int timer_period_ms = 250;
    Timer periodic_timer = null;
    int scope_size = 500;
    HelpPane help_pane;
    ConfigManager config_mgr;
    NavtexReceiver receiver;
    ScopePanel time_scope_pane;
    ScopePanel spectrum_scope_pane;
    SpectrumDisplayManager spectrum_manager;
    TabPanelController selected_tab;
    ToggleButtonController navtex_filter;
    ToggleButtonController scroll_to_bottom;
    ToggleButtonController log_data;
    ToggleButtonController inverse_logic;
    ToggleButtonController configuration_visible;
    ToggleButtonController time_scope_sync;
    ToggleButtonController spectrum_scope_sync;
    ToggleButtonController strict;
    ComboBoxController audio_source;
    ComboBoxController audio_dest;
    ComboBoxController sample_rate;
    ComboBoxTextController spectrum_selection;
    TextFieldController center_frequency;
    TextFieldController baud_rate;
    TextFieldController time_scope_hcontrol;
    TextFieldController time_scope_vcontrol;
    TextFieldController spectrum_scope_hcontrol;
    TextFieldController spectrum_scope_vcontrol;
    TextFieldController monitor_volume;
    FrameController appsize;
    MessageFilter accepted_navtex_messages;
    BufferedWriter log_buffer = null;
    File log_file = null;
    String log_path = null;
    boolean scope_visible = false;
    private JComboBox audio_dest_combobox;
    private JComboBox audio_source_combobox;
    private JLabel baud_error_label;
    private JTextField baud_rate_textfield;
    private JPanel bottom_panel_a;
    private JPanel bottom_panel_b;
    private JPanel bottom_panel_c;
    private JTextField center_frequency_textfield;
    private JButton clear_button;
    private JButton clipboard_button;
    private JCheckBox configuration_checkbox;
    private JPanel configuration_panel;
    private JComboBox data_rate_combobox;
    private JScrollPane data_scrollpane;
    protected JTextArea data_textarea;
    private JButton defaults_button;
    private JCheckBox inverted_checkbox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel3;
    private JCheckBox logging_checkbox;
    private JLabel machine_state_label;
    protected JButton message_filter_button;
    private JTextField monitor_volume_textfield;
    protected JCheckBox navtex_filter_checkbox;
    private JButton quit_button;
    private JPanel scope_container;
    private JCheckBox scroll_to_bottom_checkbox;
    private JComboBox spectrum_combobox;
    private JCheckBox strict_checkbox;
    private JTabbedPane tabbed_pane;
    private JPanel text_display_panel;
    private JLabel volume_label;

    public JNX(String[] args) {
        this.initComponents();
        if (args.length > 0 && args[0].equals("-d")) {
            this.debug = true;
        }
        this.app_name = this.getClass().getSimpleName();
        URL url = this.getClass().getResource(this.app_name + ".class");
        String temp = url.getPath().replaceFirst("(.*?)!.*", "$1");
        temp = temp.replaceFirst("file:", "");
        this.app_path = new File(temp).getPath();
        this.user_dir = System.getProperty("user.home");
        this.file_sep = System.getProperty("file.separator");
        this.data_path = this.user_dir + this.file_sep + "." + this.app_name;
        File f = new File(this.data_path);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.init_path = this.data_path + this.file_sep + this.app_name + ".ini";
        this.log_path = this.data_path + this.file_sep + "data.log";
        this.program_name = this.app_name + " " + "1.4";
        this.setTitle(this.program_name);
        this.setIconImage(new ImageIcon(this.getClass().getResource("images/" + this.app_name + "_icon.png")).getImage());
        this.help_pane = new HelpPane(this);
        this.tabbed_pane.add((Component)this.help_pane, "Help");
        this.receiver = new NavtexReceiver(this);
        this.time_scope_pane = new ScopePanel(this, "Time Domain", false);
        this.spectrum_scope_pane = new ScopePanel(this, "Frequency/Spectrum Domain", true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.scope_container.add((Component)this.time_scope_pane, gbc);
        this.scope_container.add((Component)this.spectrum_scope_pane, gbc);
        this.time_scope_hcontrol = this.time_scope_pane.horizontal_control;
        this.time_scope_vcontrol = this.time_scope_pane.vertical_control;
        this.spectrum_scope_hcontrol = this.spectrum_scope_pane.horizontal_control;
        this.spectrum_scope_vcontrol = this.spectrum_scope_pane.vertical_control;
        this.time_scope_sync = this.time_scope_pane.sync_with_signal;
        this.spectrum_scope_sync = this.spectrum_scope_pane.sync_with_signal;
        this.spectrum_manager = new SpectrumDisplayManager(this, this.spectrum_scope_pane);
        this.setup_control_values();
        this.receiver.control(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JNX.this.inner_close();
            }
        });
        this.periodic_timer = new Timer();
        this.periodic_timer.scheduleAtFixedRate((TimerTask)new PeriodicEvents(), 500L, (long)this.timer_period_ms);
    }

    private void setup_control_values() {
        this.appsize = new FrameController(this);
        this.selected_tab = new TabPanelController(this.tabbed_pane, 0);
        this.data_textarea.getCaret().setVisible(true);
        this.strict = new ToggleButtonController(this.strict_checkbox, false);
        this.navtex_filter = new ToggleButtonController(this.navtex_filter_checkbox, false);
        this.scroll_to_bottom = new ToggleButtonController(this.scroll_to_bottom_checkbox, true);
        this.spectrum_selection = new ComboBoxTextController(this.spectrum_combobox, this.spectrum_choices, "No filter");
        this.sample_rate = new ComboBoxController(this.data_rate_combobox, this.data_rates, "" + this.receiver.default_sample_rate);
        List<String> sdata = this.make_mixer_description_list(this.receiver.target_mixer_list, null);
        List<String> data = this.make_numeric_list(1, this.receiver.source_mixer_list.size() + 1, 1);
        this.audio_source = new ComboBoxController(this.audio_source_combobox, data, "1", sdata, "Select audio input");
        data = this.make_numeric_list(1, this.receiver.target_mixer_list.size() + 1, 1);
        this.audio_dest = new ComboBoxController(this.audio_dest_combobox, data, "1", sdata, "Select audio output");
        data = this.make_numeric_list(0, 501, 1);
        this.monitor_volume = new TextFieldController(this.monitor_volume_textfield, "0", 500.0);
        this.inverse_logic = new ToggleButtonController(this.inverted_checkbox, false);
        this.log_data = new ToggleButtonController(this.logging_checkbox, true);
        this.configuration_visible = new ToggleButtonController(this.configuration_checkbox, true);
        this.logging_checkbox.setToolTipText("Save received data to " + this.log_path);
        this.center_frequency = new TextFieldController(this.center_frequency_textfield, "" + this.receiver.default_sideband_frequency, 4000.0);
        this.baud_rate = new TextFieldController(this.baud_rate_textfield, "" + this.receiver.default_baud_rate, 1000.0);
        this.accepted_navtex_messages = new MessageFilter();
        this.config_mgr = new ConfigManager(this, this.init_path);
    }

    private void update_control_values() {
        this.receiver.inverse = this.inverse_logic.get_value();
        this.configuration_panel.setVisible(this.configuration_visible.get_value());
        this.control_logging(this.log_data.get_value());
        this.scope_visible = this.tabbed_pane.getSelectedComponent() == this.scope_container;
    }

    private void set_control_defaults() {
        if (JNX.ask_user(this, "Okay to reset all values to defaults?", "Reset Control Defaults")) {
            this.audio_source.set_value("1");
            this.sample_rate.set_value("" + this.receiver.default_sample_rate);
            this.center_frequency.set_value(this.receiver.default_sideband_frequency);
            this.baud_rate.set_value(this.receiver.default_baud_rate);
            this.inverse_logic.set_value(false);
            this.strict.set_value(false);
        }
    }

    private void restart_control() {
        boolean restart = false;
        restart |= this.receiver.audio_source != this.audio_source.get_value();
        restart |= this.receiver.audio_dest != this.audio_dest.get_value();
        restart |= this.receiver.sample_rate != this.sample_rate.get_value();
        if (restart |= this.receiver.baud_rate != this.baud_rate.get_dvalue()) {
            this.receiver.restart();
        }
    }

    public void update_control() {
        boolean update = false;
        if (update |= this.receiver.center_frequency_f != this.center_frequency.get_dvalue()) {
            this.receiver.update_filters();
        }
    }

    private void update_baud_error() {
        String s = this.receiver.state == NavtexReceiver.State.NOSIGNAL || Math.abs(this.receiver.baud_error) < 8.0 ? "OK" : (this.receiver.baud_error > 0.0 ? "ERR ->" : "<- ERR");
        this.baud_error_label.setText(s);
    }

    private void control_logging(boolean enable) {
        try {
            if (enable) {
                if (this.log_buffer == null || this.log_file == null || !this.log_file.exists()) {
                    this.log_file = new File(this.log_path);
                    FileWriter log_stream = new FileWriter(this.log_file, true);
                    this.log_buffer = new BufferedWriter(log_stream);
                }
            } else if (this.log_buffer != null) {
                this.log_buffer.close();
                this.log_buffer = null;
            }
        }
        catch (Exception e) {
            this.trace_errors("", e);
        }
    }

    public void log_data(String s) {
        if (this.log_buffer != null && this.log_file != null) {
            if (!this.log_file.exists()) {
                this.control_logging(true);
            }
            try {
                this.log_buffer.write(s);
                this.log_buffer.flush();
            }
            catch (Exception e) {
                this.trace_errors("", e);
            }
        }
    }

    public void trace_errors(String s, Exception e) {
        System.out.println(s + ": " + e);
        e.printStackTrace();
    }

    private List<String> make_numeric_list(int a, int b, int step) {
        ArrayList<String> data = new ArrayList<String>();
        for (int i = a; i != b; i += step) {
            data.add(Integer.toString(i));
        }
        return data;
    }

    private List<String> make_mixer_description_list(List<Mixer.Info> data, String extra) {
        ArrayList<String> out = new ArrayList<String>();
        if (extra != null) {
            out.add(extra);
        }
        for (Mixer.Info item : data) {
            out.add(item.getDescription());
        }
        return out;
    }

    public void append_to_data_page(String s) {
        this.log_data(s);
        this.data_textarea.append(s);
        if (this.scroll_to_bottom_checkbox.isSelected()) {
            this.data_textarea.setCaretPosition(this.data_textarea.getDocument().getLength());
        }
    }

    private void update_indicators() {
        if (this.receiver != null) {
            this.machine_state_label.setText(this.receiver.state.toString());
            this.update_volume_display();
        }
    }

    private void update_volume_display() {
        int max = 32;
        int v = (int)Math.sqrt(this.receiver.audio_average) / 4;
        String s = " Volume: ";
        for (int i = 0; i < v && i < max; ++i) {
            s = s + "|";
        }
        if (v >= max) {
            s = s + "+";
        }
        this.volume_label.setText(s);
    }

    private void launch_message_filter_dialog() {
        MessageFilterDialog dialog = new MessageFilterDialog(this, true);
        dialog.setVisible(true);
    }

    private void clipboard_copy() {
        String s = this.data_textarea.getText();
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    private void clear_text_display() {
        if (JNX.ask_user(this, "Erase this display's contents?", "Clear display")) {
            this.data_textarea.setText("");
            this.receiver.succeed_tally = 0;
            this.receiver.fail_tally = 0;
        }
    }

    public static boolean ask_user(JFrame src, String query, String title, Object[] options) {
        if (options != null) {
            return JOptionPane.showOptionDialog(src, query, title, 0, 3, null, options, options[0]) == 0;
        }
        return JOptionPane.showConfirmDialog(src, query, title, 0) == 0;
    }

    public static boolean ask_user(JFrame src, String query, String title) {
        return JNX.ask_user(src, query, title, null);
    }

    public static void tell_user(JFrame src, String message, String title) {
        JOptionPane.showMessageDialog(src, message, title, 1);
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void close() {
        NavtexReceiver.State cfr_ignored_0 = this.receiver.state;
        if (this.receiver.state != NavtexReceiver.State.READ_DATA || JNX.ask_user(this, "Okay to quit JNX?", "Close JNX")) {
            this.inner_close();
            System.exit(0);
        }
    }

    private void inner_close() {
        this.receiver.end_thread();
        this.control_logging(false);
        this.config_mgr.write_config_file();
    }

    public <T> void p(T s) {
        System.out.println(s);
        System.out.flush();
    }

    public <T> void debug_p(T s) {
        if (this.debug) {
            this.p(s);
        }
    }

    private void initComponents() {
        this.tabbed_pane = new JTabbedPane();
        this.text_display_panel = new JPanel();
        this.data_scrollpane = new JScrollPane();
        this.data_textarea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.scroll_to_bottom_checkbox = new JCheckBox();
        this.logging_checkbox = new JCheckBox();
        this.clipboard_button = new JButton();
        this.clear_button = new JButton();
        this.scope_container = new JPanel();
        this.bottom_panel_a = new JPanel();
        this.machine_state_label = new JLabel();
        this.volume_label = new JLabel();
        this.configuration_checkbox = new JCheckBox();
        this.quit_button = new JButton();
        this.jLabel2 = new JLabel();
        this.monitor_volume_textfield = new JTextField();
        this.configuration_panel = new JPanel();
        this.bottom_panel_b = new JPanel();
        this.jLabel1 = new JLabel();
        this.data_rate_combobox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.audio_source_combobox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.audio_dest_combobox = new JComboBox();
        this.jLabel9 = new JLabel();
        this.spectrum_combobox = new JComboBox();
        this.defaults_button = new JButton();
        this.bottom_panel_c = new JPanel();
        this.jLabel3 = new JLabel();
        this.center_frequency_textfield = new JTextField();
        this.jLabel7 = new JLabel();
        this.baud_rate_textfield = new JTextField();
        this.baud_error_label = new JLabel();
        this.navtex_filter_checkbox = new JCheckBox();
        this.message_filter_button = new JButton();
        this.inverted_checkbox = new JCheckBox();
        this.strict_checkbox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(600, 400));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JNX.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabbed_pane.setTabPlacement(3);
        this.text_display_panel.setLayout(new BorderLayout());
        this.data_scrollpane.setHorizontalScrollBarPolicy(31);
        this.data_textarea.setEditable(false);
        this.data_textarea.setFont(new Font("Monospaced", 0, 12));
        this.data_textarea.setLineWrap(true);
        this.data_textarea.setWrapStyleWord(true);
        this.data_textarea.setCursor(new Cursor(0));
        this.data_textarea.setDisabledTextColor(new Color(51, 51, 51));
        this.data_textarea.setEnabled(false);
        this.data_textarea.setFocusable(false);
        this.data_textarea.setMargin(new Insets(4, 4, 4, 4));
        this.data_scrollpane.setViewportView(this.data_textarea);
        this.text_display_panel.add((Component)this.data_scrollpane, "Center");
        this.scroll_to_bottom_checkbox.setSelected(true);
        this.scroll_to_bottom_checkbox.setText("Scroll to bottom");
        this.scroll_to_bottom_checkbox.setToolTipText("Scroll to bottom as data is received");
        this.jPanel3.add(this.scroll_to_bottom_checkbox);
        this.logging_checkbox.setText("Log Data");
        this.logging_checkbox.setToolTipText("Automatically save data");
        this.jPanel3.add(this.logging_checkbox);
        this.clipboard_button.setText("Copy to Clipboard");
        this.clipboard_button.setToolTipText("Copy received data to clipboard");
        this.clipboard_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JNX.this.clipboard_buttonMouseClicked(evt);
            }
        });
        this.jPanel3.add(this.clipboard_button);
        this.clear_button.setText("Clear");
        this.clear_button.setToolTipText("Erase this window's content");
        this.clear_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JNX.this.clear_buttonMouseClicked(evt);
            }
        });
        this.jPanel3.add(this.clear_button);
        this.text_display_panel.add((Component)this.jPanel3, "Last");
        this.tabbed_pane.addTab("Data Display", this.text_display_panel);
        this.scope_container.setLayout(new GridBagLayout());
        this.tabbed_pane.addTab("Time/Frequency Display", this.scope_container);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabbed_pane, gridBagConstraints);
        this.bottom_panel_a.setMaximumSize(new Dimension(200, 25));
        this.bottom_panel_a.setPreferredSize(new Dimension(200, 25));
        this.bottom_panel_a.setLayout(new GridBagLayout());
        this.machine_state_label.setBackground(new Color(51, 51, 51));
        this.machine_state_label.setForeground(new Color(0, 204, 0));
        this.machine_state_label.setHorizontalAlignment(0);
        this.machine_state_label.setText("Machine State");
        this.machine_state_label.setToolTipText("Present receiver operational state");
        this.machine_state_label.setAlignmentX(0.1f);
        this.machine_state_label.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 0)));
        this.machine_state_label.setMaximumSize(new Dimension(150, 18));
        this.machine_state_label.setMinimumSize(new Dimension(150, 18));
        this.machine_state_label.setOpaque(true);
        this.machine_state_label.setPreferredSize(new Dimension(150, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottom_panel_a.add((Component)this.machine_state_label, gridBagConstraints);
        this.volume_label.setBackground(new Color(51, 51, 51));
        this.volume_label.setForeground(new Color(255, 255, 0));
        this.volume_label.setText("Volume");
        this.volume_label.setToolTipText("Relative volume level");
        this.volume_label.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)));
        this.volume_label.setMaximumSize(new Dimension(200, 18));
        this.volume_label.setMinimumSize(new Dimension(200, 18));
        this.volume_label.setOpaque(true);
        this.volume_label.setPreferredSize(new Dimension(200, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottom_panel_a.add((Component)this.volume_label, gridBagConstraints);
        this.configuration_checkbox.setText("Config");
        this.configuration_checkbox.setToolTipText("Show or hide configuration panel\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.bottom_panel_a.add((Component)this.configuration_checkbox, gridBagConstraints);
        this.quit_button.setText("Quit");
        this.quit_button.setToolTipText("Exit JNX");
        this.quit_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JNX.this.quit_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.bottom_panel_a.add((Component)this.quit_button, gridBagConstraints);
        this.jLabel2.setText("| Volume:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_a.add((Component)this.jLabel2, gridBagConstraints);
        this.monitor_volume_textfield.setHorizontalAlignment(4);
        this.monitor_volume_textfield.setText("0.0");
        this.monitor_volume_textfield.setToolTipText("Adjust monitor volume, 0 = off");
        this.monitor_volume_textfield.setMaximumSize(new Dimension(50, 19));
        this.monitor_volume_textfield.setMinimumSize(new Dimension(50, 19));
        this.monitor_volume_textfield.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_a.add((Component)this.monitor_volume_textfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.bottom_panel_a, gridBagConstraints);
        this.configuration_panel.setLayout(new GridBagLayout());
        this.bottom_panel_b.setToolTipText("");
        this.bottom_panel_b.setLayout(new GridBagLayout());
        this.jLabel1.setText("Rate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_b.add((Component)this.jLabel1, gridBagConstraints);
        this.data_rate_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.data_rate_combobox.setToolTipText("Select data sampling rate (samples/second)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_b.add((Component)this.data_rate_combobox, gridBagConstraints);
        this.jLabel4.setText("Input:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_b.add((Component)this.jLabel4, gridBagConstraints);
        this.audio_source_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_b.add((Component)this.audio_source_combobox, gridBagConstraints);
        this.jLabel5.setText("Output:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_b.add((Component)this.jLabel5, gridBagConstraints);
        this.audio_dest_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_b.add((Component)this.audio_dest_combobox, gridBagConstraints);
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Spectrum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_b.add((Component)this.jLabel9, gridBagConstraints);
        this.spectrum_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.spectrum_combobox.setToolTipText("Choose spectrum source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_b.add((Component)this.spectrum_combobox, gridBagConstraints);
        this.defaults_button.setText("Defaults");
        this.defaults_button.setToolTipText("Set all default values");
        this.defaults_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JNX.this.defaults_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_b.add((Component)this.defaults_button, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.configuration_panel.add((Component)this.bottom_panel_b, gridBagConstraints);
        this.bottom_panel_c.setLayout(new GridBagLayout());
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Freq. Hz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_c.add((Component)this.jLabel3, gridBagConstraints);
        this.center_frequency_textfield.setHorizontalAlignment(4);
        this.center_frequency_textfield.setText("0.0000");
        this.center_frequency_textfield.setToolTipText("Receiver sideband frequency Hz");
        this.center_frequency_textfield.setMaximumSize(new Dimension(80, 19));
        this.center_frequency_textfield.setMinimumSize(new Dimension(80, 19));
        this.center_frequency_textfield.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.center_frequency_textfield, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Baud:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom_panel_c.add((Component)this.jLabel7, gridBagConstraints);
        this.baud_rate_textfield.setHorizontalAlignment(4);
        this.baud_rate_textfield.setText("0.000");
        this.baud_rate_textfield.setToolTipText("Receiver baud rate Hz");
        this.baud_rate_textfield.setMaximumSize(new Dimension(80, 19));
        this.baud_rate_textfield.setMinimumSize(new Dimension(80, 19));
        this.baud_rate_textfield.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.baud_rate_textfield, gridBagConstraints);
        this.baud_error_label.setBackground(new Color(51, 51, 51));
        this.baud_error_label.setForeground(new Color(153, 204, 255));
        this.baud_error_label.setHorizontalAlignment(0);
        this.baud_error_label.setText("OK");
        this.baud_error_label.setToolTipText("Baud rate tracker status");
        this.baud_error_label.setBorder(BorderFactory.createLineBorder(new Color(153, 204, 255)));
        this.baud_error_label.setMaximumSize(new Dimension(80, 15));
        this.baud_error_label.setMinimumSize(new Dimension(80, 15));
        this.baud_error_label.setOpaque(true);
        this.baud_error_label.setPreferredSize(new Dimension(80, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.baud_error_label, gridBagConstraints);
        this.navtex_filter_checkbox.setText("Navtex Filter");
        this.navtex_filter_checkbox.setToolTipText("Enable/disable Navtex-format message filtering");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.navtex_filter_checkbox, gridBagConstraints);
        this.message_filter_button.setText("Select");
        this.message_filter_button.setToolTipText("Choose which Navtex messages to display");
        this.message_filter_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JNX.this.message_filter_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.message_filter_button, gridBagConstraints);
        this.inverted_checkbox.setText("Inverted");
        this.inverted_checkbox.setToolTipText("Reverse mark and space signals");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.inverted_checkbox, gridBagConstraints);
        this.strict_checkbox.setText("Strict");
        this.strict_checkbox.setToolTipText("Reject unconfirmed characters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.bottom_panel_c.add((Component)this.strict_checkbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.configuration_panel.add((Component)this.bottom_panel_c, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.configuration_panel, gridBagConstraints);
        this.pack();
    }

    private void quit_buttonMouseClicked(MouseEvent evt) {
        this.close();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    private void clipboard_buttonMouseClicked(MouseEvent evt) {
        this.clipboard_copy();
    }

    private void clear_buttonMouseClicked(MouseEvent evt) {
        this.clear_text_display();
    }

    private void defaults_buttonMouseClicked(MouseEvent evt) {
        this.set_control_defaults();
    }

    private void message_filter_buttonMouseClicked(MouseEvent evt) {
        this.launch_message_filter_dialog();
    }

    public static void main(final String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new JNX(args).setVisible(true);
                }
            });
        }
        catch (Exception e) {
            System.out.println("JNX main: " + e);
            e.printStackTrace();
        }
    }

    class PeriodicEvents
    extends TimerTask {
        PeriodicEvents() {
        }

        public void run() {
            JNX.this.update_indicators();
            JNX.this.update_control_values();
            JNX.this.update_control();
            JNX.this.restart_control();
            JNX.this.update_baud_error();
            JNX.this.receiver.periodic_actions();
            if (JNX.this.debug) {
                double errors = 0.0;
                try {
                    if (JNX.this.receiver.succeed_tally > 0) {
                        errors = 100.0 * (double)JNX.this.receiver.fail_tally / (double)(JNX.this.receiver.succeed_tally + JNX.this.receiver.fail_tally);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                String s = String.format("Success %d, failure %d, errors %.2f%%", JNX.this.receiver.succeed_tally, JNX.this.receiver.fail_tally, errors);
                JNX.this.p(s);
            }
        }
    }
}

