/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import jnx.BiQuadraticFilter;
import jnx.CCIR476;
import jnx.JNX;

public final class NavtexReceiver
extends Thread {
    JNX parent;
    boolean pll_mode = false;
    SourceDataLine sourceDataLine = null;
    TargetDataLine targetDataLine = null;
    AudioFormat audioFormat = null;
    CCIR476 ccir476;
    List<Integer> sync_chars;
    StringBuffer reception_queue;
    int c1;
    int c2;
    int c3;
    byte[] bbuffer;
    byte[] out_buffer;
    short[] sbuffer;
    int zero_crossing_samples = 16;
    int zero_crossings_divisor = 4;
    int[] zero_crossings = null;
    long zero_crossing_count;
    int succeed_tally;
    int fail_tally;
    double invsqr2 = 1.0 / Math.sqrt(2.0);
    double message_time = 0.0;
    int bbufsz = 8192;
    int sbufsz = this.bbufsz / 2;
    boolean thread_enabled = false;
    boolean in_thread_inner_loop = false;
    boolean thread_exit;
    int available;
    int read_length;
    double sample_interval;
    double signal_accumulator = 0.0;
    double logic_level = 0.0;
    double mark_f;
    double space_f;
    double audio_average = 0.0;
    double audio_average_tc;
    double audio_minimum = 256.0;
    double time_sec;
    double dv;
    double bpdv;
    double sign;
    double space_level;
    double mark_level;
    double space_abs;
    double mark_abs;
    final double default_baud_rate = 100.0;
    final int default_sample_rate = 48000;
    final double default_sideband_frequency = 1000.0;
    final int default_audio_source = 0;
    final int default_audio_dest = 0;
    double baud_rate = 100.0;
    double baud_error;
    int sample_rate = 48000;
    int audio_source = 0;
    int audio_dest = 0;
    boolean mark_state;
    boolean averaged_mark_state;
    int bit_duration = 0;
    boolean old_mark_state;
    BiQuadraticFilter biquad_mark;
    BiQuadraticFilter biquad_space;
    BiQuadraticFilter biquad_lowpass;
    double bit_duration_seconds;
    long bit_duration_delta;
    int bit_sample_count;
    int half_bit_sample_count;
    State state;
    long sample_count;
    long next_event_count = 0L;
    int bit_count;
    int code_bits;
    int code_word;
    int idle_word;
    boolean shift = false;
    final int code_character32 = 106;
    final int code_ltrs = 90;
    final int code_figs = 54;
    final int code_alpha = 15;
    final int code_beta = 51;
    final int code_char32 = 106;
    final int code_rep = 102;
    final int char_bell = 7;
    final String start_valid;
    final String stop_valid;
    Pattern start_valid_regex;
    boolean inverse = false;
    boolean pulse_edge_event;
    int error_count;
    int valid_count;
    double diffabs;
    List<Mixer.Info> source_mixer_list;
    List<Mixer.Info> target_mixer_list;
    Line.Info targetLineInfo;
    Line.Info sourceLineInfo;
    double reset_target_time = 7200.0;
    int spectrum_choice = 0;
    double sync_delta;
    boolean alpha_phase = false;
    boolean valid_message = false;
    boolean navtex_message_filtering = false;
    Color navtex_valid;
    Color navtex_invalid;
    double center_frequency_f = 1000.0;
    double deviation_f = 90.0;
    double lowpass_filter_f = 140.0;
    double mark_space_filter_q;
    double pll_val = 0.0;
    double pll_out = 0.0;
    double pll_integral = 0.0;
    double pll_reference = 0.0;
    double pll_loop_control;
    double pll_loop_gain = 0.7;
    double pll_center_f = 1000.0;
    double pll_omega;
    double pll_bandpass_q = 2.0;
    double pll_bandpass_deviation_f = 90.0;
    double pll_loop_lowpass_filter_f = 1000.0;
    double pll_output_lowpass_filter_f = 100.0;
    BiQuadraticFilter biquad_pll_bandpass1;
    BiQuadraticFilter biquad_pll_bandpass2;
    BiQuadraticFilter biquad_pll_loop_lowpass;
    BiQuadraticFilter biquad_pll_output_lowpass;

    public NavtexReceiver(JNX p) {
        this.parent = p;
        this.start_valid = "ZCZC xx00\r";
        this.start_valid_regex = Pattern.compile("ZCZC \\w\\w\\d\\d\\r");
        this.stop_valid = "\r\nNNNN\r\n";
        this.state = State.NOSIGNAL;
        this.sync_chars = new ArrayList<Integer>();
        this.reception_queue = new StringBuffer();
        this.ccir476 = new CCIR476();
        this.create_mixer_lists();
        this.biquad_mark = new BiQuadraticFilter();
        this.biquad_space = new BiQuadraticFilter();
        this.biquad_lowpass = new BiQuadraticFilter();
        this.biquad_pll_loop_lowpass = new BiQuadraticFilter();
        this.biquad_pll_output_lowpass = new BiQuadraticFilter();
        this.biquad_pll_bandpass1 = new BiQuadraticFilter();
        this.biquad_pll_bandpass2 = new BiQuadraticFilter();
        this.navtex_invalid = new Color(1.0f, 1.0f, 0.8f);
        this.navtex_valid = new Color(0.8f, 1.0f, 0.8f);
        this.start();
    }

    private void create_mixer_lists() {
        this.targetLineInfo = new Line.Info(TargetDataLine.class);
        this.sourceLineInfo = new Line.Info(SourceDataLine.class);
        Mixer.Info[] mi_list = AudioSystem.getMixerInfo();
        this.source_mixer_list = new ArrayList<Mixer.Info>();
        this.target_mixer_list = new ArrayList<Mixer.Info>();
        for (Mixer.Info mi : mi_list) {
            Mixer mixer = AudioSystem.getMixer(mi);
            if (mixer.isLineSupported(this.targetLineInfo)) {
                this.target_mixer_list.add(mi);
            }
            if (!mixer.isLineSupported(this.sourceLineInfo)) continue;
            this.source_mixer_list.add(mi);
        }
    }

    public void setup_values() {
        this.close_audio_lines();
        this.audio_source = this.parent.audio_source.get_value();
        this.audio_dest = this.parent.audio_dest.get_value();
        this.sample_rate = this.parent.sample_rate.get_value();
        this.parent.time_scope_pane.reset_scope_size();
        this.baud_rate = this.parent.baud_rate.get_dvalue();
        this.audio_average_tc = 1000.0 / (double)this.sample_rate;
        this.baud_rate = this.baud_rate < 10.0 ? 10.0 : this.baud_rate;
        this.bit_duration_seconds = 1.0 / this.baud_rate;
        this.bit_sample_count = (int)((double)this.sample_rate * this.bit_duration_seconds + 0.5);
        this.half_bit_sample_count = this.bit_sample_count / 2;
        this.pulse_edge_event = false;
        this.shift = false;
        this.error_count = 0;
        this.valid_count = 0;
        this.sample_interval = 1.0 / (double)this.sample_rate;
        this.inverse = true;
        this.bbuffer = new byte[this.bbufsz];
        this.out_buffer = new byte[this.bbufsz];
        this.sbuffer = new short[this.sbufsz];
        this.sample_count = 0L;
        this.next_event_count = 0L;
        this.zero_crossing_count = 0L;
        this.zero_crossings = new int[this.bit_sample_count / this.zero_crossings_divisor];
        this.sync_delta = 0.0;
        this.update_filters();
    }

    public void update_filters() {
        this.set_filter_values();
        this.configure_filters();
    }

    private void set_filter_values() {
        this.center_frequency_f = this.parent.center_frequency.get_dvalue();
        this.mark_space_filter_q = 6.0 * this.center_frequency_f / 1000.0;
        double qv = this.center_frequency_f + 4000.0 / this.center_frequency_f;
        this.mark_f = qv + this.deviation_f;
        this.space_f = qv - this.deviation_f;
        this.pll_omega = Math.PI * 2 * this.center_frequency_f;
        this.biquad_pll_loop_lowpass.configure(BiQuadraticFilter.Type.LOWPASS, this.center_frequency_f, this.sample_rate, this.invsqr2);
        this.biquad_pll_bandpass1.configure(BiQuadraticFilter.Type.BANDPASS, this.center_frequency_f - this.pll_bandpass_deviation_f, this.sample_rate, this.pll_bandpass_q);
        this.biquad_pll_bandpass2.configure(BiQuadraticFilter.Type.BANDPASS, this.center_frequency_f + this.pll_bandpass_deviation_f, this.sample_rate, this.pll_bandpass_q);
    }

    private void configure_filters() {
        this.biquad_mark.configure(BiQuadraticFilter.Type.BANDPASS, this.mark_f, this.sample_rate, this.mark_space_filter_q);
        this.biquad_space.configure(BiQuadraticFilter.Type.BANDPASS, this.space_f, this.sample_rate, this.mark_space_filter_q);
        this.biquad_lowpass.configure(BiQuadraticFilter.Type.LOWPASS, this.lowpass_filter_f, this.sample_rate, this.invsqr2);
        this.biquad_pll_loop_lowpass = new BiQuadraticFilter(BiQuadraticFilter.Type.LOWPASS, this.pll_loop_lowpass_filter_f, this.sample_rate, this.invsqr2);
        this.biquad_pll_output_lowpass = new BiQuadraticFilter(BiQuadraticFilter.Type.LOWPASS, this.pll_output_lowpass_filter_f, this.sample_rate, this.invsqr2);
        this.biquad_pll_bandpass1 = new BiQuadraticFilter(BiQuadraticFilter.Type.BANDPASS, this.pll_center_f - this.pll_bandpass_deviation_f, this.sample_rate, this.pll_bandpass_q);
        this.biquad_pll_bandpass2 = new BiQuadraticFilter(BiQuadraticFilter.Type.BANDPASS, this.pll_center_f + this.pll_bandpass_deviation_f, this.sample_rate, this.pll_bandpass_q);
    }

    public void periodic_actions() {
        this.spectrum_choice = this.parent.spectrum_selection.get_index();
        this.test_audio_restart();
        this.control_monitor_line(this.thread_enabled && this.parent.monitor_volume.get_dvalue() > 0.0);
        this.navtex_message_filtering = this.parent.navtex_filter.get_value();
        this.parent.message_filter_button.setEnabled(this.navtex_message_filtering);
        if (!this.navtex_message_filtering) {
            this.valid_message = false;
        }
        Color col = this.valid_message || !this.navtex_message_filtering ? this.navtex_valid : this.navtex_invalid;
        this.parent.navtex_filter_checkbox.setBackground(col);
    }

    public void test_audio_restart() {
        if (this.time_sec > this.reset_target_time) {
            if (this.state != State.READ_DATA) {
                this.restart();
            }
        }
    }

    public void restart() {
        this.control(false);
        this.control(true);
    }

    public void control(boolean run) {
        if (run) {
            if (!this.thread_enabled) {
                this.setup_values();
                this.thread_enabled = true;
            }
        } else if (this.thread_enabled) {
            this.thread_enabled = false;
            while (this.in_thread_inner_loop) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    this.parent.trace_errors("", e);
                }
            }
        }
    }

    public void end_thread() {
        try {
            this.thread_enabled = false;
            this.thread_exit = true;
            this.join();
        }
        catch (Exception e) {
            this.parent.trace_errors("", e);
        }
    }

    public boolean enabled() {
        return this.thread_enabled;
    }

    public void run() {
        try {
            this.thread_exit = false;
            while (!this.thread_exit) {
                while (this.thread_enabled) {
                    this.in_thread_inner_loop = true;
                    if (this.open_target_line(true, true)) {
                        while (this.thread_enabled && this.targetDataLine != null) {
                            while (this.thread_enabled && (this.available = this.targetDataLine.available()) < this.bbufsz && this.available >= 0) {
                                Thread.sleep(20L);
                            }
                            if (!this.thread_enabled) continue;
                            this.read_length = this.targetDataLine.read(this.bbuffer, 0, this.bbufsz);
                            if (this.read_length <= 0) continue;
                            ShortBuffer sb = ByteBuffer.wrap(this.bbuffer).asShortBuffer();
                            sb.get(this.sbuffer);
                            this.process_data(this.sbuffer);
                            this.write_output(this.sbuffer);
                        }
                    }
                    this.close_audio_lines();
                    this.in_thread_inner_loop = false;
                }
                if (this.thread_exit) continue;
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            this.parent.trace_errors(this.getClass().getSimpleName() + ".run: ", e);
        }
    }

    private void set_state(State s) {
        if (s != this.state) {
            this.state = s;
        }
    }

    private String char_queue_compare_regex() {
        String s;
        int slen;
        String result = null;
        int qlen = this.reception_queue.length();
        if (qlen < (slen = this.start_valid.length())) {
            return null;
        }
        String comp = ((Object)this.reception_queue.subSequence(qlen - slen, qlen)).toString();
        Matcher m = this.start_valid_regex.matcher(comp);
        if (m.matches() && this.parent.accepted_navtex_messages.accept(s = "" + comp.charAt(6))) {
            result = comp;
        }
        return result;
    }

    private boolean char_queue_compare(String s) {
        int slen;
        int qlen = this.reception_queue.length();
        if (qlen < (slen = s.length())) {
            return false;
        }
        String comp = ((Object)this.reception_queue.subSequence(qlen - slen, qlen)).toString();
        boolean r = comp.equals(s);
        return r;
    }

    private void char_queue(int c) {
        if (this.navtex_message_filtering) {
            this.reception_queue.append((char)c);
            while (this.reception_queue.length() > 16) {
                this.reception_queue.deleteCharAt(0);
            }
            if (!this.valid_message) {
                String s = this.char_queue_compare_regex();
                if (s != null) {
                    this.valid_message = true;
                    this.message_time = this.time_sec;
                    for (int i = 0; i < s.length(); ++i) {
                        this.filter_print(s.charAt(i));
                    }
                }
            } else if (this.char_queue_compare(this.stop_valid) || this.time_sec - this.message_time > 600.0) {
                this.valid_message = false;
            }
        }
    }

    private void debug_print(int code) {
        int ch = this.ccir476.code_to_char(code, false);
        ch = ch < 0 ? 95 : ch;
        String qs = this.alpha_phase ? "alpha                                " : "rep";
        System.out.println(String.format("%s|%x:%c", qs, code, ch));
    }

    private boolean process_char(int code) {
        boolean success = CCIR476.check_bits(code);
        int chr = -1;
        if (code == 102) {
            this.alpha_phase = false;
        } else if (code == 15) {
            this.alpha_phase = true;
        }
        if (!this.alpha_phase) {
            this.c1 = this.c2;
            this.c2 = this.c3;
            this.c3 = code;
        } else {
            if (this.parent.strict.get_value()) {
                if (success && this.c1 == code) {
                    chr = code;
                }
            } else if (success) {
                chr = code;
            } else if (CCIR476.check_bits(this.c1)) {
                chr = this.c1;
            }
            if (chr == -1) {
                ++this.fail_tally;
            } else {
                ++this.succeed_tally;
                switch (chr) {
                    case 102: {
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 51: {
                        break;
                    }
                    case 106: {
                        break;
                    }
                    case 90: {
                        this.shift = false;
                        break;
                    }
                    case 54: {
                        this.shift = true;
                        break;
                    }
                    default: {
                        chr = this.ccir476.code_to_char(chr, this.shift);
                        if (chr < 0) {
                            this.parent.debug_p(String.format("missed this code: %x", Math.abs(chr)));
                            break;
                        }
                        if (!this.navtex_message_filtering || this.valid_message) {
                            this.filter_print(chr);
                        }
                        this.char_queue(chr);
                    }
                }
            }
        }
        this.alpha_phase = !this.alpha_phase;
        return success;
    }

    private void filter_print(int c) {
        if (c == 7) {
            this.parent.beep();
        } else if (c != -1 && c != 13 && c != 15 && c != 102) {
            this.parent.append_to_data_page("" + (char)c);
        }
    }

    private double max(double a, double b) {
        return a > b ? a : b;
    }

    private void process_data(short[] data) {
        for (short v : data) {
            this.time_sec = (double)this.sample_count * this.sample_interval;
            this.dv = v;
            if (this.pll_mode) {
                this.audio_average += (Math.abs(this.dv) - this.audio_average) * this.audio_average_tc;
                this.audio_average = Math.max(0.1, this.audio_average);
                this.dv /= this.audio_average;
                this.dv = this.biquad_pll_bandpass1.filter(this.dv);
                this.dv = this.biquad_pll_bandpass2.filter(this.dv);
                this.pll_loop_control = this.dv * this.pll_reference * this.pll_loop_gain;
                this.pll_loop_control = this.biquad_pll_loop_lowpass.filter(this.pll_loop_control);
                this.pll_integral += this.pll_loop_control * this.sample_interval;
                if (Double.isInfinite(this.pll_integral)) {
                    this.pll_integral = 0.0;
                }
                this.pll_reference = Math.sin(this.pll_omega * (this.time_sec + this.pll_integral));
                this.logic_level = this.biquad_pll_output_lowpass.filter(this.pll_loop_control);
                this.logic_level *= this.center_frequency_f / 85.0;
            } else {
                this.mark_level = this.biquad_mark.filter(this.dv);
                this.space_level = this.biquad_space.filter(this.dv);
                this.mark_abs = Math.abs(this.mark_level);
                this.space_abs = Math.abs(this.space_level);
                this.audio_average += (this.max(this.mark_abs, this.space_abs) - this.audio_average) * this.audio_average_tc;
                this.audio_average = Math.max(0.1, this.audio_average);
                this.diffabs = this.mark_abs - this.space_abs;
                this.diffabs /= this.audio_average;
                this.dv /= this.audio_average;
                this.mark_level /= this.audio_average;
                this.space_level /= this.audio_average;
                this.logic_level = this.biquad_lowpass.filter(this.diffabs);
            }
            this.mark_state = this.logic_level > 0.0;
            this.signal_accumulator += this.mark_state ? 1.0 : -1.0;
            ++this.bit_duration;
            if (this.zero_crossings != null) {
                if (this.mark_state != this.old_mark_state) {
                    if (this.bit_duration % this.bit_sample_count > this.half_bit_sample_count) {
                        int index = (int)((this.sample_count - this.next_event_count + (long)(this.bit_sample_count * 8)) % (long)this.bit_sample_count);
                        int n = index / this.zero_crossings_divisor;
                        this.zero_crossings[n] = this.zero_crossings[n] + 1;
                    }
                    this.bit_duration = 0;
                }
                this.old_mark_state = this.mark_state;
                if (this.sample_count % (long)this.bit_sample_count == 0L) {
                    ++this.zero_crossing_count;
                    if (this.zero_crossing_count >= (long)this.zero_crossing_samples) {
                        int best = 0;
                        double index = 0.0;
                        for (int i = 0; i < this.zero_crossings.length; ++i) {
                            int q = this.zero_crossings[i];
                            this.zero_crossings[i] = 0;
                            if (q <= best) continue;
                            best = q;
                            index = i;
                        }
                        if (best > 0) {
                            index *= (double)this.zero_crossings_divisor;
                            index = (index + (double)this.half_bit_sample_count) % (double)this.bit_sample_count - (double)this.half_bit_sample_count;
                            this.sync_delta = index /= 8.0;
                            this.baud_error = index;
                        }
                        this.zero_crossing_count = 0L;
                    }
                }
            }
            boolean bl = this.pulse_edge_event = this.sample_count >= this.next_event_count;
            if (this.pulse_edge_event) {
                this.averaged_mark_state = this.signal_accumulator > 0.0 ^ this.inverse;
                this.signal_accumulator = 0.0;
                this.next_event_count = this.sample_count + (long)this.bit_sample_count + (long)((int)(this.sync_delta + 0.5));
                this.sync_delta = 0.0;
            }
            if (this.parent.scope_visible) {
                this.parent.time_scope_pane.write_value(this.logic_level);
                double sv = 0.0;
                switch (this.spectrum_choice) {
                    case 2: {
                        sv = this.dv;
                        break;
                    }
                    case 1: {
                        sv = this.space_level;
                        break;
                    }
                    case 0: {
                        sv = this.mark_level;
                    }
                }
                this.parent.spectrum_manager.add_data(sv);
            }
            if (this.audio_average < this.audio_minimum) {
                this.set_state(State.NOSIGNAL);
            } else if (this.state == State.NOSIGNAL) {
                this.state = State.SYNC_SETUP;
            }
            switch (this.state) {
                case SYNC_SETUP: {
                    this.bit_count = -1;
                    this.code_bits = 0;
                    this.error_count = 0;
                    this.valid_count = 0;
                    this.shift = false;
                    this.sync_chars.clear();
                    this.state = State.SYNC1;
                    break;
                }
                case SYNC1: {
                    if (!this.pulse_edge_event) break;
                    this.code_bits = this.code_bits >> 1 | (this.averaged_mark_state ? 64 : 0);
                    if (!CCIR476.check_bits(this.code_bits)) break;
                    this.sync_chars.add(this.code_bits);
                    this.bit_count = 0;
                    this.code_bits = 0;
                    this.state = State.SYNC2;
                    break;
                }
                case SYNC2: {
                    if (!this.pulse_edge_event) break;
                    this.code_bits = this.code_bits >> 1 | (this.averaged_mark_state ? 64 : 0);
                    ++this.bit_count;
                    if (this.bit_count != 7) break;
                    if (CCIR476.check_bits(this.code_bits)) {
                        this.sync_chars.add(this.code_bits);
                        this.code_bits = 0;
                        this.bit_count = 0;
                        ++this.valid_count;
                        if (this.valid_count != 4) break;
                        for (Integer c : this.sync_chars) {
                            this.process_char(c);
                        }
                        this.state = State.READ_DATA;
                        break;
                    }
                    this.code_bits = 0;
                    this.bit_count = 0;
                    this.state = State.SYNC_SETUP;
                    break;
                }
                case READ_DATA: {
                    if (!this.pulse_edge_event) break;
                    this.code_bits = this.code_bits >> 1 | (this.averaged_mark_state ? 64 : 0);
                    ++this.bit_count;
                    if (this.bit_count != 7) break;
                    if (this.error_count > 0) {
                        // empty if block
                    }
                    if (this.process_char(this.code_bits)) {
                        if (this.error_count > 0) {
                            --this.error_count;
                        }
                    } else {
                        ++this.error_count;
                        if (this.error_count > 2) {
                            this.state = State.SYNC_SETUP;
                        }
                    }
                    this.bit_count = 0;
                    this.code_bits = 0;
                }
            }
            ++this.sample_count;
        }
    }

    private void close_audio_lines() {
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
            this.targetDataLine.close();
            this.targetDataLine = null;
        }
        if (this.sourceDataLine != null) {
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
            this.sourceDataLine = null;
        }
    }

    public boolean open_target_line(boolean run, boolean force) {
        try {
            if (run && this.target_mixer_list.size() > 0) {
                this.set_state(State.SYNC_SETUP);
                this.shift = false;
                if (this.targetDataLine != null || force) {
                    this.close_audio_lines();
                    int n = this.audio_source;
                    n = Math.min(n, this.target_mixer_list.size() - 1);
                    Mixer.Info mi = this.target_mixer_list.get(n);
                    Mixer mixer = AudioSystem.getMixer(mi);
                    this.audioFormat = this.define_audio_format();
                    DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
                    this.targetDataLine = (TargetDataLine)mixer.getLine(this.targetLineInfo);
                    this.targetDataLine.open(this.audioFormat, this.bbufsz * 2);
                    this.targetDataLine.start();
                    this.thread_enabled = run;
                }
            } else {
                this.close_audio_lines();
            }
        }
        catch (Exception e) {
            this.targetDataLine = null;
            this.parent.trace_errors(this.getClass().getSimpleName() + ".init: ", e);
            return false;
        }
        return true;
    }

    private void control_monitor_line(boolean run) {
        try {
            if (run && this.source_mixer_list.size() > 0) {
                if (this.sourceDataLine == null && this.source_mixer_list.size() > 0) {
                    int i = this.parent.audio_dest.get_value();
                    i = i >= this.source_mixer_list.size() ? this.source_mixer_list.size() - 1 : i;
                    this.audioFormat = this.define_audio_format();
                    Mixer.Info mi = this.source_mixer_list.get(i);
                    Mixer mixer = AudioSystem.getMixer(mi);
                    this.sourceDataLine = (SourceDataLine)mixer.getLine(this.sourceLineInfo);
                    this.sourceDataLine.open(this.audioFormat);
                    this.sourceDataLine.start();
                }
            } else if (this.sourceDataLine != null) {
                this.sourceDataLine.stop();
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
        }
        catch (Exception e) {
            this.sourceDataLine = null;
            this.parent.trace_errors("control_monitor_line: ", e);
        }
    }

    public void write_output(short[] data) {
        if (this.sourceDataLine != null) {
            double gain = this.parent.monitor_volume.get_pct_dvalue();
            ByteBuffer byb = ByteBuffer.wrap(this.out_buffer);
            for (short sv : data) {
                byb.putShort((short)((double)sv * gain));
            }
            this.sourceDataLine.write(this.out_buffer, 0, this.out_buffer.length);
        }
    }

    AudioFormat define_audio_format() {
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = true;
        float rate = this.sample_rate;
        return new AudioFormat(rate, sampleSizeInBits, channels, signed, bigEndian);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOSIGNAL,
        SYNC_SETUP,
        SYNC1,
        SYNC2,
        READ_DATA;

    }
}

