/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jrx.ControlInterface;
import jrx.JRX;

public final class RWSlider
extends JSlider
implements MouseWheelListener,
ChangeListener,
ControlInterface {
    JRX parent;
    String token;
    String prefix;
    int initial = 0;
    double errorValue = 1.0E100;
    double oldValue = -1.0;
    double xValueLow = 0.0;
    double xValueHigh = 100.0;
    double yValueLow = 0.0;
    double yValueHigh = 1.0;
    double level = -1.0;
    double oldLevel = -1.0;
    boolean localInhibit = false;
    boolean commOK = true;

    public RWSlider(JRX p, String pre, String t, int initial) {
        this.parent = p;
        this.prefix = pre;
        this.token = t;
        this.initial = initial;
        this.setMajorTickSpacing(10);
        this.setMinorTickSpacing(5);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setup(true);
    }

    private void setup(boolean first) {
        if (first) {
            this.addMouseWheelListener(this);
            this.addChangeListener(this);
        }
        this.setValue(this.initial);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.writeValue(false);
    }

    public void writeValue(double v, boolean force) {
        this.readConvertedValue(v);
        this.writeValue(force);
    }

    @Override
    public void writeValue(boolean force) {
        if ((this.commOK || force) && !this.parent.inhibit && !this.localInhibit && this.isEnabled()) {
            this.level = this.getConvertedValue();
            if (this.parent.useJRXSquelch && this.token.equals("AF")) {
                double d = this.level = this.parent.squelchOpen == 1 ? this.level : 0.0;
            }
            if (force || this.level != this.oldLevel) {
                String com = String.format("%s %s %.2f", this.prefix.toUpperCase(), this.token, this.level);
                this.parent.sendRadioCom(com, 0, true);
                this.oldLevel = this.level;
            }
        }
    }

    protected double readValue() {
        double localLvl = this.errorValue;
        if (this.commOK && this.token != null && this.isEnabled()) {
            localLvl = this.level;
            String com = String.format("%s %s", this.prefix.toLowerCase(), this.token);
            String s = this.parent.sendRadioCom(com, 0, false);
            try {
                localLvl = Double.parseDouble(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return localLvl;
    }

    protected double ntrp(double xl, double xh, double yl, double yh, double x) {
        return (x - xl) * (yh - yl) / (xh - xl) + yl;
    }

    @Override
    public void readConvertedValue(double x) {
        int y = (int)(this.ntrp(this.yValueLow, this.yValueHigh, this.xValueLow, this.xValueHigh, x) + 0.5);
        this.localInhibit = true;
        this.setValue(y);
        this.localInhibit = false;
    }

    @Override
    public void readConvertedValue() {
        this.level = this.readValue();
        if (this.level != this.errorValue && this.level != this.oldLevel) {
            this.readConvertedValue(this.level);
            this.oldLevel = this.level;
        }
    }

    @Override
    public void selectiveReadValue(boolean all) {
        if (this.isEnabled()) {
            this.readConvertedValue();
        }
    }

    @Override
    public double getConvertedValue() {
        return this.ntrp(this.xValueLow, this.xValueHigh, this.yValueLow, this.yValueHigh, this.getValue());
    }

    @Override
    public void setXLow(double x) {
        this.xValueLow = x;
    }

    @Override
    public void setXHigh(double x) {
        this.xValueHigh = x;
    }

    @Override
    public void setYLow(double y) {
        this.yValueLow = y;
    }

    @Override
    public void setYHigh(double y) {
        this.yValueHigh = y;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int v = e.getWheelRotation();
        int iv = v < 0 ? -1 : 1;
        this.setValue(this.getValue() + iv);
    }

    @Override
    public void setValue(int v) {
        super.setValue(v);
    }
}

