/*
 * Decompiled with CFR 0.152.
 */
package jsiggen;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import jsiggen.JSigGenPanel;
import jsiggen.SigFunction;

public class SignalGenerator
extends Thread {
    JSigGenPanel parent;
    boolean running = false;
    int word_size = 2;
    int mask = 255;
    int sbufsz = 2048;
    int bbufsz = this.sbufsz * 2;
    byte[] bbuffer;
    short[] sbuffer;
    int data_rate;
    double sample_interval;
    double scale_mult = Math.pow(2.0, 15.0);
    SourceDataLine audioOutputLine = null;
    AudioFormat audioFormat = null;
    SigFunction fsine = new SigFunction(){

        public double f(double f, double t) {
            return Math.sin(Math.PI * 2 * f * t);
        }
    };
    SigFunction ftriangle = new SigFunction(){

        public double f(double f, double t) {
            double q = 4.0 * (t * f % 1.0);
            q = q > 1.0 ? 2.0 - q : q;
            return q < -1.0 ? -2.0 - q : q;
        }
    };
    SigFunction fsquare = new SigFunction(){

        public double f(double f, double t) {
            if (f == 0.0) {
                return 0.0;
            }
            double q = 0.5 - t * f % 1.0;
            return q > 0.0 ? 1.0 : -1.0;
        }
    };
    SigFunction fsawtooth = new SigFunction(){

        public double f(double f, double t) {
            return 2.0 * ((t * f + 0.5) % 1.0) - 1.0;
        }
    };
    SigFunction[] functs = new SigFunction[]{this.fsine, this.ftriangle, this.fsquare, this.fsawtooth};

    public SignalGenerator(JSigGenPanel p) {
        this.parent = p;
        this.bbuffer = new byte[this.bbufsz];
        this.sbuffer = new short[this.sbufsz];
    }

    AudioFormat createAudioFormat() {
        int sampleSizeInBits = 8 * this.word_size;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = true;
        float rate = this.data_rate;
        return new AudioFormat(rate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public void run() {
        this.data_rate = this.parent.data_rate.get_ivalue();
        try {
            this.audioFormat = this.createAudioFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            Mixer m = this.parent.source_mixers.get(this.parent.output_channel.get_ivalue() - 1);
            this.audioOutputLine = (SourceDataLine)m.getLine(info);
            this.audioOutputLine.open(this.audioFormat, this.bbufsz * 4);
            this.audioOutputLine.start();
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        this.sample_interval = 1.0 / (double)this.data_rate;
        this.running = true;
        double time_sec = 0.0;
        double fm_integral = 0.0;
        int n = 0;
        while (this.running) {
            double sig;
            SigFunction sf = this.functs[this.parent.signal_waveform.get_index()];
            if (!this.parent.modulation_enabled.get_value()) {
                sig = sf.f(this.parent.frequency.get_dvalue(), time_sec);
            } else {
                SigFunction mf = this.functs[this.parent.modulation_waveform.get_index()];
                double mod = mf.f(this.parent.modulation_frequency.get_dvalue(), time_sec) * this.parent.modulation_level.get_pct_dvalue();
                sig = this.parent.am_fm_mode.get_index() == 0 ? 0.5 * sf.f(this.parent.frequency.get_dvalue(), time_sec) * (1.0 + mod) : sf.f(this.parent.frequency.get_dvalue(), time_sec + (fm_integral += mod) * this.sample_interval);
            }
            double osig = 0.0;
            if (this.parent.noise_enabled.get_value()) {
                double noise = (Math.random() - 0.5) * 2.0;
                osig += noise * this.parent.noise_level.get_pct_dvalue();
            }
            if (this.parent.signal_enabled.get_value()) {
                osig += sig * this.parent.signal_level.get_pct_dvalue();
            }
            short ssig = (short)(osig * this.scale_mult);
            this.sbuffer[n++] = this.parent.left_channel_enabled.get_value() ? ssig : (short)0;
            short s = this.sbuffer[n++] = this.parent.right_channel_enabled.get_value() ? ssig : (short)0;
            if (n >= this.sbufsz) {
                n = 0;
                int j = 0;
                for (int i = 0; i < this.sbuffer.length; ++i) {
                    ssig = this.sbuffer[i];
                    this.bbuffer[j++] = (byte)(ssig >> 8 & this.mask);
                    this.bbuffer[j++] = (byte)(ssig & this.mask);
                }
                try {
                    this.audioOutputLine.write(this.bbuffer, 0, this.bbufsz);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            time_sec += this.sample_interval;
        }
        if (this.audioOutputLine != null) {
            this.audioOutputLine.flush();
            this.audioOutputLine.drain();
            this.audioOutputLine.close();
            this.audioOutputLine = null;
        }
    }
}

