/*
 * Decompiled with CFR 0.152.
 */
package jsiggen;

import java.awt.Color;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JTextField;
import jsiggen.ControlInterface;

public final class TextFieldController
implements ControlInterface {
    JTextField field;
    private String value;
    private double dvalue = 0.0;
    private double pct_dvalue;
    private double multiplier;
    private double n;

    public TextFieldController(JTextField f, double multiplier, String s) {
        this.multiplier = multiplier;
        this.field = f;
        this.field.setText(s);
        this.input_changed();
        this.field.setToolTipText("<html>Change by typing or spin mouse wheel<br/>(Ctrl,Shift,Alt increase rate of change)</html>");
        this.field.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                TextFieldController.this.input_changed();
            }
        });
        this.field.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                TextFieldController.this.mouse_wheel_event(evt);
            }
        });
    }

    private void mouse_wheel_event(MouseWheelEvent evt) {
        if (this.field.isEnabled()) {
            double n = evt.getWheelRotation() > 0 ? -1.0 : 1.0;
            this.process_modifier(evt, n);
        }
    }

    private void process_modifier(InputEvent evt, double n) {
        n = evt.isShiftDown() ? n * 10.0 : n;
        n = evt.isControlDown() ? n * 10.0 : n;
        n = evt.isAltDown() ? n * 10.0 : n;
        this.dvalue += n * this.multiplier;
        this.dvalue = this.dvalue < 0.0 ? 0.0 : this.dvalue;
        this.process_entry();
        this.input_changed();
        this.process_entry();
    }

    private void process_entry() {
        this.value = String.format("%.1f", this.dvalue);
        this.field.setText(this.value);
    }

    private void input_changed() {
        this.field.setForeground(Color.black);
        try {
            this.value = this.field.getText();
            this.dvalue = Double.parseDouble(this.value);
        }
        catch (Exception e) {
            this.dvalue = 0.0;
            this.field.setForeground(Color.red);
        }
        this.dvalue = this.dvalue < 0.0 ? 0.0 : this.dvalue;
        this.pct_dvalue = this.dvalue * 0.01;
    }

    public String get_value() {
        return String.format("%.1f", this.dvalue);
    }

    public double get_dvalue() {
        return this.dvalue;
    }

    public double get_pct_dvalue() {
        return this.pct_dvalue;
    }

    public void set_value(String s) {
        this.field.setText(s);
        this.input_changed();
    }

    public void set_value(double v) {
        this.set_value("" + v);
    }

    public String toString() {
        return this.value;
    }
}

