/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package jsiggen;

import javax.swing.*;
import java.util.*;

/**
 *
 * @author lutusp
 */
final public class ComboBoxController implements ControlInterface {

    JComboBox box;
    String value;
    int ivalue = 0;
    int index = 0;

    public ComboBoxController(JComboBox b, List<String> data, String sel) {
        box = b;
        box.addMouseWheelListener(new java.awt.event.MouseWheelListener() {

            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                mouse_wheel_event(evt);
            }
        });
        box.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                item_state_changed(evt);
            }
        });
        populate_combobox(data, sel);
    }

    public void populate_combobox(List<String> data, String sel) {
        box.removeAllItems();
        Iterator i = data.iterator();
        while (i.hasNext()) {
            box.addItem(i.next());
        }
        set_value(sel);
    }

    private void mouse_wheel_event(java.awt.event.MouseWheelEvent evt) {
        if (box.isEnabled()) {
            double n = (evt.getWheelRotation() > 0) ? 1 : -1;
            // modifier key multipliers
            n = (evt.isShiftDown()) ? n * 10 : n;
            n = (evt.isControlDown()) ? n * 10 : n;
            n = (evt.isAltDown()) ? n * 10 : n;
            int v = box.getSelectedIndex();
            v += n;
            v = check_range(v);
            box.setSelectedIndex(v);
        }
    }

    private int check_range(int v) {
        int top = box.getItemCount();
        v = Math.min(top - 1, v);
        v = Math.max(0, v);
        return v;
    }

    private void item_state_changed(java.awt.event.ItemEvent evt) {
        index = box.getSelectedIndex();
        value = (String) box.getSelectedItem();
        try {
            ivalue = Integer.parseInt(value);
        } catch (Exception e) {
        }
    }

    public String get_value() {
        return value;
    }

    public int get_ivalue() {
        return ivalue;
    }

    public int get_index() {
        return index;
    }

    public void set_value(String s) {
        box.setSelectedItem(s);
        value = s;
    }

    @Override
    public String toString() {
        return value;
    }
}
