/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public final class Beep
extends Thread {
    float sampleRate = 32000.0f;
    int freqHz;
    int durationMsec;
    double level;

    public Beep(int n2, int n3, double d2) {
        this.freqHz = n2;
        this.durationMsec = n3;
        this.level = d2 * 32767.0;
        this.start();
    }

    private double envelope(double d2, double d3, double d4, double d5) {
        return (d3 - d4) * (-d2 + d4) / ((d3 - d4 + d5) * (-d2 + d4 + d5));
    }

    @Override
    public void run() {
        try {
            int n2 = (int)(2.0f * this.sampleRate * (float)this.durationMsec / 1000.0f);
            byte[] byArray = new byte[n2];
            double d2 = Math.PI * 2 * (double)this.freqHz / (double)this.sampleRate;
            double d3 = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = (int)(Math.sin(d3) * this.level * this.envelope(0.0, n2, n3, 1000.0));
                byArray[n3++] = (byte)(n4 % 256);
                byArray[n3++] = (byte)(n4 / 256);
                d3 += d2;
            }
            AudioFormat audioFormat = new AudioFormat(this.sampleRate, 16, 1, true, false);
            SourceDataLine sourceDataLine = AudioSystem.getSourceDataLine(audioFormat);
            sourceDataLine.open(audioFormat);
            sourceDataLine.start();
            sourceDataLine.write(byArray, 0, byArray.length);
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void beep(double d2) {
        new Beep(1000, 100, d2);
    }

    public static void beep() {
        new Beep(1000, 100, 0.5);
    }

    public static void main(String[] stringArray) {
        Beep.beep(0.5);
    }
}

