/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import magiclantern.CommonCode;
import magiclantern.MagicLantern;

public final class SetupControlPanel
extends JPanel {
    MagicLantern parent;
    private JLabel allocatedLabel;
    private JCheckBox fadeEffectCheckBox;
    private JLabel freeLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel maximumLabel;
    private JLabel memStatLabel;
    private JPanel memoryPanel;
    private JTextField slideDurationTextField;
    private JPanel topInnerPanel;
    private JTextField transitionDurationTextField;
    private JTextField transitionStepsTextField;
    private JButton updateButton;
    private JButton updateMemoryButton;
    private JCheckBox whiteBackgroundCheckBox;

    public SetupControlPanel(MagicLantern magicLantern) {
        this.parent = magicLantern;
        this.initComponents();
        this.setupDefaults();
        this.updateMemStats();
    }

    void setupDefaults() {
        this.slideDurationTextField.setText("" + this.parent.sv_autoShowSlideDurationSeconds);
        this.transitionStepsTextField.setText("" + this.parent.sv_fadeSteps);
        this.transitionDurationTextField.setText("" + this.parent.sv_fadeDurationMilliseconds);
        this.fadeEffectCheckBox.setSelected(this.parent.sv_fadeMode);
        this.whiteBackgroundCheckBox.setSelected(this.parent.sv_editWhiteBackground);
    }

    void readAllEntries() {
        this.parent.sv_autoShowSlideDurationSeconds = this.getIntEntry(this.slideDurationTextField, this.parent.sv_autoShowSlideDurationSeconds);
        this.parent.sv_fadeSteps = this.getIntEntry(this.transitionStepsTextField, this.parent.sv_fadeSteps);
        this.parent.sv_fadeDurationMilliseconds = this.getIntEntry(this.transitionDurationTextField, this.parent.sv_fadeDurationMilliseconds);
        this.setupDefaults();
    }

    int getIntEntry(JTextField jTextField, int n2) {
        try {
            int n3 = Integer.parseInt(jTextField.getText());
            if (n3 > 0) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            jTextField.setText("" + n2);
        }
        return n2;
    }

    void updateIfReturnPressed(KeyEvent keyEvent, int n2) {
        if (keyEvent.getKeyChar() == '\n') {
            this.readAllEntries();
        }
    }

    void updateFadeEffect() {
        this.parent.sv_fadeMode = this.fadeEffectCheckBox.isSelected();
    }

    void updateBlackEditBackground() {
        this.parent.sv_editWhiteBackground = this.whiteBackgroundCheckBox.isSelected();
        this.parent.editBase.editPanel.setEditRenderer();
        this.parent.editBase.browsePanel.setEditRenderer();
    }

    public void updateMemStats() {
        Runtime.getRuntime().gc();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = Runtime.getRuntime().totalMemory();
        long l4 = Runtime.getRuntime().maxMemory();
        this.allocatedLabel.setText(CommonCode.createDecimalFormat(l3));
        this.freeLabel.setText(CommonCode.createDecimalFormat(l2));
        this.maximumLabel.setText(CommonCode.createDecimalFormat(l4));
        Color color = Color.black;
        String string = "Status: sufficient memory.";
        if ((double)l3 / (double)l4 > 0.85) {
            color = Color.red;
            string = "Status: marginal memory.";
        }
        this.allocatedLabel.setForeground(color);
        this.freeLabel.setForeground(color);
        this.maximumLabel.setForeground(color);
        this.memStatLabel.setText(string);
        this.memStatLabel.setForeground(color);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.topInnerPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.slideDurationTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.transitionDurationTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.transitionStepsTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.whiteBackgroundCheckBox = new JCheckBox();
        this.fadeEffectCheckBox = new JCheckBox();
        this.updateButton = new JButton();
        this.memoryPanel = new JPanel();
        this.maximumLabel = new JLabel();
        this.updateMemoryButton = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.freeLabel = new JLabel();
        this.allocatedLabel = new JLabel();
        this.memStatLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setMinimumSize(new Dimension(488, 100));
        this.setPreferredSize(new Dimension(369, 100));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("<html><b>Set Up Controls</b></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(351, 8));
        this.jPanel1.setLayout(new GridBagLayout());
        this.topInnerPanel.setBackground(new Color(200, 255, 200));
        this.topInnerPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.topInnerPanel.setMinimumSize(new Dimension(464, 100));
        this.topInnerPanel.setPreferredSize(new Dimension(538, 100));
        this.topInnerPanel.setLayout(new GridBagLayout());
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Auto show slide duration seconds:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        this.topInnerPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.slideDurationTextField.setHorizontalAlignment(4);
        this.slideDurationTextField.setText("jTextField1");
        this.slideDurationTextField.setToolTipText("Enter a slide duration for the automatic slide show feature");
        this.slideDurationTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SetupControlPanel.this.slideDurationTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.topInnerPanel.add((Component)this.slideDurationTextField, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Transition fade duration (milliseconds):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        this.topInnerPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.transitionDurationTextField.setHorizontalAlignment(4);
        this.transitionDurationTextField.setText("jTextField2");
        this.transitionDurationTextField.setToolTipText("Enter a duration in milliseconds for the fade-effect slide transition");
        this.transitionDurationTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SetupControlPanel.this.transitionDurationTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.topInnerPanel.add((Component)this.transitionDurationTextField, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Transition fade steps:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        this.topInnerPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.transitionStepsTextField.setHorizontalAlignment(4);
        this.transitionStepsTextField.setText("jTextField3");
        this.transitionStepsTextField.setToolTipText("Enter the number of steps in the fade-effect slide transition");
        this.transitionStepsTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SetupControlPanel.this.transitionStepsTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.topInnerPanel.add((Component)this.transitionStepsTextField, gridBagConstraints);
        this.jPanel2.setBackground(new Color(200, 255, 200));
        this.jPanel2.setLayout(new GridBagLayout());
        this.whiteBackgroundCheckBox.setBackground(new Color(200, 255, 200));
        this.whiteBackgroundCheckBox.setText("White edit background");
        this.whiteBackgroundCheckBox.setToolTipText("Change the editor's default black background");
        this.whiteBackgroundCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SetupControlPanel.this.whiteBackgroundCheckBoxMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.whiteBackgroundCheckBox, gridBagConstraints);
        this.fadeEffectCheckBox.setBackground(new Color(200, 255, 200));
        this.fadeEffectCheckBox.setText("Enable fade effect");
        this.fadeEffectCheckBox.setToolTipText("<html>This is a nice transition, but it requires a fast<br/>computer when displaying large images.</html>");
        this.fadeEffectCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SetupControlPanel.this.fadeEffectCheckBoxMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.fadeEffectCheckBox, gridBagConstraints);
        this.updateButton.setText("Commit");
        this.updateButton.setToolTipText("Press to commit your configuration changes");
        this.updateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SetupControlPanel.this.updateButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.updateButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.topInnerPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.topInnerPanel, gridBagConstraints);
        this.memoryPanel.setBackground(new Color(200, 240, 255));
        this.memoryPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.memoryPanel.setMinimumSize(new Dimension(321, 75));
        this.memoryPanel.setPreferredSize(new Dimension(321, 75));
        this.memoryPanel.setLayout(new GridBagLayout());
        this.maximumLabel.setText("0");
        this.maximumLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.maximumLabel, gridBagConstraints);
        this.updateMemoryButton.setText("Refresh");
        this.updateMemoryButton.setToolTipText("Update memory statistics");
        this.updateMemoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SetupControlPanel.this.updateMemoryButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.updateMemoryButton, gridBagConstraints);
        this.jLabel5.setText("Memory Statistics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("Allocated");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Free");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Maximum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.freeLabel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.freeLabel, gridBagConstraints);
        this.allocatedLabel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.allocatedLabel, gridBagConstraints);
        this.memStatLabel.setHorizontalAlignment(0);
        this.memStatLabel.setText("Memory Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.memoryPanel.add((Component)this.memStatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel1.add((Component)this.memoryPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void slideDurationTextFieldKeyTyped(KeyEvent keyEvent) {
        this.updateIfReturnPressed(keyEvent, 0);
    }

    private void transitionDurationTextFieldKeyTyped(KeyEvent keyEvent) {
        this.updateIfReturnPressed(keyEvent, 1);
    }

    private void transitionStepsTextFieldKeyTyped(KeyEvent keyEvent) {
        this.updateIfReturnPressed(keyEvent, 2);
    }

    private void updateButtonMouseClicked(MouseEvent mouseEvent) {
        this.readAllEntries();
    }

    private void fadeEffectCheckBoxMouseClicked(MouseEvent mouseEvent) {
        this.updateFadeEffect();
    }

    private void whiteBackgroundCheckBoxMouseClicked(MouseEvent mouseEvent) {
        this.updateBlackEditBackground();
    }

    private void updateMemoryButtonMouseClicked(MouseEvent mouseEvent) {
        this.updateMemStats();
    }
}

