/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package magiclantern;

/**
 *
 * @author lutusp
 */
final public class EditBase extends javax.swing.JPanel {

    MagicLantern parent;
    EditShowPanel editPanel;
    EditBrowsePanel browsePanel;
    

    /** Creates new form EditTab */
    public EditBase(MagicLantern p) {
        parent = p;
        initComponents();
        editPanel = new EditShowPanel(parent,this);
        browsePanel = new EditBrowsePanel(parent,this);
        editSplitPane.setDividerLocation(parent.programValues.dividerLocation);
        editSplitPane.setLeftComponent(editPanel);
        editSplitPane.setRightComponent(browsePanel);
    }

    public int getDividerLocation() {
        return editSplitPane.getDividerLocation();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        editPopupMenu = new javax.swing.JPopupMenu();
        cutMenuItem = new javax.swing.JMenuItem();
        copyMenuItem = new javax.swing.JMenuItem();
        pasteMenuItem = new javax.swing.JMenuItem();
        editSplitPane = new javax.swing.JSplitPane();

        cutMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-cut.png"))); // NOI18N
        cutMenuItem.setMnemonic('t');
        cutMenuItem.setText("Cut");
        editPopupMenu.add(cutMenuItem);

        copyMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-copy.png"))); // NOI18N
        copyMenuItem.setMnemonic('y');
        copyMenuItem.setText("Copy");
        editPopupMenu.add(copyMenuItem);

        pasteMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-paste.png"))); // NOI18N
        pasteMenuItem.setMnemonic('p');
        pasteMenuItem.setText("Paste");
        editPopupMenu.add(pasteMenuItem);

        setLayout(new java.awt.GridBagLayout());

        editSplitPane.setDividerLocation(200);
        editSplitPane.setContinuousLayout(true);
        editSplitPane.setDoubleBuffered(true);
        editSplitPane.setOneTouchExpandable(true);
        editSplitPane.setPreferredSize(new java.awt.Dimension(300, 300));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(editSplitPane, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JMenuItem copyMenuItem;
    protected javax.swing.JMenuItem cutMenuItem;
    protected javax.swing.JPopupMenu editPopupMenu;
    private javax.swing.JSplitPane editSplitPane;
    protected javax.swing.JMenuItem pasteMenuItem;
    // End of variables declaration//GEN-END:variables

}
