/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 package magiclantern;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 *
 * @author lutusp
 */
final public class EditCellRenderer extends JLabel implements ListCellRenderer {

    Color selectedColor = new Color(0.7f, 0.8f, 1.0f);
    Color backgroundColor;
    MagicLantern parent;

    public EditCellRenderer(MagicLantern p,Color bc,Color fc) {
        parent = p;
        backgroundColor = bc;
        setOpaque(true);
        setHorizontalAlignment(CENTER);
        setBorder(new EmptyBorder(4,4,4,4));
        setForeground(fc);
        Font f = getFont();
        Font df = f.deriveFont(parent.programValues.thumbnailImageSize / 8.0f);
        this.setFont(df);
    }

    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {
        EditCellDatum ecd = (EditCellDatum) value;
        // deal with icon not ready
        if (ecd.getImageIcon() != null) {
            setIcon(ecd.getImageIcon());
            setText("");
        } else {
            setIcon(null);
            setText("<html><div align=\"center\"><b>No thumbnail,<br/>create using<br/>\"Configure\"</b></div></html>");
        }
        setToolTipText(index+1 + ": " + ecd.getName());
        if (isSelected) {
            setBackground(selectedColor);
        } else {
            setBackground(backgroundColor);
        }
        return this;
    }
}
