/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
package magiclantern;

import java.util.*;
import java.io.*;

/**
 *
 * @author lutusp
 */
final public class ShowList {

    MagicLantern parent;
    int currentSlide;
    int itop;
    Vector<String> nameList;

    public ShowList(String list[], MagicLantern p) {
        parent = p;
        currentSlide = 0;
        nameList = new Vector<String>(Arrays.asList(list));
        itop = nameList.size();
    }

    public int top() {
        return itop;
    }

    public void setIndex(int n) {
        n = CommonCode.max(0, n);
        n = CommonCode.min(n, itop - 1);
        currentSlide = n;
    }

    public int getIndex() {
        return currentSlide;
    }

    public String getName(int n) {
        if (!parent.programValues.autoShow && (currentSlide <= 0 && n < 0) || (currentSlide == itop - 1 && n > 0)) {
            CommonCode.beep();
        } else {
            currentSlide += n;
            currentSlide = CommonCode.max(0, currentSlide);
            currentSlide = CommonCode.min(itop - 1, currentSlide);
            parent.lastAutoSlideFlag = (currentSlide == itop - 1);
        }
        String path = (currentSlide < 0) ? "" : nameList.get(currentSlide);
        if (!parent.fullFrameMode) {
            File f = new File(path);
            String name = f.getName();
            parent.setStatus(currentSlide + 1 + "/" + itop + ": " + name, false, 0);
        }
        return path;
    }
}
