/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef INTERFACEDATAMANAGER_H
#define INTERFACEDATAMANAGER_H

#include <iostream>
#include <string>
#include <map>
#include <fstream>
#include <dirent.h>
#include <vector>
#include <algorithm>
#include <cctype>
#include <functional>

using namespace std;

typedef map<string,string> MSS;
typedef map<string,MSS> MMSS;

/**
@author Paul Lutus
*/
class InterfaceDataManager {
public:
    InterfaceDataManager();

    ~InterfaceDataManager();
    
    void dumpEverything(string path, string match);
    MSS readFile(string fn);
    int readDirectory(string path,string match);
    vector <string> getInterfaceList();
    string getInterfaceName(int i);
    string getDeviceName(int i);
    vector <string> split(string s,string delim);
    vector <string> splitOnWhitespace(string s);
    string trimWhitespace(string s);
    void toLowerCase(string&);
    unsigned char my_tolower(unsigned char c);
    
    protected:
    
    MMSS *dataTree;
    vector <string> *interfaceList;

};

#endif
