/*
 * Decompiled with CFR 0.152.
 */
package plcalc;

import java.awt.event.KeyEvent;
import java.util.Stack;
import javax.swing.JTextField;
import plcalc.PLCalcMainPanel;

public class Calculator {
    PLCalcMainPanel parent;
    JTextField[] textStack;
    Stack<Double> numStack;
    Stack<String> prevStack;
    Stack<String> nextStack;
    String[] entryModes = new String[]{"dd.dddd", "hh mm ss", "hh mm.mmmm", "ff ii ii/ii"};
    String error = "";
    static double degToRad = Math.PI / 180;
    static double radToDeg = 57.29577951308232;

    public Calculator(PLCalcMainPanel pLCalcMainPanel) {
        this.parent = pLCalcMainPanel;
        this.textStack = new JTextField[]{this.parent.XTextField, this.parent.YTextField, this.parent.ZTextField, this.parent.TTextField};
        this.numStack = new Stack();
        this.prevStack = new Stack();
        this.nextStack = new Stack();
        this.error = "OK";
    }

    public void showStackDisp() {
        if (this.numStack != null) {
            int n;
            String string = this.parent.getCurrentFormat();
            for (n = 0; n < this.numStack.size() && n < this.textStack.length; ++n) {
                double d = (Double)this.numStack.elementAt(n);
                String string2 = this.parent.specialFormat(string, d);
                string2 = this.processSpecialDisplayModes(string2, d);
                this.textStack[n].setText(string2);
            }
            while (n < this.textStack.length) {
                this.textStack[n].setText("");
                ++n;
            }
        }
        this.parent.setStatus(this.error, !this.error.equals("OK"));
        this.parent.EntryTextField.requestFocus();
    }

    String processSpecialDisplayModes(String string, double d) {
        String string2 = "";
        int n = this.parent.InputModeComboBox.getSelectedIndex();
        String string3 = d < 0.0 ? "-" : "";
        d = Math.abs(d);
        switch (n) {
            case 0: {
                return string;
            }
            case 1: {
                int n2 = (int)(d += 1.38E-4);
                d = (d - (double)n2) * 60.0;
                int n3 = (int)d;
                d = (d - (double)n3) * 60.0;
                int n4 = (int)d;
                string2 = String.format(this.parent.locale, "%dh %dm %ds", n2, n3, n4);
                break;
            }
            case 2: {
                int n5 = (int)d;
                double d2 = (d - (double)n5) * 60.0;
                string2 = String.format(this.parent.locale, "%dh %.6fm", n5, d2);
                break;
            }
            case 3: {
                int n6 = 32;
                double d3 = 1.0 / (double)(n6 * 24);
                int n7 = (int)(d += d3);
                d = (d - (double)n7) * 12.0;
                int n8 = (int)d;
                d = (d - (double)n8) * (double)n6;
                int n9 = (int)d;
                int n10 = this.comp_gcd(n9, n6);
                n6 /= n10;
                string2 = String.format(this.parent.locale, "%d ft.", n7);
                if (n8 == 0 && (n9 /= n10) == 0) break;
                if (n8 != 0) {
                    string2 = string2 + String.format(this.parent.locale, " %d", n8);
                }
                if (n9 != 0) {
                    string2 = string2 + String.format(this.parent.locale, " %d/%d", n9, n6);
                }
                string2 = string2 + " in.";
            }
        }
        return string + " (" + string3 + string2 + ")";
    }

    int comp_gcd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        return this.comp_gcd(n2, n % n2);
    }

    void clearStack(boolean bl) {
        this.error = "OK";
        this.numStack = new Stack();
        if (bl) {
            this.showStackDisp();
        }
    }

    void pushStack(double d) {
        this.numStack.add(0, d);
    }

    double popStack() {
        if (this.numStack.size() > 0) {
            return (Double)this.numStack.remove(0);
        }
        this.error = "Not enough entries.";
        return 0.0;
    }

    void processKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            if (this.prevStack.size() > 0) {
                String string = this.parent.EntryTextField.getText();
                if (string.length() > 0) {
                    this.nextStack.push(string);
                }
                String string2 = this.prevStack.pop();
                this.parent.EntryTextField.setText(string2);
            } else {
                this.parent.setStatus("No entries.", true);
            }
        } else if (n == 40) {
            if (this.nextStack.size() > 0) {
                String string = this.parent.EntryTextField.getText();
                if (string.length() > 0) {
                    this.prevStack.push(string);
                }
                String string3 = this.nextStack.pop();
                this.parent.EntryTextField.setText(string3);
            } else {
                this.parent.setStatus("No entries.", true);
            }
        }
    }

    void enterAction() {
        this.error = "OK";
        if (this.parent.activeTab == 0) {
            if (this.parent.EntryTextField.getText().length() > 0) {
                this.actOnEntry();
            } else if (this.numStack.size() > 0) {
                double d = (Double)this.numStack.get(0);
                this.pushStack(d);
            } else {
                this.parent.setStatus("No Entry.", true);
            }
            this.showStackDisp();
        }
    }

    void enterAction(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.enterAction();
        }
    }

    void actOnEntry() {
        this.error = "OK";
        String string = this.parent.EntryTextField.getText();
        this.prevStack.push(string);
        String[] stringArray = string.split("\\s+");
        int n = this.parent.InputModeComboBox.getSelectedIndex();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.testNumeric(stringArray[i])) {
                double d = this.parent.getDouble(stringArray[i]);
                if (n == 0) {
                    this.pushStack(d);
                    continue;
                }
                double d2 = d < 0.0 ? -1.0 : 1.0;
                d = Math.abs(d);
                if (i < stringArray.length - 1 && this.testNumeric(stringArray[i + 1])) {
                    double d3;
                    double d4 = this.parent.getDouble(stringArray[++i]);
                    if (n != 3) {
                        d += d4 / 60.0;
                        if (n == 1 && i < stringArray.length - 1 && this.testNumeric(stringArray[i + 1])) {
                            d3 = this.parent.getDouble(stringArray[++i]);
                            d += d3 / 3600.0;
                        }
                    } else {
                        String[] stringArray2;
                        d += d4 / 12.0;
                        if (i < stringArray.length - 1 && (stringArray2 = stringArray[i + 1].split("/")).length == 2 && this.testNumeric(stringArray2[0]) && this.testNumeric(stringArray2[1])) {
                            d3 = this.parent.getDouble(stringArray2[0]);
                            double d5 = this.parent.getDouble(stringArray2[1]);
                            d += d3 / d5 / 12.0;
                            ++i;
                        }
                    }
                }
                this.pushStack(d2 * d);
                continue;
            }
            this.processCommand2(stringArray[i]);
        }
        this.parent.EntryTextField.setText("");
    }

    boolean testNumeric(String string) {
        boolean bl = false;
        try {
            this.parent.getDoubleThrowsException(string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    boolean testFor(int n) {
        boolean bl;
        boolean bl2 = bl = this.numStack.size() >= n;
        if (!bl) {
            this.error = "Not enough entries.";
        }
        return bl;
    }

    void processCommand2(String string) {
        if (string.length() == 0) {
            this.showStackDisp();
            return;
        }
        if ("chs".equals(string = string.toLowerCase())) {
            if (this.testFor(1)) {
                this.pushStack(-this.popStack());
            }
        } else if ("r-d".equals(string)) {
            if (this.testFor(1)) {
                this.pushStack(this.popStack() * radToDeg);
            }
        } else if ("ent".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                this.pushStack(d);
                this.pushStack(d);
            }
        } else if ("clr".equals(string)) {
            this.clearStack(true);
        } else if ("yrx".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                double d2 = this.popStack();
                this.pushStack(Math.pow(d2, 1.0 / d));
            }
        } else if ("sq".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                this.pushStack(d * d);
            }
        } else if ("d-r".equals(string)) {
            if (this.testFor(1)) {
                this.pushStack(this.popStack() * degToRad);
            }
        } else if ("pi".equals(string)) {
            this.pushStack(Math.PI);
        } else if ("e".equals(string)) {
            this.pushStack(Math.exp(1.0));
        } else if ("drop".equals(string)) {
            if (this.testFor(1)) {
                this.popStack();
            }
        } else if ("1/x".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                if (d == 0.0) {
                    this.error = "Division by zero.";
                    this.pushStack(d);
                } else {
                    this.pushStack(1.0 / d);
                }
            }
        } else if ("swap".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                double d3 = this.popStack();
                this.pushStack(d);
                this.pushStack(d3);
            }
        } else if ("+".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                this.pushStack(this.popStack() + d);
            }
        } else if ("-".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                this.pushStack(this.popStack() - d);
            }
        } else if ("*".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                this.pushStack(this.popStack() * d);
            }
        } else if ("/".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                if (d == 0.0) {
                    this.error = "Division by zero.";
                    this.pushStack(d);
                } else {
                    this.pushStack(this.popStack() / d);
                }
            }
        } else if ("^".equals(string)) {
            if (this.testFor(2)) {
                double d = this.popStack();
                double d4 = this.popStack();
                this.pushStack(Math.pow(d4, d));
            }
        } else if ("sin".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack() * degToRad;
                this.pushStack(Math.sin(d));
            }
        } else if ("cos".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack() * degToRad;
                this.pushStack(Math.cos(d));
            }
        } else if ("tan".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack() * degToRad;
                this.pushStack(Math.tan(d));
            }
        } else if ("asin".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                this.pushStack(Math.asin(d) * radToDeg);
            }
        } else if ("acos".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                this.pushStack(Math.acos(d) * radToDeg);
            }
        } else if ("atan".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                this.pushStack(Math.atan(d) * radToDeg);
            }
        } else if ("sqrt".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                if (d < 0.0) {
                    this.error = "Domain error.";
                    this.pushStack(d);
                } else {
                    this.pushStack(Math.sqrt(d));
                }
            }
        } else if ("lnx".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                if (d < 0.0) {
                    this.error = "Domain error.";
                    this.pushStack(d);
                } else {
                    this.pushStack(Math.log(d));
                }
            }
        } else if ("ex".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                this.pushStack(Math.exp(d));
            }
        } else if ("logx".equals(string)) {
            if (this.testFor(1)) {
                double d = this.popStack();
                if (d < 0.0) {
                    this.error = "Domain error.";
                    this.pushStack(d);
                } else {
                    this.pushStack(Math.log(d) / Math.log(10.0));
                }
            }
        } else if ("tenx".equals(string) && this.testFor(1)) {
            double d = this.popStack();
            this.pushStack(Math.pow(10.0, d));
        }
        this.showStackDisp();
    }

    void processCommand(String string) {
        this.error = "OK";
        if (this.parent.activeTab == 0) {
            this.actOnEntry();
            this.processCommand2(string);
        }
    }
}

