/*
 * Decompiled with CFR 0.152.
 */
package plcalc;

import java.awt.Color;
import javax.swing.JTextField;
import plcalc.PLCalcMainPanel;

public class Finance {
    PLCalcMainPanel parent;
    double payment_type;

    public Finance(PLCalcMainPanel pLCalcMainPanel) {
        this.parent = pLCalcMainPanel;
        this.process("");
    }

    public void process(String string) {
        this.payment_type = this.parent.PayEndButton.isSelected() ? 0.0 : 1.0;
        double d = this.parent.getNum(this.parent.PVField);
        double d2 = this.parent.getNum(this.parent.FVField);
        double d3 = this.parent.getNum(this.parent.NPField);
        double d4 = this.parent.getNum(this.parent.PMTField);
        double d5 = this.parent.getNum(this.parent.IRField);
        if ("PV".equals(string)) {
            d = this.comp_pv(d3, d5, d4, d2);
        } else if ("FV".equals(string)) {
            d2 = this.comp_fv(d3, d5, d4, d);
        } else if ("NP".equals(string)) {
            d3 = this.comp_per(d5, d4, d2, d);
        } else if ("PMT".equals(string)) {
            d4 = this.comp_pmt(d3, d5, d2, d);
        } else if ("IR".equals(string)) {
            d5 = this.comp_int(d3, d4, d2, d);
        }
        this.formatResult(this.parent.PVField, d, false);
        this.formatResult(this.parent.FVField, d2, false);
        this.formatResult(this.parent.NPField, d3, false);
        this.formatResult(this.parent.PMTField, d4, false);
        this.formatResult(this.parent.IRField, d5, true);
    }

    void formatResult(JTextField jTextField, double d, boolean bl) {
        String string = bl ? "%.6f" : "%.2f";
        String string2 = String.format(string, d);
        jTextField.setText(string2);
        jTextField.setForeground(d < 0.0 ? Color.red : Color.black);
    }

    double comp_pv(double d, double d2, double d3, double d4) {
        double d5;
        if ((d2 /= 100.0) == 0.0) {
            d5 = -d4 - d * d3;
        } else {
            double d6 = Math.pow(1.0 + d2, -d);
            double d7 = Math.pow(1.0 + d2, d);
            d5 = -d6 * (d4 + (-1.0 + d7) * d3 * (1.0 + d2 * this.payment_type) / d2);
        }
        return d5;
    }

    double comp_fv(double d, double d2, double d3, double d4) {
        double d5;
        if ((d2 /= 100.0) == 0.0) {
            d5 = -d * d3 - d4;
        } else {
            double d6 = Math.pow(1.0 + d2, d);
            d5 = -d6 * d4 - (-1.0 + d6) * d3 * (1.0 + d2 * this.payment_type) / d2;
        }
        return d5;
    }

    double comp_pmt(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        if ((d2 /= 100.0) == 0.0) {
            if (d != 0.0) {
                d5 = -(d3 + d4) / d;
            }
        } else {
            double d6 = Math.pow(1.0 + d2, d);
            d5 = -(d2 * (d3 + d6 * d4)) / ((-1.0 + d6) * (1.0 + d2 * this.payment_type));
        }
        return d5;
    }

    double comp_per(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        if ((d /= 100.0) == 0.0) {
            if (d2 != 0.0) {
                d5 = -(d3 + d4) / d2;
            }
        } else {
            d5 = Math.log((-d3 * d + d2 + d * d2 * this.payment_type) / (d2 + d * d4 + d * d2 * this.payment_type)) / Math.log(1.0 + d);
        }
        return d5;
    }

    double comp_int(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = 1.0E300;
        int n = 150;
        if (d3 == 0.0 && d4 == 0.0) {
            return d7;
        }
        int n2 = 0;
        int n3 = 0;
        double d8 = 1.0;
        double d9 = 3.0;
        double d10 = this.comp_fv(d, d8, d2, d4);
        double d11 = Math.abs(d10 - d3);
        do {
            d6 = d10;
            d5 = d11;
            if ((d8 += d9) != 0.0) {
                d10 = this.comp_fv(d, d8, d2, d4);
                d11 = Math.abs(d10 - d3);
            }
            ++n3;
            if (Math.abs(d10 - d6) > 1.0E-4) {
                n3 = 0;
            }
            if (!(d11 > d5)) continue;
            d9 *= -0.5;
        } while (n2++ < n && n3 < 3);
        if (n2 < n) {
            return d8;
        }
        n2 = 0;
        n3 = 0;
        d8 = 1.0;
        d9 = 3.0;
        d10 = this.comp_pv(d, d8, d2, d3);
        d11 = Math.abs(d10 - d4);
        do {
            d6 = d10;
            d5 = d11;
            if ((d8 += d9) != 0.0) {
                d10 = this.comp_pv(d, d8, d2, d3);
                d11 = Math.abs(d10 - d4);
            }
            ++n3;
            if (Math.abs(d10 - d6) > 1.0E-4) {
                n3 = 0;
            }
            if (!(d11 > d5)) continue;
            d9 *= -0.5;
        } while (n2++ < n && n3 < 3);
        if (n2 < n) {
            return d8;
        }
        return d7;
    }
}

