/*
 * Decompiled with CFR 0.152.
 */
package plcalc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plcalc.BaseConv;
import plcalc.Calculator;
import plcalc.Finance;
import plcalc.Statistics;
import plcalc.Units;

public class PLCalcMainPanel
extends JPanel {
    public String programName = "PLCalc";
    public String programVersion = "2.4";
    int activeTab;
    Calculator calc;
    Finance finance;
    Statistics stat;
    Units units;
    BaseConv basec;
    NumberFormat numberFormat;
    Locale locale = Locale.getDefault();
    char radixChar;
    private JButton ACosButton;
    private JButton ASinButton;
    private JButton ATanButton;
    private JButton AddButton;
    protected JRadioButton AllRadioButton;
    private JPanel BasePanel;
    private JTextArea BaseTextArea;
    protected JTextField BinaryField;
    private JButton ChsButton;
    private JButton ClearButton;
    private JButton CosButton;
    protected JComboBox DecPlacesCombo;
    protected JTextField DecimalField;
    private JButton DivButton;
    private JButton EnterButton;
    protected JTextField EntryTextField;
    private JButton FVButton;
    protected JTextField FVField;
    private JTextArea FinanceTextArea;
    protected JRadioButton FixRadioButton;
    private ButtonGroup FixSciButtonGroup;
    private JTextArea HelpTextArea;
    protected JTextField HexField;
    private JButton IRButton;
    protected JTextField IRField;
    protected JComboBox InputModeComboBox;
    private JButton InvXButton;
    private JButton LnXButton;
    protected JTextField MeanField;
    private JButton MultButton;
    private JButton NPButton;
    protected JTextField NPField;
    private JPanel NumFormatPane;
    protected JTextField OctalField;
    private JButton PMTButton;
    protected JTextField PMTField;
    private JButton PVButton;
    protected JTextField PVField;
    protected JRadioButton PayBeginButton;
    protected JRadioButton PayEndButton;
    protected JTextField PopField;
    protected JTextField SDField;
    protected JRadioButton SciRadioButton;
    private JButton SinButton;
    private JButton SqrtButton;
    private JPanel StackDisplayPane;
    private JTextArea StatisticsTextArea;
    private JLabel StatusLabel;
    private JButton SubButton;
    protected JTextField TTextField;
    private JTabbedPane TabbedPane;
    private JButton TanButton;
    protected JTextField XTextField;
    protected JTextField YTextField;
    protected JTextField ZTextField;
    protected JTextField aField;
    protected JTextField bField;
    private JPanel calcPanel;
    private JButton drButton;
    private JButton dropButton;
    private JButton eButton;
    private JButton etoxButton;
    private JPanel financePanel;
    private JPanel helpPanel;
    protected JLabel inputUnitLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane5;
    private JButton logXButton;
    protected JScrollPane outputListScrollPane;
    protected JList outputUnitsList;
    private ButtonGroup payButtonGroup;
    private JPanel paymentTypePanel;
    private JButton piButton;
    private JButton rdButton;
    private JButton resultButton;
    protected JTextField resultField;
    private JPanel statPanel;
    private JButton swapButton1;
    private JButton tenXButton;
    protected JPanel unitsButtonPanel1;
    protected JPanel unitsButtonPanel2;
    protected JPanel unitsIOPanel;
    protected JTextField unitsInputField;
    private JPanel unitsInputPanel;
    private JPanel unitsOutputPanel;
    protected JPanel unitsPanel;
    private JButton x2Button;
    private JButton yrx;
    private JButton ytoXButton;

    public PLCalcMainPanel() {
        this.initComponents();
        this.radixChar = new DecimalFormatSymbols(this.locale).getDecimalSeparator();
        this.numberFormat = NumberFormat.getInstance();
        this.calc = new Calculator(this);
        this.finance = new Finance(this);
        this.basec = new BaseConv(this);
        this.setupValues();
        this.stat = new Statistics(this);
        this.units = new Units(this);
    }

    void setupValues() {
        int n;
        this.calc.clearStack(false);
        this.DecPlacesCombo.removeAllItems();
        for (n = 0; n <= 16; ++n) {
            this.DecPlacesCombo.addItem(n);
        }
        this.DecPlacesCombo.setSelectedItem(4);
        this.InputModeComboBox.removeAllItems();
        for (n = 0; n < this.calc.entryModes.length; ++n) {
            this.InputModeComboBox.addItem(this.calc.entryModes[n]);
        }
        this.loadHelpFile(this.FinanceTextArea, "finance_help.txt");
        this.loadHelpFile(this.StatisticsTextArea, "statistics_help.txt");
        this.loadHelpFile(this.BaseTextArea, "baseconv_help.txt");
        this.loadHelpFile(this.HelpTextArea, "help_text.txt");
        this.setPaneTab(0);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PLCalcMainPanel.this.EntryTextField.requestFocus();
            }
        });
    }

    void loadHelpFile(JTextArea jTextArea, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = stringBuffer.toString();
        string3 = string3.replaceAll("<program>", this.programName);
        string3 = string3.replaceAll("<version>", this.programVersion);
        jTextArea.setText(string3);
        jTextArea.setSelectionStart(0);
        jTextArea.setSelectionEnd(0);
    }

    void setPaneTab(int n) {
        if (n == -1) {
            n = this.TabbedPane.getSelectedIndex();
        } else {
            this.TabbedPane.setSelectedIndex(n);
        }
        this.activeTab = n;
        this.InputModeComboBox.setVisible(n == 0);
        if (n == 0 && this.calc != null) {
            this.calc.showStackDisp();
        }
        if (n == 3) {
            this.DecimalField.requestFocus();
        }
    }

    void setStatus(String string, boolean bl) {
        this.StatusLabel.setText(string);
        if (bl) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getDecPlaces() {
        Integer n = (Integer)this.DecPlacesCombo.getSelectedItem();
        if (n == null) {
            n = 0;
        }
        return n;
    }

    public String getCurrentFormat() {
        int n = this.getDecPlaces();
        String string = "%." + n;
        if (this.AllRadioButton.isSelected()) {
            string = string + "g";
        } else if (this.FixRadioButton.isSelected()) {
            string = string + "f";
        } else if (this.SciRadioButton.isSelected()) {
            string = string + "e";
        }
        return string;
    }

    public boolean isAllFormat() {
        return this.AllRadioButton.isSelected();
    }

    public String specialFormat(String string, double d) {
        String string2 = String.format(this.locale, string, d);
        string2 = string2.replaceAll("\\.", "" + this.radixChar);
        return string2;
    }

    double getDoubleThrowsException(String string) throws Exception {
        double d = 0.0;
        string = string.toLowerCase();
        String[] stringArray = string.split("e");
        d = this.numberFormat.parse(stringArray[0]).doubleValue();
        if (stringArray.length > 1) {
            String string2 = stringArray[1].replaceFirst("\\+", "");
            double d2 = this.numberFormat.parse(string2).doubleValue();
            d *= Math.pow(10.0, d2);
        }
        return d;
    }

    double getDouble(String string) {
        double d = 0.0;
        try {
            d = this.getDoubleThrowsException(string);
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".getDouble: Error: " + exception);
        }
        return d;
    }

    public double getNum(JTextField jTextField) {
        double d = 0.0;
        try {
            d = this.getDouble(jTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    void displayOptionsChanged() {
        if (this.calc != null) {
            this.calc.showStackDisp();
        }
        if (this.units != null) {
            this.units.acceptConversion();
        }
    }

    void testUnitsAcceptConversion() {
        if (this.units != null) {
            this.units.acceptConversion();
        }
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void initComponents() {
        this.FixSciButtonGroup = new ButtonGroup();
        this.payButtonGroup = new ButtonGroup();
        this.NumFormatPane = new JPanel();
        this.FixRadioButton = new JRadioButton();
        this.SciRadioButton = new JRadioButton();
        this.DecPlacesCombo = new JComboBox();
        this.AllRadioButton = new JRadioButton();
        this.InputModeComboBox = new JComboBox();
        this.TabbedPane = new JTabbedPane();
        this.calcPanel = new JPanel();
        this.StackDisplayPane = new JPanel();
        this.ZTextField = new JTextField();
        this.YTextField = new JTextField();
        this.XTextField = new JTextField();
        this.EntryTextField = new JTextField();
        this.TTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.SinButton = new JButton();
        this.CosButton = new JButton();
        this.TanButton = new JButton();
        this.ytoXButton = new JButton();
        this.ASinButton = new JButton();
        this.ACosButton = new JButton();
        this.ATanButton = new JButton();
        this.SqrtButton = new JButton();
        this.LnXButton = new JButton();
        this.etoxButton = new JButton();
        this.logXButton = new JButton();
        this.tenXButton = new JButton();
        this.ChsButton = new JButton();
        this.dropButton = new JButton();
        this.InvXButton = new JButton();
        this.swapButton1 = new JButton();
        this.ClearButton = new JButton();
        this.drButton = new JButton();
        this.rdButton = new JButton();
        this.piButton = new JButton();
        this.eButton = new JButton();
        this.x2Button = new JButton();
        this.yrx = new JButton();
        this.AddButton = new JButton();
        this.SubButton = new JButton();
        this.MultButton = new JButton();
        this.DivButton = new JButton();
        this.EnterButton = new JButton();
        this.financePanel = new JPanel();
        this.IRButton = new JButton();
        this.FVButton = new JButton();
        this.PVButton = new JButton();
        this.NPButton = new JButton();
        this.PMTButton = new JButton();
        this.FVField = new JTextField();
        this.IRField = new JTextField();
        this.PVField = new JTextField();
        this.NPField = new JTextField();
        this.PMTField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.FinanceTextArea = new JTextArea();
        this.paymentTypePanel = new JPanel();
        this.PayBeginButton = new JRadioButton();
        this.PayEndButton = new JRadioButton();
        this.statPanel = new JPanel();
        this.MeanField = new JTextField();
        this.SDField = new JTextField();
        this.PopField = new JTextField();
        this.aField = new JTextField();
        this.bField = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.resultField = new JTextField();
        this.resultButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.StatisticsTextArea = new JTextArea();
        this.unitsPanel = new JPanel();
        this.unitsButtonPanel1 = new JPanel();
        this.unitsButtonPanel2 = new JPanel();
        this.unitsIOPanel = new JPanel();
        this.unitsInputPanel = new JPanel();
        this.jLabel15 = new JLabel();
        this.unitsInputField = new JTextField();
        this.inputUnitLabel = new JLabel();
        this.unitsOutputPanel = new JPanel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.outputListScrollPane = new JScrollPane();
        this.outputUnitsList = new JList();
        this.BasePanel = new JPanel();
        this.BinaryField = new JTextField();
        this.OctalField = new JTextField();
        this.DecimalField = new JTextField();
        this.HexField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.BaseTextArea = new JTextArea();
        this.helpPanel = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.HelpTextArea = new JTextArea();
        this.StatusLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.NumFormatPane.setLayout(new GridBagLayout());
        this.FixSciButtonGroup.add(this.FixRadioButton);
        this.FixRadioButton.setText("Fixed");
        this.FixRadioButton.setToolTipText("Fixed-point number formatting");
        this.FixRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.FixRadioButtonMouseClicked(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.NumFormatPane.add((Component)this.FixRadioButton, gridBagConstraints);
        this.FixSciButtonGroup.add(this.SciRadioButton);
        this.SciRadioButton.setText("Scientific");
        this.SciRadioButton.setToolTipText("Scientific number formatting");
        this.SciRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.SciRadioButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.NumFormatPane.add((Component)this.SciRadioButton, gridBagConstraints);
        this.DecPlacesCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.DecPlacesCombo.setToolTipText("Displayed decimal places");
        this.DecPlacesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PLCalcMainPanel.this.DecPlacesComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.NumFormatPane.add((Component)this.DecPlacesCombo, gridBagConstraints);
        this.FixSciButtonGroup.add(this.AllRadioButton);
        this.AllRadioButton.setSelected(true);
        this.AllRadioButton.setText("All");
        this.AllRadioButton.setToolTipText("General number formatting");
        this.AllRadioButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.AllRadioButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.NumFormatPane.add((Component)this.AllRadioButton, gridBagConstraints);
        this.InputModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.InputModeComboBox.setToolTipText("Entry/display mode");
        this.InputModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PLCalcMainPanel.this.InputModeComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.NumFormatPane.add((Component)this.InputModeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.NumFormatPane, gridBagConstraints);
        this.TabbedPane.setTabPlacement(3);
        this.TabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PLCalcMainPanel.this.TabbedPaneStateChanged(changeEvent);
            }
        });
        this.calcPanel.setLayout(new GridBagLayout());
        this.StackDisplayPane.setLayout(new GridBagLayout());
        this.ZTextField.setFont(new Font("Courier", 0, 14));
        this.ZTextField.setHorizontalAlignment(4);
        this.ZTextField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.StackDisplayPane.add((Component)this.ZTextField, gridBagConstraints);
        this.YTextField.setFont(new Font("Courier", 0, 14));
        this.YTextField.setHorizontalAlignment(4);
        this.YTextField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.StackDisplayPane.add((Component)this.YTextField, gridBagConstraints);
        this.XTextField.setFont(new Font("Courier", 0, 14));
        this.XTextField.setHorizontalAlignment(4);
        this.XTextField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.StackDisplayPane.add((Component)this.XTextField, gridBagConstraints);
        this.EntryTextField.setFont(new Font("Courier", 0, 14));
        this.EntryTextField.setHorizontalAlignment(4);
        this.EntryTextField.setFocusCycleRoot(true);
        this.EntryTextField.setMargin(new Insets(0, 2, 0, 2));
        this.EntryTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                PLCalcMainPanel.this.EntryTextFieldKeyPressed(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                PLCalcMainPanel.this.EntryTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.StackDisplayPane.add((Component)this.EntryTextField, gridBagConstraints);
        this.TTextField.setFont(new Font("Courier", 0, 14));
        this.TTextField.setHorizontalAlignment(4);
        this.TTextField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.StackDisplayPane.add((Component)this.TTextField, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.StackDisplayPane.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Z");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.StackDisplayPane.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("T");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.StackDisplayPane.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.StackDisplayPane.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Entry");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.StackDisplayPane.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.StackDisplayPane, gridBagConstraints);
        this.SinButton.setText("Sin");
        this.SinButton.setToolTipText("Shortcut: \"sin\"");
        this.SinButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.SinButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calcPanel.add((Component)this.SinButton, gridBagConstraints);
        this.CosButton.setText("Cos");
        this.CosButton.setToolTipText("Shortcut: \"cos\"");
        this.CosButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.CosButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.CosButton, gridBagConstraints);
        this.TanButton.setText("Tan");
        this.TanButton.setToolTipText("Shortcut: \"tan\"");
        this.TanButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.TanButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.TanButton, gridBagConstraints);
        this.ytoXButton.setText("<html>y<sup>x</sup></html>");
        this.ytoXButton.setToolTipText("Shortcut: \"^\"");
        this.ytoXButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.ytoXButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.ytoXButton, gridBagConstraints);
        this.ASinButton.setText("<html>Sin<sup>-1</sup></html>");
        this.ASinButton.setToolTipText("Shortcut: \"asin\"");
        this.ASinButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.ASinButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calcPanel.add((Component)this.ASinButton, gridBagConstraints);
        this.ACosButton.setText("<html>Cos<sup>-1</sup></html>");
        this.ACosButton.setToolTipText("Shortcut: \"acos\"");
        this.ACosButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.ACosButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.ACosButton, gridBagConstraints);
        this.ATanButton.setText("<html>Tan<sup>-1</sup></html>");
        this.ATanButton.setToolTipText("Shortcut: \"atan\"");
        this.ATanButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.ATanButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.ATanButton, gridBagConstraints);
        this.SqrtButton.setText("<html>&radic;x</html>");
        this.SqrtButton.setToolTipText("Shortcut: \"sqrt\"");
        this.SqrtButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.SqrtButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        this.calcPanel.add((Component)this.SqrtButton, gridBagConstraints);
        this.LnXButton.setText("ln(x)");
        this.LnXButton.setToolTipText("Shortcut: \"lnx\"");
        this.LnXButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.LnXButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calcPanel.add((Component)this.LnXButton, gridBagConstraints);
        this.etoxButton.setText("<html>e<sup>x</sup></html>");
        this.etoxButton.setToolTipText("Shortcut: \"ex\"");
        this.etoxButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.etoxButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.etoxButton, gridBagConstraints);
        this.logXButton.setText("log(x)");
        this.logXButton.setToolTipText("Shortcut: \"logx\"");
        this.logXButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.logXButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.logXButton, gridBagConstraints);
        this.tenXButton.setText("<html>10<sup>x</sup></html>");
        this.tenXButton.setToolTipText("Shortcut: \"10x\"");
        this.tenXButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.tenXButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        this.calcPanel.add((Component)this.tenXButton, gridBagConstraints);
        this.ChsButton.setText("+/-");
        this.ChsButton.setToolTipText("Shortcut: \"chs\"");
        this.ChsButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.ChsButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.ChsButton, gridBagConstraints);
        this.dropButton.setText("Drop");
        this.dropButton.setToolTipText("Shortcut: \"drop\"");
        this.dropButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.dropButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.dropButton, gridBagConstraints);
        this.InvXButton.setText("1/x");
        this.InvXButton.setToolTipText("Shortcut: \"1/x\"");
        this.InvXButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.InvXButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.InvXButton, gridBagConstraints);
        this.swapButton1.setText("x<->y");
        this.swapButton1.setToolTipText("Shortcut: \"swap\"");
        this.swapButton1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.swapButton1MouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.calcPanel.add((Component)this.swapButton1, gridBagConstraints);
        this.ClearButton.setText("Clear");
        this.ClearButton.setToolTipText("Shortcut: \"clr\"");
        this.ClearButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.ClearButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.ClearButton, gridBagConstraints);
        this.drButton.setText("D->R");
        this.drButton.setToolTipText("Shortcut: \"d-r\"");
        this.drButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.drButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.drButton, gridBagConstraints);
        this.rdButton.setText("R->D");
        this.rdButton.setToolTipText("Shortcut: \"r-d\"");
        this.rdButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.rdButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calcPanel.add((Component)this.rdButton, gridBagConstraints);
        this.piButton.setText("<html>&pi;</html>");
        this.piButton.setToolTipText("Shortcut: \"pi\"");
        this.piButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.piButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.piButton, gridBagConstraints);
        this.eButton.setText("e");
        this.eButton.setToolTipText("Shortcut: \"e\"");
        this.eButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.eButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.eButton, gridBagConstraints);
        this.x2Button.setText("<html>x<sup>2</sup></html>");
        this.x2Button.setToolTipText("Shortcut: \"sq\"");
        this.x2Button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.x2ButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.x2Button, gridBagConstraints);
        this.yrx.setText("<html><sup>x</sup>&radic;y</html>");
        this.yrx.setToolTipText("Shortcut: \"yrx\"");
        this.yrx.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.yrxMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        this.calcPanel.add((Component)this.yrx, gridBagConstraints);
        this.AddButton.setText("+");
        this.AddButton.setToolTipText("Shortcut: \"+\"");
        this.AddButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.AddButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calcPanel.add((Component)this.AddButton, gridBagConstraints);
        this.SubButton.setText("-");
        this.SubButton.setToolTipText("Shortcut: \"-\"");
        this.SubButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.SubButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.SubButton, gridBagConstraints);
        this.MultButton.setText("*");
        this.MultButton.setToolTipText("Shortcut: \"*\"");
        this.MultButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.MultButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.MultButton, gridBagConstraints);
        this.DivButton.setText("/");
        this.DivButton.setToolTipText("Shortcut: \"/\"");
        this.DivButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.DivButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.calcPanel.add((Component)this.DivButton, gridBagConstraints);
        this.EnterButton.setText("Enter");
        this.EnterButton.setToolTipText("Shortcut: \"ent\"");
        this.EnterButton.setDefaultCapable(false);
        this.EnterButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.EnterButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.calcPanel.add((Component)this.EnterButton, gridBagConstraints);
        this.TabbedPane.addTab("Calculator", this.calcPanel);
        this.financePanel.setLayout(new GridBagLayout());
        this.IRButton.setText("IR");
        this.IRButton.setToolTipText("Interest Rate Per Period");
        this.IRButton.setDefaultCapable(false);
        this.IRButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.IRButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.financePanel.add((Component)this.IRButton, gridBagConstraints);
        this.FVButton.setText("FV");
        this.FVButton.setToolTipText("Future Value");
        this.FVButton.setDefaultCapable(false);
        this.FVButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.FVButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.financePanel.add((Component)this.FVButton, gridBagConstraints);
        this.PVButton.setText("PV");
        this.PVButton.setToolTipText("Present Value");
        this.PVButton.setDefaultCapable(false);
        this.PVButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.PVButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.financePanel.add((Component)this.PVButton, gridBagConstraints);
        this.NPButton.setText("NP");
        this.NPButton.setToolTipText("Number of Periods");
        this.NPButton.setDefaultCapable(false);
        this.NPButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.NPButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.financePanel.add((Component)this.NPButton, gridBagConstraints);
        this.PMTButton.setText("PMT");
        this.PMTButton.setToolTipText("Payment Amount");
        this.PMTButton.setDefaultCapable(false);
        this.PMTButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.PMTButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.financePanel.add((Component)this.PMTButton, gridBagConstraints);
        this.FVField.setFont(new Font("Courier", 0, 14));
        this.FVField.setHorizontalAlignment(4);
        this.FVField.setText("0");
        this.FVField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.financePanel.add((Component)this.FVField, gridBagConstraints);
        this.IRField.setFont(new Font("Courier", 0, 14));
        this.IRField.setHorizontalAlignment(4);
        this.IRField.setText("1");
        this.IRField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.financePanel.add((Component)this.IRField, gridBagConstraints);
        this.PVField.setFont(new Font("Courier", 0, 14));
        this.PVField.setHorizontalAlignment(4);
        this.PVField.setText("0");
        this.PVField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.financePanel.add((Component)this.PVField, gridBagConstraints);
        this.NPField.setFont(new Font("Courier", 0, 14));
        this.NPField.setHorizontalAlignment(4);
        this.NPField.setText("120");
        this.NPField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.financePanel.add((Component)this.NPField, gridBagConstraints);
        this.PMTField.setFont(new Font("Courier", 0, 14));
        this.PMTField.setHorizontalAlignment(4);
        this.PMTField.setText("-100");
        this.PMTField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.financePanel.add((Component)this.PMTField, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.FinanceTextArea.setColumns(20);
        this.FinanceTextArea.setEditable(false);
        this.FinanceTextArea.setFont(new Font("Courier", 0, 13));
        this.FinanceTextArea.setLineWrap(true);
        this.FinanceTextArea.setRows(5);
        this.FinanceTextArea.setWrapStyleWord(true);
        this.FinanceTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.jScrollPane1.setViewportView(this.FinanceTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.financePanel.add((Component)this.jPanel2, gridBagConstraints);
        this.payButtonGroup.add(this.PayBeginButton);
        this.PayBeginButton.setText("Payment at Beginning");
        this.paymentTypePanel.add(this.PayBeginButton);
        this.payButtonGroup.add(this.PayEndButton);
        this.PayEndButton.setSelected(true);
        this.PayEndButton.setText("Payment at End");
        this.paymentTypePanel.add(this.PayEndButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.financePanel.add((Component)this.paymentTypePanel, gridBagConstraints);
        this.TabbedPane.addTab("Finance", this.financePanel);
        this.statPanel.setLayout(new GridBagLayout());
        this.MeanField.setFont(new Font("Courier", 0, 14));
        this.MeanField.setHorizontalAlignment(4);
        this.MeanField.setText("100.0");
        this.MeanField.setToolTipText("Mean Value");
        this.MeanField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.MeanField, gridBagConstraints);
        this.SDField.setFont(new Font("Courier", 0, 14));
        this.SDField.setHorizontalAlignment(4);
        this.SDField.setText("15.0");
        this.SDField.setToolTipText("Standard Deviation");
        this.SDField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.SDField, gridBagConstraints);
        this.PopField.setFont(new Font("Courier", 0, 14));
        this.PopField.setHorizontalAlignment(4);
        this.PopField.setText("1.0");
        this.PopField.setToolTipText("Population Size");
        this.PopField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.PopField, gridBagConstraints);
        this.aField.setFont(new Font("Courier", 0, 14));
        this.aField.setHorizontalAlignment(4);
        this.aField.setText("85");
        this.aField.setToolTipText("Interval Start");
        this.aField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.aField, gridBagConstraints);
        this.bField.setFont(new Font("Courier", 0, 14));
        this.bField.setHorizontalAlignment(4);
        this.bField.setText("115");
        this.bField.setToolTipText("Interval End");
        this.bField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statPanel.add((Component)this.bField, gridBagConstraints);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("<html>&mu;</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("<html>&sigma;</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setText("p");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setHorizontalAlignment(0);
        this.jLabel13.setText("a");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText("b");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.resultField.setFont(new Font("Courier", 0, 14));
        this.resultField.setHorizontalAlignment(4);
        this.resultField.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statPanel.add((Component)this.resultField, gridBagConstraints);
        this.resultButton.setText("Result");
        this.resultButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.resultButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.resultButton, gridBagConstraints);
        this.StatisticsTextArea.setColumns(20);
        this.StatisticsTextArea.setEditable(false);
        this.StatisticsTextArea.setFont(new Font("Courier", 0, 13));
        this.StatisticsTextArea.setLineWrap(true);
        this.StatisticsTextArea.setRows(5);
        this.StatisticsTextArea.setWrapStyleWord(true);
        this.StatisticsTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.jScrollPane3.setViewportView(this.StatisticsTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.statPanel.add((Component)this.jScrollPane3, gridBagConstraints);
        this.TabbedPane.addTab("Statistics", this.statPanel);
        this.unitsPanel.setLayout(new GridBagLayout());
        this.unitsButtonPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.unitsPanel.add((Component)this.unitsButtonPanel1, gridBagConstraints);
        this.unitsButtonPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.unitsPanel.add((Component)this.unitsButtonPanel2, gridBagConstraints);
        this.unitsIOPanel.setLayout(new GridBagLayout());
        this.unitsInputPanel.setLayout(new GridBagLayout());
        this.jLabel15.setText("<html><b>Input Value:</b></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.unitsInputPanel.add((Component)this.jLabel15, gridBagConstraints);
        this.unitsInputField.setHorizontalAlignment(4);
        this.unitsInputField.setText("1");
        this.unitsInputField.setToolTipText("Press Enter to perform conversion");
        this.unitsInputField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                PLCalcMainPanel.this.unitsInputFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.unitsInputPanel.add((Component)this.unitsInputField, gridBagConstraints);
        this.inputUnitLabel.setText("Input Unit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.unitsInputPanel.add((Component)this.inputUnitLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.unitsIOPanel.add((Component)this.unitsInputPanel, gridBagConstraints);
        this.unitsOutputPanel.setLayout(new GridBagLayout());
        this.jLabel16.setText("<html><b>Output Unit</b></html>");
        this.jLabel16.setPreferredSize(new Dimension(90, 31));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.unitsOutputPanel.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("<html><b>Output Value</b></html>");
        this.jLabel17.setPreferredSize(new Dimension(103, 31));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.unitsOutputPanel.add((Component)this.jLabel17, gridBagConstraints);
        this.outputListScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PLCalcMainPanel.this.outputListScrollPaneComponentResized(componentEvent);
            }
        });
        this.outputUnitsList.setFont(new Font("Monospaced", 0, 14));
        this.outputUnitsList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.outputUnitsList.setToolTipText("Click desired input unit");
        this.outputUnitsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PLCalcMainPanel.this.outputUnitsListMouseClicked(mouseEvent);
            }
        });
        this.outputListScrollPane.setViewportView(this.outputUnitsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.unitsOutputPanel.add((Component)this.outputListScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.unitsIOPanel.add((Component)this.unitsOutputPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.unitsPanel.add((Component)this.unitsIOPanel, gridBagConstraints);
        this.TabbedPane.addTab("Conversions", this.unitsPanel);
        this.BasePanel.setLayout(new GridBagLayout());
        this.BinaryField.setFont(new Font("Courier", 0, 14));
        this.BinaryField.setHorizontalAlignment(4);
        this.BinaryField.setMargin(new Insets(0, 2, 0, 2));
        this.BinaryField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PLCalcMainPanel.this.BinaryFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.BasePanel.add((Component)this.BinaryField, gridBagConstraints);
        this.OctalField.setFont(new Font("Courier", 0, 14));
        this.OctalField.setHorizontalAlignment(4);
        this.OctalField.setMargin(new Insets(0, 2, 0, 2));
        this.OctalField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PLCalcMainPanel.this.OctalFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.BasePanel.add((Component)this.OctalField, gridBagConstraints);
        this.DecimalField.setFont(new Font("Courier", 0, 14));
        this.DecimalField.setHorizontalAlignment(4);
        this.DecimalField.setMargin(new Insets(0, 2, 0, 2));
        this.DecimalField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PLCalcMainPanel.this.DecimalFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.BasePanel.add((Component)this.DecimalField, gridBagConstraints);
        this.HexField.setFont(new Font("Courier", 0, 14));
        this.HexField.setHorizontalAlignment(4);
        this.HexField.setMargin(new Insets(0, 2, 0, 2));
        this.HexField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PLCalcMainPanel.this.HexFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.BasePanel.add((Component)this.HexField, gridBagConstraints);
        this.jLabel6.setText("Binary");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BasePanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Octal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BasePanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Decimal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BasePanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Hexadecimal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BasePanel.add((Component)this.jLabel9, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.BaseTextArea.setColumns(20);
        this.BaseTextArea.setEditable(false);
        this.BaseTextArea.setFont(new Font("Courier", 0, 13));
        this.BaseTextArea.setLineWrap(true);
        this.BaseTextArea.setRows(5);
        this.BaseTextArea.setWrapStyleWord(true);
        this.BaseTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.jScrollPane2.setViewportView(this.BaseTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.BasePanel.add((Component)this.jPanel3, gridBagConstraints);
        this.TabbedPane.addTab("Bases", this.BasePanel);
        this.helpPanel.setLayout(new GridBagLayout());
        this.HelpTextArea.setColumns(20);
        this.HelpTextArea.setFont(new Font("Courier", 0, 13));
        this.HelpTextArea.setLineWrap(true);
        this.HelpTextArea.setRows(5);
        this.HelpTextArea.setWrapStyleWord(true);
        this.HelpTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.jScrollPane5.setViewportView(this.HelpTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.helpPanel.add((Component)this.jScrollPane5, gridBagConstraints);
        this.TabbedPane.addTab("Help", this.helpPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.TabbedPane, gridBagConstraints);
        this.StatusLabel.setText("Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.StatusLabel, gridBagConstraints);
    }

    private void FixRadioButtonMouseClicked(MouseEvent mouseEvent) {
        this.displayOptionsChanged();
    }

    private void SciRadioButtonMouseClicked(MouseEvent mouseEvent) {
        this.displayOptionsChanged();
    }

    private void DecPlacesComboItemStateChanged(ItemEvent itemEvent) {
        this.displayOptionsChanged();
    }

    private void AllRadioButtonMouseClicked(MouseEvent mouseEvent) {
        this.displayOptionsChanged();
    }

    private void InputModeComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.calc.showStackDisp();
    }

    private void TabbedPaneStateChanged(ChangeEvent changeEvent) {
        this.setPaneTab(-1);
    }

    private void HexFieldKeyReleased(KeyEvent keyEvent) {
        this.basec.process(keyEvent, 3);
    }

    private void DecimalFieldKeyReleased(KeyEvent keyEvent) {
        this.basec.process(keyEvent, 2);
    }

    private void OctalFieldKeyReleased(KeyEvent keyEvent) {
        this.basec.process(keyEvent, 1);
    }

    private void BinaryFieldKeyReleased(KeyEvent keyEvent) {
        this.basec.process(keyEvent, 0);
    }

    private void resultButtonMouseClicked(MouseEvent mouseEvent) {
        this.stat.process();
    }

    private void PMTButtonMouseClicked(MouseEvent mouseEvent) {
        this.finance.process("PMT");
    }

    private void NPButtonMouseClicked(MouseEvent mouseEvent) {
        this.finance.process("NP");
    }

    private void PVButtonMouseClicked(MouseEvent mouseEvent) {
        this.finance.process("PV");
    }

    private void FVButtonMouseClicked(MouseEvent mouseEvent) {
        this.finance.process("FV");
    }

    private void IRButtonMouseClicked(MouseEvent mouseEvent) {
        this.finance.process("IR");
    }

    private void EnterButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.enterAction();
    }

    private void DivButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("/");
    }

    private void MultButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("*");
    }

    private void SubButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("-");
    }

    private void AddButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("+");
    }

    private void yrxMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("yrx");
    }

    private void x2ButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("sq");
    }

    private void eButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("e");
    }

    private void piButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("pi");
    }

    private void rdButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("r-d");
    }

    private void drButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("d-r");
    }

    private void ClearButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.clearStack(true);
    }

    private void swapButton1MouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("swap");
    }

    private void InvXButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("1/x");
    }

    private void dropButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("drop");
    }

    private void ChsButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("chs");
    }

    private void tenXButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("tenx");
    }

    private void logXButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("logx");
    }

    private void etoxButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("ex");
    }

    private void LnXButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("lnx");
    }

    private void SqrtButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("sqrt");
    }

    private void ATanButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("atan");
    }

    private void ACosButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("acos");
    }

    private void ASinButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("asin");
    }

    private void ytoXButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("^");
    }

    private void TanButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("tan");
    }

    private void CosButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("cos");
    }

    private void SinButtonMouseClicked(MouseEvent mouseEvent) {
        this.calc.processCommand("sin");
    }

    private void EntryTextFieldKeyTyped(KeyEvent keyEvent) {
        this.calc.enterAction(keyEvent);
    }

    private void EntryTextFieldKeyPressed(KeyEvent keyEvent) {
        this.calc.processKey(keyEvent);
    }

    private void unitsInputFieldKeyTyped(KeyEvent keyEvent) {
        this.units.manageKeyTyped(keyEvent);
    }

    private void outputListScrollPaneComponentResized(ComponentEvent componentEvent) {
        this.testUnitsAcceptConversion();
    }

    private void outputUnitsListMouseClicked(MouseEvent mouseEvent) {
        this.units.setInputUnit();
    }
}

