/*
 * Decompiled with CFR 0.152.
 */
package plcalc;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import plcalc.MyFieldsComparator;
import plcalc.MyListCellRenderer;
import plcalc.PLCalcMainPanel;
import plcalc.UnitData;
import plcalc.UnitDatum;

public class Units
extends JPanel {
    PLCalcMainPanel parent;
    UnitDatum[] currentInputUnit = null;
    JButton[] unitButton;
    JButton oldButton = null;
    int inputUnitIndex = 0;

    public Units(PLCalcMainPanel pLCalcMainPanel) {
        this.parent = pLCalcMainPanel;
        this.parent.outputUnitsList.setCellRenderer(new MyListCellRenderer());
        int n = 6;
        Field[] fieldArray = UnitData.class.getDeclaredFields();
        Arrays.sort(fieldArray, new MyFieldsComparator());
        this.unitButton = new JButton[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            JButton jButton;
            this.unitButton[i] = jButton = new JButton(fieldArray[i].getName());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = i % n;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            switch (i / n) {
                case 0: {
                    this.parent.unitsButtonPanel1.add((Component)jButton, gridBagConstraints);
                    break;
                }
                case 1: {
                    this.parent.unitsButtonPanel2.add((Component)jButton, gridBagConstraints);
                }
            }
            jButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Units.this.unitsMouseClicked(mouseEvent);
                }
            });
        }
        this.selectInputUnit(this.unitButton[3]);
        this.acceptConversion();
    }

    void setBoldFont(Component component, boolean bl) {
        Font font = component.getFont();
        Font font2 = font.deriveFont(bl ? 1 : 0);
        component.setFont(font2);
    }

    void selectInputUnit(JButton jButton) {
        this.inputUnitIndex = 0;
        this.setBoldFont(jButton, true);
        if (this.oldButton != null) {
            this.setBoldFont(this.oldButton, false);
        }
        this.oldButton = jButton;
        String string = jButton.getText();
        try {
            Field field = UnitData.class.getDeclaredField(string);
            this.currentInputUnit = (UnitDatum[])field.get(UnitData.class);
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ":selectInputUnit: " + exception);
        }
        this.acceptConversion();
    }

    public void setInputUnit() {
        this.inputUnitIndex = this.parent.outputUnitsList.getSelectedIndex();
        this.acceptConversion();
    }

    public void manageKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.acceptConversion();
        }
    }

    void acceptConversion() {
        this.parent.inputUnitLabel.setText("<html><b>Input Unit: " + this.getUnitString() + "</b></html>");
        double d = 0.0;
        try {
            d = this.parent.getDouble(this.parent.unitsInputField.getText());
            this.performConversion(d);
        }
        catch (NumberFormatException numberFormatException) {
            this.parent.beep();
        }
    }

    String getUnitString() {
        UnitDatum[] unitDatumArray = this.currentInputUnit;
        UnitDatum unitDatum = unitDatumArray[this.inputUnitIndex];
        return unitDatum.name;
    }

    void performConversion(double d) {
        if (this.currentInputUnit != null) {
            int n;
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            this.parent.outputUnitsList.setModel(defaultListModel);
            UnitDatum[] unitDatumArray = this.currentInputUnit;
            UnitDatum unitDatum = unitDatumArray[this.inputUnitIndex];
            double d2 = unitDatum.m;
            double d3 = unitDatum.b;
            int n2 = 0;
            for (n = 0; n < unitDatumArray.length; ++n) {
                int n3 = unitDatumArray[n].name.length();
                n2 = n3 > n2 ? n3 : n2;
            }
            n = this.parent.outputListScrollPane.getViewport().getWidth();
            n -= this.parent.outputListScrollPane.getVerticalScrollBar().getWidth();
            FontMetrics fontMetrics = this.parent.outputUnitsList.getFontMetrics(this.parent.outputUnitsList.getFont());
            int n4 = fontMetrics.charWidth('0');
            for (int i = 0; i < unitDatumArray.length; ++i) {
                double d4 = unitDatumArray[i].m;
                double d5 = unitDatumArray[i].b;
                double d6 = (d - d3) / d2 * d4 + d5;
                String string = " %-" + n2 + "s";
                String string2 = String.format(string, unitDatumArray[i].name);
                int n5 = n - string2.length() * n4;
                String string3 = this.parent.getCurrentFormat();
                String string4 = this.parent.specialFormat(string3, d6);
                if (this.parent.isAllFormat()) {
                    int n6 = this.parent.getDecPlaces() + 4;
                    int n7 = string4.indexOf(this.parent.radixChar);
                    if (n7 == -1) {
                        string4 = string4 + this.parent.radixChar + "0";
                    }
                    n7 = string4.indexOf(this.parent.radixChar);
                    n6 -= string4.length() - n7;
                    while (n6-- > 0) {
                        string4 = string4 + " ";
                    }
                }
                while (string4.length() * n4 < n5) {
                    string4 = " " + string4;
                }
                defaultListModel.addElement(string2 + string4);
            }
            this.parent.outputUnitsList.setSelectedIndex(this.inputUnitIndex);
        }
    }

    void unitsMouseClicked(MouseEvent mouseEvent) {
        this.selectInputUnit((JButton)mouseEvent.getComponent());
        this.acceptConversion();
    }
}

