/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GRAPHICDISPLAY_H
#define GRAPHICDISPLAY_H

#include <qpixmap.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qlabel.h>

#include <cmath>

#include "signalgen.h"

/**
@author Paul Lutus
*/
class GraphicDisplay {
public:
    GraphicDisplay(QLabel *,SignalGen *);

    ~GraphicDisplay();
    void setup();

    void ShowData(double data[], int size,double zeroPoint,double scale,double hscale,bool force);
    
    QLabel *frame;
    SignalGen *parent;
    
    bool busy;

private:

    QPixmap *qpm;
    int oldxsize;
    int oldysize;

    int scalePoint(double v,int a, int b);

};

#endif
