/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@pl-alpha                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ICONEDITOR_H
#define ICONEDITOR_H

#include "IconEditorGUI.h"
#include <qlayout.h>
#include <qsplitter.h>
#include <qtabwidget.h>
#include <iostream>
#include <string>

using namespace std;

class SlideProjector;

class MyIconView;

class IconEditor : public IconEditorMainFrame {
    Q_OBJECT

public:
    IconEditor(QWidget* parent = 0, SlideProjector *p = 0,const char* name = 0, WFlags fl = 0 );
    ~IconEditor();
    /*$PUBLIC_FUNCTIONS$*/
    
    static const char *whatsThisText[];
    
    MyIconView *dest,*scratch,*currentView;
    SlideProjector *parent;
    bool changed;
    string showPath;
    bool active;
    
    bool checkChanged();
    void updateSaveStatus(MyIconView *p,bool changed);
    bool fileExists(string path);
    void showContextMenu();
    
public slots:
    /*$PUBLIC_SLOTS$*/
    void loadEditDirectory();
    void loadEditShow();
    void newCom();
    void saveCom();
    void contextMenuEvent( QContextMenuEvent * );
    void closeTab();
    void refreshThumbnails();
    void replaceThumbnails();

protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

