/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include "imagedata.h"

ImageData::ImageData(string f) {
    fn = f;
    image = NULL;
}

ImageData::~ImageData() {
    removeImage();
}

void ImageData::removeImage() {
    delete(image);
    image = NULL;
}

QImage *ImageData::getImage(bool doItNow) {
    if(image == NULL) {
        if(doItNow) {
            newImage();
        } else if(!running()) { // don't duplicate threaded load
            start();
        }
    }
    return image;
}

// private

QImage *ImageData::newImage() {
    //printf("loading %s\n",fn.c_str());
    //fflush(stdout);
    removeImage();
    QImage *im = new QImage(fn.c_str());
    if(image != NULL) { // there was an overlapping load
        delete(im);
    } else {
        image = im;
    }
    return image;
}

void ImageData::run() {
    newImage();
}

string ImageData::retrieveCurrentImagePath()
{
	return fn;
}