/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IMAGEFILEHANDLER_H
#define IMAGEFILEHANDLER_H

#include <cstdio>
#include <iostream>
#include <map>
#include <fstream>
#include <vector>
#include <algorithm>
#include <cctype>
#include <functional>
#include <string>

#include <qapplication.h>
#include <qimage.h>
#include <qthread.h>
#include "imagedata.h"

using namespace std;

/**
@author Paul Lutus
*/
class ImageFileHandler
{
public:
    ImageFileHandler();

    ~ImageFileHandler();
    
    void setup();
    
    void eraseImages();
    
    vector <string> getProgramList(string path);
    vector <string> readDirectory(string path,string match);
    
    void newImageSet(string,string);
    
    vector <ImageData *> *fileList;
    
    int listSize();
    int getCurrentImage();
string retrieveCurrentImagePath();
    
    QImage *retrieveFirstImage();
    QImage *retrieveLastImage();
    QImage *retrieveImage(int i);
    QImage *retrieveDeltaImage(int i);
    
    QImage *getImage(int,bool);
    void processAdjacentImages();
    
    int currentImage;

};

#endif
