/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "myqlabel.h"
#include "slideprojector.h"
#include <qtooltip.h>
#include <qcursor.h>


MyQLabel::MyQLabel(SlideProjector *p1,QWidget * p2, const char * name,WFlags ) : QLabel(p2,name)
{
  parent = p1;
  mouseDeltaX = 0;
  mouseDeltaY = 0;
  mouseOldX = 0;
  mouseOldY = 0;
  mouseTime = 0;
  oldZoom = parent->zoom;
  alignmentFrame = false;
  image = NULL;
  pm = NULL;
  backgroundColor = QColor(0,0,0);
  borderColor = QColor(32,32,32);
  oldWidth = -1;
  oldHeight = -1;
  // this prevents background erase
  setBackgroundMode(NoBackground);

  /*QObject::connect(
      this, SIGNAL(pressed()),
      this, SLOT(mousePressed())
  );

  QObject::connect(
      this, SIGNAL(dragged()),
      this, SLOT(mouseDragged())
  );*/

  cursorTimer = new QTimer( this );
  connect( cursorTimer, SIGNAL(timeout()),this, SLOT(cursorControl()) );
  cursorTimer->start( 100, false );

}


MyQLabel::~MyQLabel()
{
  delete(pm);
  delete(image);
  cursorTimer->stop();
  delete(cursorTimer);
}

void MyQLabel::mousePressEvent(QMouseEvent* e)
{
  if(!parent->zoom)
    return;
  mouseStartX = e->x() - mouseDeltaX;
  mouseStartY = e->y() - mouseDeltaY;
}

void MyQLabel::mouseMoveEvent(QMouseEvent* e)
{
  if(!parent->zoom)
    return;
  mouseDeltaX = e->x() - mouseStartX;
  mouseDeltaY = e->y() - mouseStartY;
  update();
}

void MyQLabel::cursorControl()
{
  static int td = 20; // this works out to two seconds
  QPoint mp = QCursor::pos();
  bool changed = (mouseOldX != mp.x() || mouseOldY != mp.y());
  mouseOldX = mp.x();
  mouseOldY = mp.y();
  if(changed)
  {
    mouseTime = 0;
    QWidget::setCursor(Qt::ArrowCursor);
  }
  else if(mouseTime < td)
  {
    mouseTime++;
  }
  else if(mouseTime == td)
  {
    QWidget::setCursor(Qt::BlankCursor);
    mouseTime++;
  }
}

void MyQLabel::contextMenuEvent( QContextMenuEvent * e)
{
  //printf("event\n");
  //fflush(stdout);
  if(fromEditor)
  {
    e->accept();
    e->consume();
    QToolTip::remove
      (this);
    fromEditor = false;
    parent->showEditor();
  }
  else
  {
    e->ignore();
  }
}

void MyQLabel::toggleAlignmentFrame(bool upd)
{
  alignmentFrame = !alignmentFrame;
  if(upd)
  {
    update();
  }
}

void MyQLabel::setImage(QImage *im,bool upd,bool fe)
{
  fromEditor = fe;
  if(fromEditor)
  {
    QToolTip::add
      (this, "Right-click to return to editor.");
  }
  else
  {
    QToolTip::remove
      (this);
  }
  //printf("new image.\n");
  //fflush(stdout);
  if(im == NULL)
    return;
  mouseDeltaX = 0;
  mouseDeltaY = 0;
  image = im;
  //printf("new image 2.\n");
  //fflush(stdout);
  setPMap();
  //printf("new image 3: %d %d\n",pm->width(), pm->height());
  //fflush(stdout);
  if(upd)
  {
    update();
  }
}

void MyQLabel::setPMap()
{
  delete(pm);
  // scale with fixed aspect ratio
  if(parent->zoom)
  {
    pm = new QPixmap(*image);
  }
  else
  {
    pm = new QPixmap(image->scale(width(),height(),QImage::ScaleMin));
  }
}

void MyQLabel::refreshImage(bool active)
{
  if(active)
  {
    update();
  }
}

QSize MyQLabel::minimumSizeHint()
{
  return QSize(0,0);
}

void MyQLabel::paintEvent(QPaintEvent *)
{
  QPainter qp(this);
  if(image == NULL)
  {
    qp.fillRect(0,0,width(),height(),backgroundColor);
  }
  else
  {
    if(width() != oldWidth || height() != oldHeight || oldZoom != parent->zoom)
    {
      // must rescale image
      setPMap();
      oldWidth = width();
      oldHeight = height();
      oldZoom = parent->zoom;
      mouseDeltaX = 0;
      mouseDeltaY = 0;
    }

    // center the image in the frame
    int dxa = ((width() - pm->width()) / 2);
    int dya = ((height() - pm->height()) / 2);

    /*
           if(parent->zoom) {
               mouseDeltaX = (mouseDeltaX < dxa)?dxa:mouseDeltaX;
               mouseDeltaY = (mouseDeltaY < dya)?dya:mouseDeltaY;
        mouseDeltaX = (mouseDeltaX > width())?width():mouseDeltaX;
        int h = pm->height() * (pm->height()/height());
        mouseDeltaY = (mouseDeltaY > h)?h:mouseDeltaY;
           }*/

    dxa += mouseDeltaX;
    dya += mouseDeltaY;

    int dxb = width() - pm->width() - dxa;
    int dyb = height() - pm->height() - dya;


    // because there is no background erase,
    // erase any surrounding rectangles
    if(dxa > 0)
    {
      qp.fillRect(0,0,dxa,height(),backgroundColor);
    }
    if(dya > 0)
    {
      qp.fillRect(0,0,width(),dya,backgroundColor);
    }
    if(dxb > 0)
    {
      qp.fillRect(width()-dxb,0,width(),height(),backgroundColor);
    }
    if(dyb > 0)
    {
      qp.fillRect(0,height()-dyb,width(),height(),backgroundColor);
    }
    if(alignmentFrame)
    {
      qp.setPen(QColor(255,255,0));
      qp.drawRect(0,0,width(),height());
    }
    else if(parent->borderFrame)
    {
      qp.setPen(borderColor);
      qp.drawRect(0,0,width(),height());
    }
    // transfer the image onto the screen
    bitBlt(this,0,0,pm,-dxa,-dya,width(),height());
  }
  qp.end();
}
