/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.Vector;

public final class TankStepped {
    public final String VERSION = "1.1";
    final int fieldWidth = 18;
    final int decimalPlaces = 3;
    final String nFormat = "%18.3f";
    final String csvFormat = "%.3f";
    final String sFormat = "%18s";
    final int BOTTOMSECTION = 0;
    final int MIDDLESECTION = 1;
    final int TOPSECTION = 2;
    boolean csvMode = false;
    String name = this.getClass().getName();
    Vector<TankSection> sections;

    double computeSectionPartialVolume(int section, double r, double h, double y) {
        double v = 0.0;
        double pid6 = 0.5235987755982988;
        switch (section) {
            case 0: {
                if (h == 0.0) break;
                double q = r * (y / h);
                v = Math.PI * q * q * y / 3.0;
                break;
            }
            case 1: {
                v = Math.PI * r * r * y;
                break;
            }
            case 2: {
                double mr = (r * r + h * h) / (2.0 * h);
                double hh = h - y;
                double qr = mr - hh;
                double rr = Math.sqrt(mr * mr - qr * qr);
                v = (3.0 * r * r + h * h) * h;
                v -= (3.0 * rr * rr + hh * hh) * hh;
                v *= 0.5235987755982988;
            }
        }
        return v;
    }

    String formatRecord(String format, double a, double b) {
        if (this.csvMode) {
            return String.format("%.3f,%.3f", a, b);
        }
        return String.format("%18.3f %18.3f", a, b);
    }

    String formatRecord(String format, String a, String b) {
        if (this.csvMode) {
            return String.format("%s,%s", a, b);
        }
        return String.format("%18s %18s", a, b);
    }

    String computeTankPartialVolume(double by, String nFormat) {
        double volume = 0.0;
        double y = by;
        Iterator<TankSection> it = this.sections.iterator();
        while (y > 0.0 && it.hasNext()) {
            int tSec;
            TankSection s = it.next();
            int n = s == this.sections.firstElement() ? 0 : (tSec = s == this.sections.lastElement() ? 2 : 1);
            if (s.h >= y) {
                volume += this.computeSectionPartialVolume(tSec, s.r, s.h, y);
                y = 0.0;
                continue;
            }
            volume += this.computeSectionPartialVolume(tSec, s.r, s.h, s.h);
            y -= s.h;
        }
        return this.formatRecord(nFormat, by, volume);
    }

    void createTable(double n, double height) {
        double y = 0.0;
        Vector<String> vs = new Vector<String>();
        String fs = this.formatRecord("%18s", "Height", "Volume");
        vs.add(fs);
        if (n < 0.0) {
            int iy = 0;
            while (true) {
                double d;
                double ty = (double)iy * -n;
                if (!(d <= height)) break;
                y = ty;
                fs = this.computeTankPartialVolume(y, "%18.3f");
                vs.add(fs);
                ++iy;
            }
            String ns = this.computeTankPartialVolume(height, "%18.3f");
            if (!ns.equals(fs)) {
                vs.add(ns);
            }
        } else {
            n = n > height ? height : n;
            fs = this.computeTankPartialVolume(n, "%18.3f");
            vs.add(fs);
        }
        Iterator is = vs.iterator();
        while (is.hasNext()) {
            System.out.println((String)is.next());
        }
    }

    void process(String[] args) {
        int i = 0;
        if (args.length > 0 && args[0].equals("-v")) {
            System.out.println(this.name + " version " + "1.1");
        } else if (args.length < 7) {
            System.out.println("usage: [-v version] [-c (csv mode)] (tank section radius/height pairs) r h r h r h ... (-n = table stepsize or +n = arg) n");
            System.out.println("       see http://arachnoid.com/TankCalc/TankStepped.html for more instructions.");
        } else {
            try {
                if (args[0].equals("-c")) {
                    this.csvMode = true;
                    ++i;
                }
                double height = 0.0;
                this.sections = new Vector();
                int top = args.length;
                while (i < top - 1) {
                    double r = Double.parseDouble(args[i]);
                    double h = Double.parseDouble(args[i + 1]);
                    this.sections.add(new TankSection(r, h));
                    height += h;
                    i += 2;
                }
                TankSection s = this.sections.lastElement();
                if (s.h > s.r) {
                    height -= s.h;
                    s.h -= Math.sqrt(s.h * s.h - s.r * s.r);
                    height += s.h;
                }
                if (i >= args.length) {
                    throw new Exception("No stepsize or argument entry.");
                }
                double step = Double.parseDouble(args[i]);
                this.createTable(step, height);
            }
            catch (Exception e) {
                System.out.println(this.name + ": Error: " + e);
            }
        }
    }

    public static void main(String[] args) {
        TankStepped ts = new TankStepped();
        ts.process(args);
    }

    class TankSection {
        double r;
        double h;

        public TankSection(double r, double h) {
            this.r = r;
            this.h = h;
        }
    }
}

