/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;
import tankcalc.HelpState;
import tankcalc.TankCalc;

public final class HelpPane
extends JPanel {
    TankCalc parent;
    Stack<HelpState> undoStack;
    Stack<HelpState> redoStack;
    Document doc;
    String oldSearch = "";
    int oldPos = 0;
    Object oldHighlight = null;
    Highlighter highlighter = null;
    Highlighter.HighlightPainter highlightPainter = null;
    protected JTextField findTextField;
    private JScrollPane helpScrollPane;
    private JTextPane helpTextPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton redoButton;
    private JButton undoButton;

    public HelpPane(TankCalc p) {
        this.parent = p;
        this.initComponents();
        this.helpTextPane.setContentType("text/html;charset=UTF-8");
        this.doc = this.helpTextPane.getDocument();
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.highlighter = this.helpTextPane.getHighlighter();
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 255, 200));
        this.setupHelp();
        this.setButtons();
    }

    void setupHelp() {
        String fn = "help_resources/helpText.html";
        try {
            String line;
            InputStream is = this.parent.getClass().getResourceAsStream(fn);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            is.close();
            String s = sb.toString();
            s = s.replaceAll("#version#", this.parent.VERSION);
            URL url = this.parent.getClass().getResource(fn).toURI().toURL();
            this.helpTextPane.setText(s);
            this.helpTextPane.select(0, 0);
            ((HTMLDocument)this.helpTextPane.getDocument()).setBase(url);
        }
        catch (Exception e) {
            System.out.println("setupHelp: " + e);
            e.printStackTrace(System.out);
        }
    }

    public int getScrollPos() {
        return this.helpScrollPane.getVerticalScrollBar().getValue();
    }

    public void setScrollPos(int v) {
        this.helpScrollPane.getVerticalScrollBar().setValue(v);
    }

    private void manageHyperlinks(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String surl = evt.getURL().toString();
            if (surl.matches("http://.*")) {
                try {
                    Desktop.getDesktop().browse(URI.create(surl));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else if (surl.matches(".*#.*")) {
                try {
                    this.undoPush();
                    this.helpTextPane.scrollToReference(url.getRef());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    void undoPop() {
        if (this.undoStack.size() > 0) {
            this.redoPush();
            this.removeOldHighlight();
            HelpState hs = this.undoStack.pop();
            this.helpScrollPane.getVerticalScrollBar().setValue(hs.scrollBar);
            try {
                this.oldHighlight = this.highlighter.addHighlight(hs.selectStart, hs.selectEnd, this.highlightPainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.setButtons();
        } else {
            this.parent.beep();
        }
    }

    void redoPop() {
        if (this.redoStack.size() > 0) {
            this.undoPush();
            this.removeOldHighlight();
            HelpState hs = this.redoStack.pop();
            this.helpScrollPane.getVerticalScrollBar().setValue(hs.scrollBar);
            try {
                this.oldHighlight = this.highlighter.addHighlight(hs.selectStart, hs.selectEnd, this.highlightPainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.setButtons();
        } else {
            this.parent.beep();
        }
    }

    void undoPush() {
        int ss = 0;
        int se = 0;
        Highlighter.Highlight[] ha = this.highlighter.getHighlights();
        if (ha.length > 0) {
            ss = ha[0].getStartOffset();
            se = ha[0].getEndOffset();
        }
        int sbp = this.helpScrollPane.getVerticalScrollBar().getValue();
        this.undoStack.push(new HelpState(sbp, ss, se));
        this.setButtons();
    }

    void redoPush() {
        int ss = 0;
        int se = 0;
        Highlighter.Highlight[] ha = this.highlighter.getHighlights();
        if (ha.length > 0) {
            ss = ha[0].getStartOffset();
            se = ha[0].getEndOffset();
        }
        int sbp = this.helpScrollPane.getVerticalScrollBar().getValue();
        this.redoStack.push(new HelpState(sbp, ss, se));
        this.setButtons();
    }

    void setButtons() {
        this.undoButton.setEnabled(this.undoStack.size() > 0);
        this.redoButton.setEnabled(this.redoStack.size() > 0);
    }

    void removeOldHighlight() {
        if (this.oldHighlight != null) {
            this.highlighter.removeHighlight(this.oldHighlight);
            this.oldHighlight = null;
        }
    }

    void manageHelpTextField(KeyEvent evt) {
        try {
            this.removeOldHighlight();
            this.doc = this.helpTextPane.getDocument();
            int len = this.doc.getLength();
            String content = this.doc.getText(0, len).toLowerCase();
            String search = this.findTextField.getText().toLowerCase();
            if (!search.equals(this.oldSearch)) {
                this.oldPos = 0;
            }
            this.oldSearch = search;
            int p = content.indexOf(search, this.oldPos);
            if (p == -1) {
                this.oldPos = 0;
                p = content.indexOf(search, this.oldPos);
            }
            if (p >= 0) {
                int slen = search.length();
                Rectangle r = this.helpTextPane.modelToView(p);
                int pos = r.y - this.helpScrollPane.getHeight() / 2;
                pos = pos < 0 ? 0 : pos;
                this.helpScrollPane.getVerticalScrollBar().setValue(pos);
                this.oldHighlight = this.highlighter.addHighlight(p, p + slen, this.highlightPainter);
                this.oldPos = p + 1;
                this.undoPush();
            } else {
                this.parent.beep();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.jLabel1 = new JLabel();
        this.findTextField = new JTextField();
        this.helpScrollPane = new JScrollPane();
        this.helpTextPane = new JTextPane();
        this.setLayout(new GridBagLayout());
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/go-previous.png")));
        this.undoButton.setToolTipText("Go back");
        this.undoButton.setFocusable(false);
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpPane.this.undoButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.undoButton);
        this.redoButton.setIcon(new ImageIcon(this.getClass().getResource("/tankcalc/icons/go-next.png")));
        this.redoButton.setToolTipText("Go forward");
        this.redoButton.setFocusable(false);
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpPane.this.redoButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.redoButton);
        this.jLabel1.setText("Search:");
        this.jPanel1.add(this.jLabel1);
        this.findTextField.setToolTipText("<html>Quick search: type a search string,<br/>press Enter to find the next case</html>");
        this.findTextField.setFocusCycleRoot(true);
        this.findTextField.setMinimumSize(new Dimension(150, 27));
        this.findTextField.setPreferredSize(new Dimension(150, 27));
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HelpPane.this.findTextFieldKeyReleased(evt);
            }
        });
        this.jPanel1.add(this.findTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.helpScrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.helpTextPane.setEditable(false);
        this.helpTextPane.setFocusable(false);
        this.helpTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                HelpPane.this.helpTextPaneHyperlinkUpdate(evt);
            }
        });
        this.helpScrollPane.setViewportView(this.helpTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.helpScrollPane, gridBagConstraints);
    }

    private void helpTextPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.manageHyperlinks(evt);
    }

    private void findTextFieldKeyReleased(KeyEvent evt) {
        this.manageHelpTextField(evt);
    }

    private void redoButtonActionPerformed(ActionEvent evt) {
        this.redoPop();
    }

    private void undoButtonActionPerformed(ActionEvent evt) {
        this.undoPop();
    }
}

