/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import tankcalc.TankCalc;
import tankcalc.TankProcessor;
import tankcalc.TankProperties;

public class SurfaceAreaMassComputer {
    TankCalc parent;
    TankProcessor tvi;
    TankProperties sharedTP;
    double iuToLength;
    double iuToArea;
    double iuToVolume;

    public SurfaceAreaMassComputer(TankCalc p, TankProperties stp) {
        this.parent = p;
        this.tvi = this.parent.tankProcessor;
        this.sharedTP = stp;
    }

    void formatLine(String s, double v, String unit, boolean header) {
        String sv = this.parent.formatNum(v);
        this.formatLine(s, sv, unit, header);
    }

    void formatLine(String s, String sv, String unit, boolean header) {
        ArrayList<String> record = new ArrayList<String>(Arrays.asList(s, sv, unit));
        this.parent.addTableRecord(record, header);
    }

    String convertLengthFormat(double v) {
        return this.parent.formatNum(v * this.iuToLength);
    }

    String convertAreaFormat(double v) {
        return this.parent.formatNum(v * this.iuToArea);
    }

    String convertVolumeFormat(double v) {
        return this.parent.formatNum(v * this.iuToVolume);
    }

    public void updateSettings(TankProperties stp) {
        this.sharedTP = stp;
    }

    public void createList() {
        try {
            String plainInUnit;
            this.iuToLength = this.tvi.convertLengthUnits(1.0, true);
            this.iuToArea = this.iuToLength * this.iuToLength;
            this.iuToVolume = this.iuToArea * this.iuToLength;
            String ius = plainInUnit = this.parent.plainTextConvertExponents(this.sharedTP.currentInputUnitName);
            String sius = plainInUnit + "^2";
            String cius = plainInUnit + "^3";
            String cous = this.sharedTP.currentOutputUnitName;
            double wt_conv = this.parent.tankProcessor.convertLengthUnits(this.sharedTP.wallThickness, false);
            double wd = this.sharedTP.wallDensity;
            double cd = this.sharedTP.contentDensity;
            int units = this.sharedTP.weightUnitIndex;
            String su = this.sharedTP.weightUnitName;
            double ftv = this.tvi.maxVolume;
            double fcsa = this.tvi.cylinderFullSurfaceArea() * this.sharedTP.scalingFactor;
            double lca = this.tvi.endCapFullSurfaceArea(true) * this.sharedTP.scalingFactor;
            double rca = this.tvi.endCapFullSurfaceArea(false) * this.sharedTP.scalingFactor;
            double tsa = fcsa + lca + rca;
            double twv = this.tvi.tankFullVolumeWithWallThickness().volume - this.tvi.tankFullVolume().volume;
            double tm = (twv *= this.sharedTP.scalingFactor) * wd * 1000000.0;
            tm /= 1000.0;
            if (units == 1) {
                tm *= 2.2046244;
            }
            double contentw = ftv * cd * 1000000.0;
            contentw /= 1000.0;
            if (units == 1) {
                contentw *= 2.2046244;
            }
            this.formatLine("Name", "Value", "Units", true);
            this.formatLine("Input units", ius, "", false);
            this.formatLine("Output units", this.sharedTP.currentOutputUnitName, "", false);
            this.formatLine("Tank orientation", this.parent.tankOrientationString(), "", false);
            this.formatLine("Cylinder length (L)", this.convertLengthFormat(this.tvi.g_L), ius, false);
            this.formatLine("Cylinder radius (R)", this.convertLengthFormat(this.tvi.g_R), ius, false);
            this.formatLine("Left/bottom cap radius (r)", this.convertLengthFormat(this.tvi.g_rL), ius, false);
            this.formatLine("Right/top cap radius (r)", this.convertLengthFormat(this.tvi.g_rR), ius, false);
            this.formatLine("Scaling factor", this.parent.formatNum(this.sharedTP.scalingFactor), "(width/height ratio)", false);
            this.formatLine("Tank internal height", this.convertLengthFormat(this.tvi.maxHeight), ius, false);
            this.formatLine("Sensor vertical offset", this.convertLengthFormat(this.tvi.trueSensorOffset), ius, false);
            this.formatLine("Cylinder surface area", this.convertAreaFormat(fcsa), sius, false);
            this.formatLine("Left/bottom cap surface area", this.convertAreaFormat(lca), sius, false);
            this.formatLine("Right/top cap surface area", this.convertAreaFormat(rca), sius, false);
            this.formatLine("Tank surface area (cylinder+caps)", this.convertAreaFormat(tsa), sius, false);
            this.formatLine("Tank wall thickness", this.convertLengthFormat(wt_conv), ius, false);
            this.formatLine("Tank wall density", wd, "(water = 1)", false);
            this.formatLine("Tank content density", cd, "(water = 1)", false);
            this.formatLine("Tank wall volume (input units^3)", this.convertVolumeFormat(twv), cius, false);
            this.formatLine("Tank interior volume (input units^3)", this.convertVolumeFormat(ftv), cius, false);
            this.formatLine("Tank interior volume (output units)", this.parent.formatNum(this.sharedTP.maxVolumeConverted), cous, false);
            this.formatLine("Tank content weight (full tank)", this.parent.formatNum(contentw), su, false);
            this.formatLine("Tank empty weight", this.parent.formatNum(tm), su, false);
            this.formatLine("Tank gross weight (tank+contents)", this.parent.formatNum(contentw + tm), su, false);
        }
        catch (Exception e) {
            this.parent.setStatus("Numeric entry error", true);
        }
    }

    public void createIfEnter(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.createList();
        }
    }
}

