/*
 * Decompiled with CFR 0.152.
 */
package tankcalc;

import tankcalc.CartesianNumber;
import tankcalc.Constants;
import tankcalc.TankCalc;
import tankcalc.TankCompResult;
import tankcalc.TankProperties;

public final class TankProcessor {
    TankCalc parent;
    double sensorPositionX;
    double sensorPositionY;
    double sensorPositionZ;
    double residualVolume;
    double trueSensorPositionX;
    double trueSensorPositionY;
    double trueSensorPositionZ;
    double trueSensorOffset = 0.0;
    double g_rLSign = 1.0;
    double g_rRSign = 1.0;
    double g_rL;
    double g_rR;
    double g_R;
    double g_L;
    double halfCylinder;
    double g_sa;
    double g_ca;
    double g_invca;
    double g_ta;
    double leftTankHeight;
    double rightTankHeight;
    double leftMajorSphereRadius;
    double rightMajorSphereRadius;
    double maxHeight;
    double maxExtent;
    double maxVolume;
    double wallThickness;
    TankProperties sharedTP;

    public boolean setValues(TankCalc p, TankProperties stp) {
        this.parent = p;
        this.sharedTP = stp;
        switch (this.sharedTP.tankOrientation) {
            case 2: {
                if (this.sharedTP.tankAngleUnitIndex == 1) {
                    this.sharedTP.angleDegrees = Math.atan(this.sharedTP.enteredAngleDegrees / 100.0) * 57.29577951308232;
                    break;
                }
                this.sharedTP.angleDegrees = this.sharedTP.enteredAngleDegrees;
                break;
            }
            case 0: {
                this.sharedTP.angleDegrees = 0.0;
                break;
            }
            case 1: {
                this.sharedTP.angleDegrees = 90.0;
            }
        }
        this.sharedTP.angleRadians = this.sharedTP.angleDegrees * (Math.PI / 180);
        this.sharedTP.tankUpright = this.sharedTP.angleDegrees >= 45.0;
        this.residualVolume = this.convertVolumeUnits(this.sharedTP.residualVolume, false);
        this.g_L = this.convertLengthUnits(this.sharedTP.g_L, false);
        this.g_R = this.convertLengthUnits(this.sharedTP.g_R, false);
        this.g_rL = this.convertLengthUnits(this.sharedTP.g_rL, false);
        this.g_rL = Math.abs(this.g_rL);
        this.g_rR = this.convertLengthUnits(this.sharedTP.g_rR, false);
        this.g_rR = Math.abs(this.g_rR);
        this.sensorPositionX = this.convertLengthUnits(this.sharedTP.sensorPositionX, false);
        this.sensorPositionY = this.convertLengthUnits(this.sharedTP.sensorPositionY, false);
        this.sensorPositionZ = this.convertLengthUnits(this.sharedTP.sensorPositionZ, false);
        this.wallThickness = this.convertLengthUnits(this.sharedTP.wallThickness, false);
        this.halfCylinder = this.g_L * 0.5;
        if (this.sharedTP.leftEndCapMode == 2 && this.g_rL >= this.g_R) {
            this.leftMajorSphereRadius = this.g_rL;
            this.g_rL = this.minorRadiusFromMajor(this.g_R, this.g_rL);
        } else {
            this.leftMajorSphereRadius = this.majorRadiusFromMinor(this.g_R, this.g_rL);
        }
        if (this.sharedTP.rightEndCapMode == 2 && this.g_rR >= this.g_R) {
            this.rightMajorSphereRadius = this.g_rR;
            this.g_rR = this.minorRadiusFromMajor(this.g_R, this.g_rR);
        } else {
            this.rightMajorSphereRadius = this.majorRadiusFromMinor(this.g_R, this.g_rR);
        }
        this.g_sa = Math.sin(this.sharedTP.angleRadians);
        this.g_ca = Math.cos(this.sharedTP.angleRadians);
        this.g_invca = 1.0 / this.g_ca;
        this.g_ta = Math.tan(this.sharedTP.angleRadians);
        this.leftTankHeight = this.computeHalfHeight(true, this.sharedTP.leftEndCapMode, this.g_rL, this.leftMajorSphereRadius);
        this.rightTankHeight = this.computeHalfHeight(false, this.sharedTP.rightEndCapMode, this.g_rR, this.rightMajorSphereRadius);
        this.maxHeight = this.leftTankHeight + this.rightTankHeight;
        this.maxExtent = this.g_L + this.g_rL + this.g_rR;
        this.maxVolume = this.computeMaxVolume().volume * this.sharedTP.scalingFactor;
        this.sharedTP.maxVolumeConverted = this.convertVolumeUnits(this.maxVolume, true);
        return this.computeTrueSensorPosition();
    }

    double cylinderFullVolume() {
        return Math.PI * this.g_R * this.g_R * this.g_L;
    }

    double cylinderFullVolume(double L, double R) {
        return Math.PI * R * R * L;
    }

    double endCapFullVolume(int endCapMode, double r, double sign) {
        double result = Double.NaN;
        switch (endCapMode) {
            case 0: {
                result = sign * (Math.PI * 2) * this.g_R * this.g_R * r / 3.0;
                break;
            }
            case 1: {
                result = sign * Math.PI * this.g_R * this.g_R * r / 3.0;
                break;
            }
            case 2: {
                result = sign * 0.5235987755982988 * (3.0 * this.g_R * this.g_R + r * r) * r;
            }
        }
        return result;
    }

    double endCapFullVolume(int endCapMode, double R, double r, double sign) {
        double result = Double.NaN;
        switch (endCapMode) {
            case 0: {
                result = sign * (Math.PI * 2) * R * R * r / 3.0;
                break;
            }
            case 1: {
                result = sign * Math.PI * R * R * r / 3.0;
                break;
            }
            case 2: {
                result = sign * 0.5235987755982988 * (3.0 * R * R + r * r) * r;
            }
        }
        return result;
    }

    public TankCompResult tankFullVolume() {
        TankCompResult result = new TankCompResult(this.cylinderFullVolume() + this.endCapFullVolume(this.sharedTP.leftEndCapMode, this.g_rL, this.g_rLSign) + this.endCapFullVolume(this.sharedTP.rightEndCapMode, this.g_rR, this.g_rRSign), this.cylinderFullSurfaceArea() + this.endCapFullSurfaceArea(false) + this.endCapFullSurfaceArea(true), 0.0);
        return result;
    }

    public TankCompResult tankFullVolumeWithWallThickness() {
        TankCompResult result = new TankCompResult(this.cylinderFullVolume(this.g_L, this.g_R + this.wallThickness) + this.endCapFullVolume(this.sharedTP.leftEndCapMode, this.g_R + this.wallThickness, this.g_rL + this.wallThickness, this.g_rLSign) + this.endCapFullVolume(this.sharedTP.rightEndCapMode, this.g_R + this.wallThickness, this.g_rR + this.wallThickness, this.g_rRSign), this.cylinderFullSurfaceArea() + this.endCapFullSurfaceArea(false) + this.endCapFullSurfaceArea(true), 0.0);
        return result;
    }

    void p(String s) {
        System.out.println(s);
    }

    double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    double oblateSpheroidSurfaceArea(double R, double r) {
        double e = Math.sqrt(1.0 - r * r / (R * R));
        return Math.PI * R * R * (1.0 + (1.0 - e * e) / e * this.atanh(e));
    }

    double endCapFullSurfaceAreaType(int endCapMode, double R, double r, double mr) {
        double result = Double.NaN;
        switch (endCapMode) {
            case 0: {
                if (r >= R) {
                    result = Math.PI * 2 * R * R;
                    break;
                }
                if (r <= 0.0) {
                    result = Math.PI * R * R;
                    break;
                }
                result = this.oblateSpheroidSurfaceArea(R, r);
                break;
            }
            case 1: {
                result = Math.sqrt(R * R + r * r) * R * Math.PI;
                break;
            }
            case 2: {
                result = r == R ? Math.PI * 2 * R * R : (r <= 0.0 ? Math.PI * R * R : Math.PI * 2 * r * mr);
            }
        }
        return result;
    }

    public double endCapFullSurfaceArea(boolean rightCap) {
        if (rightCap) {
            return this.endCapFullSurfaceAreaType(this.sharedTP.leftEndCapMode, this.g_R, this.g_rL, this.rightMajorSphereRadius);
        }
        return this.endCapFullSurfaceAreaType(this.sharedTP.rightEndCapMode, this.g_R, this.g_rR, this.leftMajorSphereRadius);
    }

    public double cylinderFullSurfaceArea() {
        return Math.PI * 2 * this.g_R * this.g_L;
    }

    double circleAreaMinusSegment(double r, double y) {
        if (y <= -r || r <= 0.0) {
            return 0.0;
        }
        if (y >= r) {
            return Math.PI * r * r;
        }
        return r * r * Math.acos(-y / r) + y * Math.sqrt(r * r - y * y);
    }

    double wettedLengthSegment(double r, double y) {
        double result = 0.0;
        result = y <= -r || r <= 0.0 ? 0.0 : (y >= r ? 2.0 * r * Math.PI : 2.0 * r * Math.acos(-y / r));
        return result;
    }

    double wettedLengthNormalized(double r, double y) {
        if (y <= -r || r <= 0.0) {
            return 0.0;
        }
        if (y >= r) {
            return 1.0;
        }
        return Math.acos(-y / r) / Math.PI;
    }

    double wettedAreaSegment(double ra, double rb, double y, double h) {
        double sr = ra + rb;
        double dr = ra - rb;
        double a = Math.PI * sr * Math.sqrt(dr * dr + h * h);
        return a * this.wettedLengthNormalized(sr * 0.5, y);
    }

    double surfaceLengthSegment(double r, double y) {
        double result = 0.0;
        if (y <= -r || r <= 0.0) {
            return 0.0;
        }
        if (y >= r) {
            return 0.0;
        }
        double x = y / r;
        result = 2.0 * r * Math.sqrt(1.0 - x * x);
        return result;
    }

    double surfaceAreaSegment(double ra, double rb, double ya, double yb, double h, boolean vertical) {
        double result = 0.0;
        if (vertical) {
            if (yb <= 0.0 && ya > 0.0) {
                result = rb * rb * Math.PI;
            }
        } else {
            double la = this.surfaceLengthSegment(ra, ya);
            double lb = this.surfaceLengthSegment(rb, yb);
            double avg = (la + lb) * 0.5;
            double dy = ya - yb;
            result = Math.sqrt(h * h + dy * dy) * avg;
        }
        return result;
    }

    double trapSqrt(double x) {
        double y = Math.sqrt(x);
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        return y;
    }

    TankCompResult endCapIntegral(double ax, double bx, boolean rightCapFlag, double y, int endCapMode, double g_r, double sign, double sphereRadius) {
        double ecfsa = this.endCapFullSurfaceArea(rightCapFlag);
        TankCompResult result = new TankCompResult();
        if (g_r == 0.0 || bx - ax == 0.0) {
            result.wettedArea = this.circleAreaMinusSegment(this.g_R, y) * this.sharedTP.scalingFactor;
            return result;
        }
        double yia = y - this.g_sa * ax;
        double yib = y - this.g_sa * bx;
        if (yia >= this.g_R && yib >= this.g_R) {
            result.volume = this.endCapFullVolume(endCapMode, g_r, sign);
            result.wettedArea = ecfsa;
        } else if (yia <= -this.g_R && yib <= -this.g_R) {
            result.volume = 0.0;
        } else {
            boolean vertical = this.sharedTP.angleDegrees == 90.0;
            int n = this.sharedTP.endCapIntegrationSteps;
            double ry = 0.0;
            if (ax > bx) {
                double t = ax;
                ax = bx;
                bx = t;
            }
            double radius = 0.0;
            double ratio = this.g_R / g_r;
            double rt2 = g_r * 2.0;
            double range = bx - ax;
            double xstep = range / (double)n;
            switch (endCapMode) {
                case 0: {
                    double delta = rightCapFlag ? g_r : 0.0;
                    for (int i = 0; i <= n; ++i) {
                        double xp = (double)i * xstep;
                        double x = xp + delta;
                        double invx = rt2 - x;
                        double oldRadius = radius;
                        radius = this.trapSqrt(invx * x) * ratio;
                        double ory = ry;
                        ry = (y - this.g_sa * (xp + ax)) * this.g_invca;
                        if (i < n) {
                            result.volume += this.circleAreaMinusSegment(radius, ry);
                        }
                        if (i <= 0) continue;
                        result.wettedArea += this.wettedAreaSegment(oldRadius, radius, ry, xstep);
                        result.surfaceArea += this.surfaceAreaSegment(oldRadius, radius, ory, ry, xstep, vertical);
                    }
                    break;
                }
                case 1: {
                    double delta = rightCapFlag ? g_r : 0.0;
                    for (int i = 0; i <= n; ++i) {
                        double xp = (double)i * xstep;
                        double x = xp + delta;
                        double invx = rt2 - x;
                        double oldRadius = radius;
                        radius = (invx < x ? invx : x) * ratio;
                        double ory = ry;
                        ry = (y - this.g_sa * (xp + ax)) * this.g_invca;
                        if (i < n) {
                            result.volume += this.circleAreaMinusSegment(radius, ry);
                        }
                        if (i <= 0) continue;
                        result.wettedArea += this.wettedAreaSegment(oldRadius, radius, ry, xstep);
                        result.surfaceArea += this.surfaceAreaSegment(oldRadius, radius, ory, ry, xstep, vertical);
                    }
                    break;
                }
                case 2: {
                    double delta = rightCapFlag ? sphereRadius - range : -sphereRadius;
                    double srsq = sphereRadius * sphereRadius;
                    for (int i = 0; i <= n; ++i) {
                        double xp = (double)i * xstep;
                        double x = xp + delta;
                        double oldRadius = radius;
                        radius = this.trapSqrt(srsq - x * x);
                        double ory = ry;
                        ry = (y - this.g_sa * (xp + ax)) * this.g_invca;
                        if (i < n) {
                            result.volume += this.circleAreaMinusSegment(radius, ry);
                        }
                        if (i <= 0) continue;
                        result.wettedArea += this.wettedAreaSegment(oldRadius, radius, ry, xstep);
                        result.surfaceArea += this.surfaceAreaSegment(oldRadius, radius, ory, ry, xstep, vertical);
                    }
                    break;
                }
            }
            result.volume *= sign * xstep;
        }
        result.wettedArea *= this.sharedTP.scalingFactor;
        result.surfaceArea *= this.sharedTP.scalingFactor;
        result.volume *= this.sharedTP.scalingFactor;
        return result;
    }

    TankCompResult cylinderIntegral(double ax, double bx, double y) {
        TankCompResult result = new TankCompResult();
        double sign = 1.0;
        if (this.g_L != 0.0 && bx - ax != 0.0) {
            if (this.g_L < 0.0) {
                sign = -sign;
            }
            if (ax > bx) {
                double t = ax;
                ax = bx;
                bx = t;
            }
            double yia = y - this.g_sa * ax;
            double yib = y - this.g_sa * bx;
            if (yia >= this.g_R && yib >= this.g_R) {
                result.volume = this.cylinderFullVolume();
                result.wettedArea = this.cylinderFullSurfaceArea();
            } else if (yia <= -this.g_R && yib <= -this.g_R) {
                result.volume = 0.0;
            } else if (this.sharedTP.angleDegrees == 90.0) {
                result.surfaceArea = y > ax && y <= bx ? Math.PI * this.g_R * this.g_R : 0.0;
                y = Math.min(y, bx);
                y = Math.max(y, ax);
                result.volume = Math.PI * this.g_R * this.g_R * (y - ax);
                result.wettedArea = Math.PI * 2 * this.g_R * (y - ax);
            } else {
                int n = this.sharedTP.angleDegrees == 0.0 ? 1 : this.sharedTP.cylinderIntegrationSteps;
                double ry = 0.0;
                double xstep = (bx - ax) / (double)n;
                for (int i = 0; i <= n; ++i) {
                    double xp = (double)i * xstep;
                    double ory = ry;
                    ry = (y - this.g_sa * (xp + ax)) * this.g_invca;
                    if (i < n) {
                        result.volume += this.circleAreaMinusSegment(this.g_R, ry);
                    }
                    if (i <= 0) continue;
                    result.wettedArea += this.wettedLengthSegment(this.g_R, ry);
                    result.surfaceArea += this.surfaceAreaSegment(this.g_R, this.g_R, ory, ry, xstep, false);
                }
                result.wettedArea *= xstep;
                result.volume *= sign * xstep;
            }
            result.wettedArea *= this.sharedTP.scalingFactor;
            result.surfaceArea *= this.sharedTP.scalingFactor;
            result.volume *= this.sharedTP.scalingFactor;
        }
        return result;
    }

    TankCompResult performIntegral(int mode, double y, int leftEndCapMode, int rightEndCapMode) {
        TankCompResult result = new TankCompResult();
        if (Double.isNaN(y)) {
            return result;
        }
        if ((mode & 1) != 0) {
            result.add(this.endCapIntegral(-this.halfCylinder - this.g_rL, -this.halfCylinder, false, y, leftEndCapMode, this.g_rL, this.g_rLSign, this.leftMajorSphereRadius));
        }
        if ((mode & 2) != 0) {
            result.add(this.cylinderIntegral(-this.halfCylinder, this.halfCylinder, y));
        }
        if ((mode & 4) != 0) {
            result.add(this.endCapIntegral(this.halfCylinder, this.halfCylinder + this.g_rR, true, y, rightEndCapMode, this.g_rR, this.g_rRSign, this.rightMajorSphereRadius));
        }
        return result;
    }

    public TankCompResult performFullIntegral(double y, int leftEndCapMode, int rightEndCapMode) {
        return this.performIntegral(7, y - this.leftTankHeight, leftEndCapMode, rightEndCapMode);
    }

    public double computeHalfHeight(boolean leftEnd, int endCapMode, double g_r, double majorSphereRadius) {
        if (this.sharedTP.angleDegrees == 90.0) {
            return this.halfCylinder + g_r;
        }
        if (this.sharedTP.angleDegrees == 0.0) {
            return this.g_R;
        }
        double rx = this.g_R * this.g_ca;
        double ly = this.halfCylinder * this.g_sa;
        if (g_r == 0.0) {
            return ly + rx;
        }
        double y = g_r * this.g_sa;
        switch (endCapMode) {
            case 0: {
                return ly + rx + Math.sqrt(rx * rx + y * y) - this.g_R * this.g_ca;
            }
            case 1: {
                return ly + rx + (y > 0.0 ? (y -= rx) : 0.0);
            }
            case 2: {
                boolean shortRadius = majorSphereRadius < this.halfCylinder;
                double ta = Math.atan(this.halfCylinder / this.g_R);
                if (!shortRadius) {
                    if (this.sharedTP.angleRadians < ta) {
                        return ly + rx;
                    }
                    double ma = g_r * this.g_sa;
                    double mb = this.g_R * this.g_ca;
                    double mr = Math.sqrt(ma * ma + mb * mb);
                    return ly + mr;
                }
                double qy = rx > g_r ? rx : g_r;
                return ly + qy;
            }
        }
        return Double.NaN;
    }

    double majorRadiusFromMinor(double R, double r) {
        if (r > 0.0) {
            return (R * R + r * r) / (2.0 * r);
        }
        return Double.NaN;
    }

    double minorRadiusFromMajor(double R, double sr) {
        return sr - Math.sqrt(sr * sr - R * R);
    }

    boolean computeTrueSensorPosition() {
        this.trueSensorPositionZ = this.sensorPositionZ;
        double z = 0.0;
        double delta = this.g_R - Math.sqrt(this.g_R * this.g_R - this.sensorPositionZ * this.sensorPositionZ);
        double x = this.sensorPositionX;
        double y = -this.g_R + delta + this.sensorPositionY;
        CartesianNumber hCase = new CartesianNumber(x, y, z);
        delta = this.endCapSurfacePos(this.sharedTP.leftEndCapMode, this.sensorPositionY, this.sensorPositionZ);
        x = -(this.halfCylinder + this.g_rL - delta) + this.sensorPositionX;
        y = this.sensorPositionY;
        CartesianNumber vCase = new CartesianNumber(x, y, z);
        int tankPos = this.sharedTP.angleDegrees == 0.0 ? 0 : (this.sharedTP.angleDegrees < 90.0 ? 1 : 2);
        switch (tankPos) {
            case 0: {
                this.trueSensorPositionX = hCase.x;
                this.trueSensorPositionY = hCase.y;
                break;
            }
            case 1: {
                double sa = Math.sin(this.sharedTP.angleRadians);
                double ca = Math.cos(this.sharedTP.angleRadians);
                if (this.sharedTP.tankUpright) {
                    this.trueSensorPositionX = vCase.x * ca + vCase.y * sa;
                    this.trueSensorPositionY = vCase.x * sa - vCase.y * ca;
                    break;
                }
                this.trueSensorPositionX = hCase.x * ca - hCase.y * sa;
                this.trueSensorPositionY = hCase.x * sa + hCase.y * ca;
                break;
            }
            case 2: {
                this.trueSensorPositionX = vCase.y;
                this.trueSensorPositionY = vCase.x;
            }
        }
        this.trueSensorOffset = this.leftTankHeight + this.trueSensorPositionY;
        return !Double.isNaN(this.trueSensorOffset);
    }

    double endCapSurfacePos(int capMode, double x, double z) {
        double h = Math.sqrt(x * x + z * z);
        double v = 0.0;
        switch (capMode) {
            case 0: {
                v = this.g_rL - Math.sqrt(this.g_R * this.g_R - h * h) * this.g_rL / this.g_R;
                break;
            }
            case 1: {
                v = h * this.g_rL / this.g_R;
                break;
            }
            case 2: {
                double msr = this.leftMajorSphereRadius;
                v = msr - Math.sqrt(msr * msr - h * h);
            }
        }
        return v;
    }

    TankCompResult tankVolumeForHeight(double y) {
        return this.performFullIntegral(y, this.sharedTP.leftEndCapMode, this.sharedTP.rightEndCapMode);
    }

    TankCompResult volumeForHeightCore(double y) {
        return this.tankVolumeForHeight(y);
    }

    double heightForVolumeCore(double v) {
        if (v == 0.0) {
            return 0.0;
        }
        TankCompResult mv = this.computeMaxVolume();
        double my = this.computeFullTankHeight();
        if (v == mv.volume) {
            return my;
        }
        int n = 0;
        double dy = my;
        double y = dy * 0.5;
        while (n++ < 64) {
            double d;
            double dv = this.volumeForHeightCore((double)y).volume - v;
            if (!(Math.abs(d) > this.sharedTP.rootFinderEpsilon)) break;
            y += dv < 0.0 ? dy : -(dy *= 0.5);
        }
        return y;
    }

    TankCompResult volumeForHeight(double height) {
        height *= this.sensorScalingFactor();
        if (this.trueSensorOffset != 0.0) {
            height += this.trueSensorOffset;
        }
        TankCompResult result = this.volumeForHeightCore(height);
        if (!Double.isNaN(result.volume) && this.residualVolume != 0.0) {
            result.volume += this.residualVolume;
        }
        return result;
    }

    TankCompResult heightForVolume(double volume) {
        double height;
        if (this.residualVolume != 0.0) {
            volume -= this.residualVolume;
        }
        if (!Double.isNaN(height = this.heightForVolumeCore(volume))) {
            height /= this.sensorScalingFactor();
        }
        if (this.trueSensorOffset != 0.0 && ((height -= this.trueSensorOffset) < 0.0 || height > this.maxHeight)) {
            height = Double.NaN;
        }
        TankCompResult result = new TankCompResult();
        if (!Double.isNaN(height)) {
            result = this.tankVolumeForHeight(height);
            result.height = height;
        }
        return result;
    }

    TankCompResult computeHeightOrVolume(double y) {
        if (this.parent.inverseMode) {
            return this.heightForVolume(y);
        }
        return this.volumeForHeight(y);
    }

    TankCompResult computeMaxVolume() {
        return this.tankFullVolume();
    }

    double computeFullTankHeight() {
        return this.maxHeight;
    }

    double sensorScalingFactor() {
        double result = 1.0;
        switch (this.sharedTP.sensorOrientation) {
            case 0: {
                break;
            }
            case 1: {
                result = Math.cos(this.sharedTP.angleRadians);
                break;
            }
            case 2: {
                result = Math.sin(this.sharedTP.angleRadians);
            }
        }
        return result;
    }

    double convertLengthUnits(double v, boolean inverse) {
        double cv = Constants.conversionValues[this.sharedTP.inputUnitIndex];
        return inverse ? v * cv : v / cv;
    }

    double convertAreaUnits(double v, boolean inverse) {
        double ou = Constants.conversionValues[this.sharedTP.inputUnitIndex];
        ou *= ou;
        return inverse ? v * ou : v / ou;
    }

    double convertVolumeUnits(double v, boolean inverse) {
        double ou = Constants.conversionValues[this.sharedTP.outputUnitIndex];
        ou = ou * ou * ou;
        return inverse ? v * ou : v / ou;
    }
}

