/**
 * *************************************************************************
 * Copyright (C) 2014 by Paul Lutus * lutusp@arachnoid.com * * This program is
 * free software; you can redistribute it and/or modify * it under the terms of
 * the GNU General Public License as published by * the Free Software
 * Foundation; either version 2 of the License, or * (at your option) any later
 * version. * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the * GNU General
 * Public License for more details. * * You should have received a copy of the
 * GNU General Public License * along with this program; if not, write to the *
 * Free Software Foundation, Inc., * 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA. *
 * *************************************************************************
 */
package tankcalc;

import static java.lang.Math.max;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.JLabel;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@SuppressWarnings("serial")
final public class DataTableModel extends AbstractTableModel {

    TankCalc parent;
    //ArrayList<String[]> array;
    String[] header;
    int[] columnWidths;
    JTable table;
    Font font;
    FontMetrics fm;
    JTableHeader hd;
    DefaultTableCellRenderer headerRenderer;

    public DataTableModel(TankCalc p, JTable table) {
        parent = p;
        this.table = table;
        Font origfont = table.getFont();
        font = new Font(Font.SANS_SERIF, Font.PLAIN, origfont.getSize());
        table.setFont(font);
        hd = table.getTableHeader();
        hd.setFont(font);
        hd.setOpaque(true);
        //hd.setBackground(Color.WHITE);
        fm = table.getFontMetrics(font);
        headerRenderer = (DefaultTableCellRenderer) hd.getDefaultRenderer();
        headerRenderer.setHorizontalAlignment(JLabel.CENTER);
        headerRenderer.setFont(font);
        headerRenderer.setOpaque(true);
        headerRenderer.setBackground(new Color(0xc0d0c0));
    }

    // this is a goofy but necessary way to
    // pad the contents on table cells
    protected String padString(String s) {
        return " " + s + " ";
    }

    protected void updateDisplay() {

        if (parent.strHeaderArray != null && parent.strTableArray != null && parent.strTableArray.size() > 0) {
            header = parent.strHeaderArray.toArray(new String[]{});
            columnWidths = new int[header.length];
            int marg = 8;
            // this only works because monospace font is in use
            int cw = (int) (fm.stringWidth("X"));

            for (int n = 0; n < columnWidths.length; n++) {
                columnWidths[n] = header[n].length() * cw + marg;
            }
            TableColumnModel tcm = new DefaultTableColumnModel();
            table.setColumnModel(tcm);
            int i = 0;
            for (String hs : parent.strHeaderArray) {
                TableColumn tc = new TableColumn(i);
                DataTableCellRenderer rr = new DataTableCellRenderer();
                // this allows HTML entities to be rendered correctly
                tc.setHeaderValue("<html>" + hs);
                tc.setCellRenderer(rr);
                tcm.addColumn(tc);
                columnWidths[i] = max(hs.length() * cw + marg,
                        columnWidths[i]);
                i += 1;
            }
            
            table.setShowGrid(true);
            for (ArrayList<String> row : parent.strTableArray) {
                for (int n = 0; n < row.size(); n++) {
                    String ss = row.get(n);
                    columnWidths[n] = max(ss.length() * cw + marg * 4,
                            columnWidths[n]);
                }
            }
            for (int n = 0; n < getColumnCount(); n++) {
                tcm.getColumn(n)
                        .setPreferredWidth(columnWidths[n]);

            }
            int ch = fm.getHeight();
            table.setRowHeight(ch + marg);
            
        }
    }
    
    public ArrayList<String> getRowData(int row) {
        if(row >= 0 && row < getRowCount()) {
            return parent.strTableArray.get(row);
        }
        else {
            return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        return header[column];
    }

    @Override
    public int getRowCount() {
        // TODO Auto-generated method stub
        return parent.strTableArray.size();
    }

    @Override
    public int getColumnCount() {
        // TODO Auto-generated method stub
        return (header != null) ? header.length : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if(rowIndex >= 0
                && rowIndex < parent.strTableArray.size()
                && parent.strTableArray.size() > 0
                && columnIndex >= 0
                && columnIndex < parent.strTableArray.get(0).size()) {
        return padString(parent.strTableArray.get(rowIndex).get(columnIndex));
        }
        else {
            return "";
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

}
