/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package tankcalc;

/*
 * This class is identical in TankCalc and TankCalcAndroid
 * Please keep it that way
 */

final public class Transform3D {
    // angles radians
    private  double axr = 0,  ayr = 0;
    // precomputed sines
    double sx,  sy;
    // precomputed cosines
    double cx,  cy;
    // translations
     double tx = 0,  ty = 0,  tz = 0;

    /** Creates a new instance of Transform3D */
    public Transform3D() {
        genValues();
    }

    public void setXtranslate(double v) {
        tx = v;
    }

    public void setYtranslate(double v) {
        ty = v;
    }

    public void setZtranslate(double v) {
        tz = v;
    }

    public void setXAngle(double v) {
        axr = v * Constants.radian;
        genValues();
    }

    public void setYAngle(double v) {
        ayr = v * Constants.radian;
        genValues();
    }

    private void genValues() {
        sx = Math.sin(axr);
        cx = Math.cos(axr);
        sy = Math.sin(ayr);
        cy = Math.cos(ayr);
    }

    public void transformPoint(CartesianPoint v) {
        double x = v.x - tx;
        double y = v.y - ty;
        double z = v.z - tz;
        // from "Apple World" 1979
        double hf = x * sx - z * cx;
        v.y = y * cy + sy * hf;
        v.x = x * cx + z * sx;
        v.z = -y * sy + cy * hf;
    }

    public void resetAll() {
        // angles radians
        axr = 0;
        ayr = 0;
        // translations
        tx = 0;
        ty = 0;
        tz = 0;
        genValues();
    }
}
