package com.arachnoid.carpetempus;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;

import androidx.core.app.NotificationCompat;

public class AlarmSchedulerService extends Service {
	
   // the only reason for this class is to
   // prevent Android from killing off my RTC Wakeup timer

	// every five minutes
	public static final int periodMS = 5 * 60000;
	private Handler handler;
	private Runnable periodicTask;
	CarpeTempusApplication parent = null;
	String className;

	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onCreate() {
		className = getClass().getName();
		parent = (CarpeTempusApplication) getApplication();
		handler = new Handler();
		periodicTask = new Runnable() {
			public void run() {
				parent.logToFile(className + ": Scheduled Time.", false);
				parent.restoreTimerIfNeeded();
				handler.postDelayed(periodicTask, periodMS);
			}
		};
		handler.postAtFrontOfQueue(periodicTask);
		parent.logToFile(className + ": Created: " + periodicTask.toString(), false);
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
			String CHANNEL_ID = "my_channel_01";
			NotificationChannel channel = new NotificationChannel(CHANNEL_ID,
					"Channel human readable title",
					NotificationManager.IMPORTANCE_DEFAULT);

			((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE)).createNotificationChannel(channel);

			Notification notification = new NotificationCompat.Builder(this, CHANNEL_ID)
					.setContentTitle("")
					.setContentText("").build();

			startForeground(1,notification);

		}
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		handler.removeCallbacks(periodicTask);
		parent.logToFile(className + ": Removed: " + periodicTask.toString(), false);
	}

}
