/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.Button;

final public class MyTimeSetButton extends Button {
	private MyTimeSetEntryField entryField;

	public MyTimeSetButton(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	public MyTimeSetButton(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public MyTimeSetButton(Context context) {
		super(context);
	}
	
	public void setNumberPicker(MyTimeSetEntryField picker) {
		entryField = picker;
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		cancelLongpressIfRequired(event);
		return super.onTouchEvent(event);
	}

	@Override
	public boolean onTrackballEvent(MotionEvent event) {
		cancelLongpressIfRequired(event);
		return super.onTrackballEvent(event);
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		if ((keyCode == KeyEvent.KEYCODE_DPAD_CENTER)
				|| (keyCode == KeyEvent.KEYCODE_ENTER)) {
			cancelLongpress();
		}
		return super.onKeyUp(keyCode, event);
	}

	private void cancelLongpressIfRequired(MotionEvent event) {
		if ((event.getAction() == MotionEvent.ACTION_CANCEL)
				|| (event.getAction() == MotionEvent.ACTION_UP)) {
			cancelLongpress();
		}
	}

	private void cancelLongpress() {
		if (R.id.increment == getId() || (R.id.decrement == getId())) {
			entryField.stopLongPress();
		} 
	}

}
