/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.DatePicker;

public abstract class SetupBase extends Activity {
	final String aboutUrl = "http://arachnoid.com/android/CarpeTempus/index.html";
	final static int DATE_DIALOG_ID = 0;
	final static int TIME_DIALOG_ID = 1;
	final static int TIME_DIALOG_MMSS_ID = 2;
	final static int TTG_DIALOG_ID = 3;
	final static int TTG_DIALOG_MMSS_ID = 4;
	final static int SET_RINGTONE = 999;
	protected DatePickerDialog.OnDateSetListener dateListener = null;
	protected MyTimeSetDialog.OnTimeSetListener timeListener = null;

	CarpeTempusApplication app;
	GenericEvent ae = null;
	GenericEvent aeclone = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		app = (CarpeTempusApplication) getApplication();
	}

	protected GenericEvent getAlarmEvent(View v) {
		GenericEvent ae = null;
		while (v != null && !(v instanceof GenericLayout)) {
			v = (View) v.getParent();
		}
		if (v != null) {
			ae = ((GenericLayout) v).ae;
			assert (ae instanceof GenericEvent);
		}
		return ae;
	}

	public void showTimeDialogButton(View v) {
		showTimeDialog();
	}

	public void showDateDialogButton(View v) {
		showDateDialog();
	}

	protected void showTimeDialog() {
		aeclone.makeLocalDateTimeFieldsfromEventTime();
		timeListener = new MyTimeSetDialog.OnTimeSetListener() {

			public void onTimeSet(MyTimeSetDialog view, int hour, int minute,
					int second) {
				aeclone.setHour(hour);
				aeclone.setMinute(minute);
				aeclone.setSecond(second);
				aeclone.readEventDateTime();
				processResults();
			}
		};

		if (aeclone instanceof TimerEvent) {
			dispatchDialog(TTG_DIALOG_ID);
		} else {
			dispatchDialog(TIME_DIALOG_ID);
		}
	}

	protected void showDateDialog() {
		aeclone.makeLocalDateTimeFieldsfromEventTime();
		dateListener = new DatePickerDialog.OnDateSetListener() {
			public void onDateSet(DatePicker view, int year, int monthOfYear,
					int dayOfMonth) {
				aeclone.setYear(year);
				aeclone.setMonth(monthOfYear);
				aeclone.setDay(dayOfMonth);
				aeclone.readEventDateTime();
				aeclone.setSpecDate(true);
				processResults();
				System.out.println("showDateDialog: finish");
			}
		};
		dispatchDialog(DATE_DIALOG_ID);
	}

	protected void formatTitle(Dialog dialog, String subTitle) {
		String pref = app.programTitle;
		dialog.setTitle(pref + ": " + subTitle);
	}

	public MyTimeSetDialog namedTimeDialog(String subTitle, boolean is24Hour) {
		MyTimeSetDialog dialog = new MyTimeSetDialog(this, timeListener,
				aeclone, is24Hour);
		formatTitle(dialog, subTitle);
		return dialog;
	}

	public DatePickerDialog namedDateDialog(String subTitle) {
		DatePickerDialog dialog = new DatePickerDialog(this, dateListener,
				aeclone.getYear(), aeclone.getMonth(), aeclone.getDay());
		dialog.setButton(DialogInterface.BUTTON_NEGATIVE, "Cancel",
				new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						if (which == DialogInterface.BUTTON_NEGATIVE) {
							final Handler handler = new Handler();
							handler.postDelayed(new Runnable() {
							  
							  public void run() {
								  aeclone.setSpecDate(false);
									processResults();
									
							  }
							}, 100);
						}
					}
				});
		formatTitle(dialog, subTitle);

		// this only works here because
		// DatePickerDialog subclasses AlertDialog
		dialog.setIcon(R.drawable.app_icon);
		return dialog;
	}

	private void dispatchDialog(int id) {
		Dialog dialog = null;
		switch (id) {
		case DATE_DIALOG_ID:
			dialog = namedDateDialog("Set Alarm Date");
			break;
		case TIME_DIALOG_ID:
			dialog = namedTimeDialog("Set Alarm Time", app.get24HourFormat());
			break;
		case TTG_DIALOG_ID:
			dialog = namedTimeDialog("Set Timer Duration", true);
			break;
		}
		if (dialog != null) {
			dialog.show();
		}
	}

	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (requestCode == SET_RINGTONE) {
			if (resultCode == RESULT_OK) {
				Uri uri = (Uri) data.getExtras().get(
						RingtoneManager.EXTRA_RINGTONE_PICKED_URI);
				app.serialData.ringtoneUri = uri.toString();
			}
		}
	}

	protected void processResults() {
		Log.w("Unimplemented function in SetupBase", "processResults()");
	}

	protected void writeValues(View v) {
		Log.w("Unimplemented function in SetupBase", "writeValues()");
	}

	protected void updateDisplay() {
		Log.w("Unimplemented function in SetupBase", "updateDisplay()");
	}

	protected void createEventList() {
		Log.w("Unimplemented function in SetupBase", "createEventList()");
	}

	public void setTimeButton(View v) {
		Log.w("Unimplemented function in SetupBase", "setTimeButton()");
	}

	public void setDateButton(View v) {
		Log.w("Unimplemented function in SetupBase", "setDateButton()");
	}

}
