/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   http://arachnoid.com/administration                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package com.arachnoid.carpetempus;

import android.app.AlertDialog;
import android.app.Service;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

final public class SetupDialogActivity extends SetupBase {

    EditText editMessage = null;
    CheckBox voiceCheckBox = null;
    CheckBox toneCheckBox = null;
    CheckBox specDateCheckBox = null;
    CheckBox weekDayCheckBox = null;
    CheckBox monthDayCheckBox = null;
    CheckBox recurringCheckBox = null;
    CheckBox digitalCheckBox = null;
    // CheckBox showNotifyCheckBox = null;
    Button weekDaysButton = null;
    Button monthDaysButton = null;
    Button ringtoneButton = null;
    TextView textDate = null;
    TextView textDateLabel = null;
    TextView textTime = null;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_LEFT_ICON);
        setContentView(R.layout.setup_dialog_layout);
        setFeatureDrawableResource(Window.FEATURE_LEFT_ICON,
                R.drawable.app_icon);
        try {
            int index = getIntent().getIntExtra("AlarmEventIndex", -1);
            ae = app.getEventForIndex(index);
            String title = app.programTitle + ": " + ae.getNameTag() + " Setup";
            setTitle(title);
            aeclone = ae.copy();
            if (aeclone != null) {
                editMessage = (EditText) findViewById(R.id.edit_message);
                voiceCheckBox = (CheckBox) findViewById(R.id.voice_checkbox);
                toneCheckBox = (CheckBox) findViewById(R.id.tone_checkbox);
                specDateCheckBox = (CheckBox) findViewById(R.id.date_checkbox);
                weekDayCheckBox = (CheckBox) findViewById(R.id.weekdays_checkbox);
                monthDayCheckBox = (CheckBox) findViewById(R.id.monthdays_checkbox);
                recurringCheckBox = (CheckBox) findViewById(R.id.recurring_checkbox);
                // showNotifyCheckBox = (CheckBox)
                // findViewById(R.id.notify_checkbox);
                digitalCheckBox = (CheckBox) findViewById(R.id.digital_checkbox);
                weekDaysButton = (Button) findViewById(R.id.weekdays_button);
                monthDaysButton = (Button) findViewById(R.id.monthdays_button);
                ringtoneButton = (Button) findViewById(R.id.ringtone_button);
                textDate = (TextView) findViewById(R.id.text_date);
                textDateLabel = (TextView) findViewById(R.id.text_date_label);
                textTime = (TextView) findViewById(R.id.text_time);
                if (ae instanceof TimerEvent) {
                    specDateCheckBox.setEnabled(false);
                    weekDayCheckBox.setEnabled(false);
                    monthDayCheckBox.setEnabled(false);
                    recurringCheckBox.setEnabled(ae.canRecur());
                    textDate.setEnabled(false);
                    textDate.setText("00/00/0000");
                    textDateLabel.setEnabled(false);
                }
                readValues();
                // just to set up disabled controls
                processResults();
            } else {
                app.showMessage(this, "Alarm Event Not Found", "Alarm Event");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelButton(View v) {
        finish();
    }

    public void readValues() {
        editMessage.setText("");
        editMessage.append(aeclone.getMessage());
        voiceCheckBox.setChecked(aeclone.getVoice());
        toneCheckBox.setChecked(aeclone.getTone());
        specDateCheckBox.setChecked(aeclone.getSpecDate());
        weekDayCheckBox.setChecked(aeclone.getWeekDays());
        monthDayCheckBox.setChecked(aeclone.getMonthDays());
        recurringCheckBox.setChecked(aeclone.getRecurring());
        digitalCheckBox.setChecked(app.serialData.digitalAlertDialog);
        // showNotifyCheckBox.setChecked(app.serialData.notifyIcon);
    }

    public void processResults() {
        try {
            aeclone.setMessage(editMessage.getText().toString());
            aeclone.setVoice(voiceCheckBox.isChecked());
            aeclone.setTone(toneCheckBox.isChecked());
            aeclone.setSpecDate(specDateCheckBox.isChecked());
            aeclone.setWeekDays(weekDayCheckBox.isChecked());
            aeclone.setMonthDays(monthDayCheckBox.isChecked());
            aeclone.setRecurring(recurringCheckBox.isChecked());
            app.serialData.digitalAlertDialog = digitalCheckBox.isChecked();

            weekDaysButton.setEnabled(aeclone.getWeekDays());
            monthDaysButton.setEnabled(aeclone.getMonthDays());
            ringtoneButton.setEnabled(aeclone.getTone());
            textDate.setEnabled(aeclone.getSpecDate());
            textDateLabel.setEnabled(aeclone.getSpecDate());

            // make the notify icon appear/disappear in real time
            // boolean oldNotify = app.serialData.notifyIcon;
            // app.serialData.notifyIcon = showNotifyCheckBox.isChecked();
            // if (oldNotify != app.serialData.notifyIcon) {
            // app.restartService();
            // }
            if (!(ae instanceof TimerEvent)) {
                textDate.setText(aeclone.secToDateString(app));
            }
            textTime.setText(aeclone.secToTimeString(app));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeValues(View v) {
        processResults();
    }

    public void newMessageButton(View v) {

        editMessage.setText("");
        final InputMethodManager mgr = (InputMethodManager) getSystemService(Service.INPUT_METHOD_SERVICE);
        editMessage.requestFocus();
        boolean result = mgr.showSoftInput(editMessage, InputMethodManager.SHOW_IMPLICIT);
    }

    public void acceptButton(View v) {
        processResults();
        ae.copyValuesFrom(aeclone);
        if (ae instanceof TimerEvent) {
            ae.setActive(false);
        }
        finish();
    }

    public void copyButton(View v) {
        processResults();
        ae.copyValuesFrom(aeclone);
        if (ae instanceof TimerEvent) {
            app.addEvent(new TimerEvent(ae));
        } else {
            app.addEvent(new AlarmEvent(ae));
        }
        finish();
    }

    public void deleteButton(View v) {
        new AlertDialog.Builder(this)
                .setIcon(R.drawable.app_icon)
                .setTitle("Delete event")
                .setCancelable(false)
                .setMessage("Okay to delete this event?")
                .setPositiveButton("Yes",
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog,
                                                int which) {
                                app.deleteEvent(ae);
                                finish();
                            }

                        }).setNegativeButton("No", null).show();
    }

    public void ringToneButton(View v) {
        Intent intent = new Intent(RingtoneManager.ACTION_RINGTONE_PICKER);

        Uri uri = Uri.parse(app.serialData.ringtoneUri);
        intent.putExtra(RingtoneManager.EXTRA_RINGTONE_EXISTING_URI,
                RingtoneManager.TYPE_NOTIFICATION);
        intent.putExtra(RingtoneManager.EXTRA_RINGTONE_EXISTING_URI, uri);

        intent.putExtra(RingtoneManager.EXTRA_RINGTONE_TYPE,
                RingtoneManager.TYPE_NOTIFICATION);
        intent.putExtra(RingtoneManager.EXTRA_RINGTONE_TYPE,
                RingtoneManager.TYPE_ALL);

        String title = app.programTitle
                + ": Choose Alarm Sound\n(for all alarms and timers)";
        intent.putExtra(RingtoneManager.EXTRA_RINGTONE_TITLE,
                RingtoneManager.TYPE_NOTIFICATION);
        intent.putExtra(RingtoneManager.EXTRA_RINGTONE_TITLE, title);

        startActivityForResult(intent, SET_RINGTONE);
    }

    public void weekDaysButton(View v) {
        WeekDaysDialog dialog = new WeekDaysDialog(this, aeclone);
        dialog.show();
    }

    public void monthDaysButton(View v) {
        MonthDaysDialog dialog = new MonthDaysDialog(this, aeclone);
        dialog.show();
    }

    public void repsButton(View v) {
        MyRepsSetDialog.OnRepsSetListener repsListener = new MyRepsSetDialog.OnRepsSetListener() {

            public void onRepsSet(MyRepsSetDialog view, int reps) {
                aeclone.setRepetitions(reps);
                processResults();
            }
        };
        MyRepsSetDialog dialog = new MyRepsSetDialog(this, repsListener,
                aeclone);
        formatTitle(dialog, "Set Alarm Repetitions");
        dialog.show();
    }

    // launch browser

    public void aboutButton(View v) {
        Intent intent = new Intent(app, WebWindow.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("URL", aboutUrl);
        app.context.startActivity(intent);
    }
}
