package com.arachnoid.carpetempus;

import android.content.Context;
import android.os.PowerManager;

class WakeLockFunctions {
	
	private static PowerManager.WakeLock alarmWakeLock = null;
	
	static void acquireWakeLock(Context context) {
		if (alarmWakeLock != null) {
			return;
		}

		PowerManager pm =(PowerManager) context.getSystemService(Context.POWER_SERVICE);
		alarmWakeLock = pm.newWakeLock(
				PowerManager.PARTIAL_WAKE_LOCK |
				PowerManager.ACQUIRE_CAUSES_WAKEUP |
				PowerManager.ON_AFTER_RELEASE, "AlarmAlertDialog");
		alarmWakeLock.acquire();
	}

	static void releaseWakeLock() {
		if (alarmWakeLock != null) {
			alarmWakeLock.release();
			alarmWakeLock = null;
		}
	}

}
