/***************************************************************************
 *   Copyright (C) 2012 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package com.arachnoid.tankcalcandroid;

import android.content.res.Resources;

public class AndroidConstants {

	String[] strLengthUnits;
	String[] strVolumeUnits;
	String[] strAreaUnits;
	String[] strCapTypes;
	String[] strSensorAxis;
	String[] strTankOrientation;
	String[] strAngleUnits;
	String[] strWeightUnits;
	String[] strTabLabels;

	public void readStringResources(TankCalcAndroidApplication app) {
		Resources res = app.getResources();
		strLengthUnits = res.getStringArray(R.array.length_units);
		strVolumeUnits = res.getStringArray(R.array.volume_units);
		strAreaUnits = res.getStringArray(R.array.area_units);
		strCapTypes = res.getStringArray(R.array.cap_types);
		strSensorAxis = res.getStringArray(R.array.sensor_axis);
		strTankOrientation = res.getStringArray(R.array.tank_orient);
		strAngleUnits = res.getStringArray(R.array.angle_units);
		strWeightUnits = res.getStringArray(R.array.weight_units);
		strTabLabels = res.getStringArray(R.array.tab_labels);
	}
	
	static public int TABSETUP = 0;
	static public int TABTABLE = 1;
	static public int TABDISPLAY = 2;
	static public int TABHELP = 3;

}
