/*
 * This class is identical in TankCalc and TankCalcAndroid
 * Please keep it that way
 */
package com.arachnoid.tankcalcandroid;

/**
 *
 * @author lutusp
 */
final class Constants {

    static public final double radian = Math.PI / 180.0;
    static public final double degree = 180.0 / Math.PI;
    static public final double twoPi = 2 * Math.PI;
    static public final double piSq = Math.PI * Math.PI;
    static public final double piD2 = 0.5 * Math.PI;
    static final public int LEFTELLIPSE = 1;
    static final public int CYLINDER = 2;
    static final public int RIGHTELLIPSE = 4;

    static final public int ELLIPSEMODE = 0;
    static final public int CONICMODE = 1;
    static final public int SPHEREMODE = 2;

    static final int TANKHORIZONTAL = 0;
    static final int TANKVERTICAL = 1;
    static final int TANKTILTED = 2;

    static final int SENSORSURFACE = 0;
    static final int SENSORXAXIS = 1;
    static final int SENSORYAXIS = 2;

    static final int TABLEPLAIN = 0;
    static final int TABLECSV = 1;
    static final int TABLEHTML = 2;

    static final int DATATABLE = 0;
    static final int SPECTABLE = 1;

    static final int ENTRYDEGREES = 0;
    static final int ENTRYSLOPE = 1;

    static final public int WEIGHTKILOS = 0;
    static final public int WEIGHTPOUNDS = 1;

    static final String inputUnitNames[] = {"mm", "cm", "meters", "inches",
        "feet"};
    static final String[] outputUnitVolumeNames = {"mm&sup3;", "cm&sup3;",
        "meters&sup3;", "inches&sup3;", "feet&sup3;", "liters", "gallons"};
    static final String[] outputUnitAreaNames = {"mm&sup2;", "cm&sup2;",
        "meters&sup2;", "inches&sup2;", "feet&sup2;"};
    static final String[] tankOrientationTitles = {"Horizontal", "Vertical",
        "Tilted"};
    
    static final IColor leftCapColor = new IColor(0xc0,0,0);
    static final IColor cylinderColor = new IColor(0,0x80,0);
    static final IColor rightCapColor = new IColor(0,0,0xc0);
    static final IColor sensorColor = new IColor(0xc0,0,0xc0);
    static final IColor redColor = new IColor(0xc0,0,0);
    static final IColor cyanColor = new IColor(0,0xc0,0xc0);

    // used to map traversal of graphic polygons
    static final int[] polyTraverseX = new int[]{0, 1, 1, 0, 0};
    static final int[] polyTraverseY = new int[]{0, 0, 1, 1, 0};

    static final double[] conversionValues = {
        1000.0, // millimeters
        100.0, // centimeters
        1.0, // meters
        39.370078, // inches
        3.280839895, // feet
        10.0, // liters
        6.41646195294 // gallons
    };

    static final double weightConversionValues[] = {
        1.0, // kilos
        2.2046 // pounds
    };

}
