/*
 * Decompiled with CFR 0.152.
 */
package polysolve;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import polysolve.Pair;
import polysolve.PolySolve;

public final class GraphPanel
extends JPanel {
    double xgmin;
    double xgmax;
    double ygmin;
    double ygmax;
    PolySolve parent;

    public GraphPanel(PolySolve parent) {
        this.parent = parent;
    }

    public Pair mousePos(int x, int y) {
        this.compScreen();
        double mx = this.ntrp(this.xgmin, this.xgmax, this.parent.xmin, this.parent.xmax, x);
        double my = this.ntrp(this.ygmin, this.ygmax, this.parent.ymax, this.parent.ymin, y);
        return new Pair(mx, my);
    }

    double ntrp(double xa, double xb, double ya, double yb, double x) {
        return (x - xa) * (yb - ya) / (xb - xa) + ya;
    }

    int intrp(double xa, double xb, double ya, double yb, double x) {
        return (int)this.ntrp(xa, xb, ya, yb, x);
    }

    void drawScaledLine(Graphics g, double ox, double oy, double x, double y) {
        int opx = this.intrp(this.parent.xmin, this.parent.xmax, this.xgmin, this.xgmax, ox);
        int px = this.intrp(this.parent.xmin, this.parent.xmax, this.xgmin, this.xgmax, x);
        int opy = this.intrp(this.parent.ymax, this.parent.ymin, this.ygmin, this.ygmax, oy);
        int py = this.intrp(this.parent.ymax, this.parent.ymin, this.ygmin, this.ygmax, y);
        g.drawLine(opx, opy, px, py);
    }

    void drawScaledPoint(Graphics g, double x, double y, int dsi) {
        int ds = dsi / 2;
        int px = this.intrp(this.parent.xmin, this.parent.xmax, this.xgmin, this.xgmax, x);
        int py = this.intrp(this.parent.ymax, this.parent.ymin, this.ygmin, this.ygmax, y);
        g.fillOval(px - ds, py - ds, dsi, dsi);
    }

    void drawScale(Graphics cg) {
        double x;
        double y;
        double scaleFact = 5.0;
        double ystep = Math.abs(this.parent.ymax - this.parent.ymin) / 5.0;
        double s = Math.log(ystep) / Math.log(scaleFact);
        s = Math.floor(s);
        ystep = Math.pow(scaleFact, s);
        cg.setColor(this.parent.gridColor);
        for (y = -ystep; y >= this.parent.ymin; y -= ystep) {
            if (!(y >= this.parent.ymin) || !(y <= this.parent.ymax)) continue;
            this.drawScaledLine(cg, this.parent.xmin, y, this.parent.xmax, y);
        }
        for (y = ystep; y <= this.parent.ymax; y += ystep) {
            if (!(y >= this.parent.ymin) || !(y <= this.parent.ymax)) continue;
            this.drawScaledLine(cg, this.parent.xmin, y, this.parent.xmax, y);
        }
        cg.setColor(this.parent.zeroColor);
        this.drawScaledLine(cg, this.parent.xmin, 0.0, this.parent.xmax, 0.0);
        double xstep = Math.abs(this.parent.xmax - this.parent.xmin) / 5.0;
        s = Math.log(xstep) / Math.log(scaleFact);
        s = Math.floor(s);
        xstep = Math.pow(scaleFact, s);
        cg.setColor(this.parent.gridColor);
        for (x = xstep; x <= this.parent.xmax; x += xstep) {
            if (!(x >= this.parent.xmin) || !(x <= this.parent.xmax)) continue;
            this.drawScaledLine(cg, x, this.parent.ymin, x, this.parent.ymax);
        }
        for (x = -xstep; x >= this.parent.xmin; x -= xstep) {
            if (!(x >= this.parent.xmin) || !(x <= this.parent.xmax)) continue;
            this.drawScaledLine(cg, x, this.parent.ymin, x, this.parent.ymax);
        }
        cg.setColor(this.parent.zeroColor);
        this.drawScaledLine(cg, 0.0, this.parent.ymin, 0.0, this.parent.ymax);
    }

    void drawDataPoints(Graphics2D cg, int dsi) {
        cg.setColor(this.parent.dataColor);
        for (Pair pr : this.parent.userDataList) {
            double x = pr.x;
            double y = pr.y;
            this.drawScaledPoint(cg, x, y, dsi);
        }
    }

    void drawCurve(Graphics2D cg) {
        double ox = 0.0;
        double oy = 0.0;
        cg.setColor(this.parent.lineColor);
        double step = (this.parent.dataXmax - this.parent.dataXmin) / (double)(25 * (this.parent.poly_order + 1));
        for (double x = this.parent.dataXmin; x < this.parent.dataXmax + step; x += step) {
            double y = this.parent.plotFunct(x);
            if (x == this.parent.dataXmin) {
                ox = x;
                oy = y;
            }
            this.drawScaledLine(cg, ox, oy, x, y);
            ox = x;
            oy = y;
        }
    }

    boolean compScreen() {
        boolean result = false;
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (w > 0 && h > 0) {
            this.xgmin = 1.0;
            this.ygmin = 1.0;
            this.xgmax = w - 2;
            this.ygmax = h - 2;
            result = true;
        }
        return result;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D cg = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        cg.addRenderingHints(rh);
        if (this.compScreen()) {
            int dsi = (int)(this.parent.dotScale * this.xgmax / 500.0);
            int n = dsi = dsi < 2 ? 2 : dsi;
            if (this.parent.data_valid) {
                this.drawScale(cg);
                this.drawDataPoints(cg, dsi);
                this.drawCurve(cg);
            } else if (this.parent.errorMsg.length() > 0) {
                String s = "Error: " + this.parent.errorMsg;
                int sl = s.length();
                int hp = (int)(this.xgmax - (double)sl * 5.5) / 2;
                cg.drawString(s, hp, (int)this.ygmax / 2);
            }
        }
    }
}

