#!/usr/bin/qtrubyinit

require 'sampledialog_ui.rb'

# SampleDialog subclasses SampleDialogUI

class SampleDialog < SampleDialogUI

   def initialize(app)
      super()
      @app = app
   end

   # acquire and show method name

   def show_method_name
      caller[0] =~ /`(.*?)'/
      print "Command routed to #{self.class}.#{$1}\n"
   end

   # signal handlers

   def testButton_clicked(*k)
      show_method_name
      print "Put test code here.\n"
   end

   def closeButton_clicked(*k)
      show_method_name
      close()
   end

   # override default close() method

   def close(*x)
      show_method_name
      @app.exit(0)
   end

end

# create and show dialog

if $0 == __FILE__
   app = Qt::Application.new(ARGV)
   dialog = SampleDialog.new(app)
   app.mainWidget = dialog
   dialog.show
   app.exec
end
