/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CART3_H
#define CART3_H

#include <cstdio>
#include <string>

using namespace std;

/**
	@author Paul Lutus <lutusp@pl-alpha>
*/
class Cart3
{
public:
  Cart3(double x, double y,double z);
  Cart3(Cart3 *p);
  Cart3();

  ~Cart3();
  void debug_print();
  Cart3 operator=(Cart3 v);
  Cart3 operator+=(double v);
  Cart3 operator+=(Cart3 v);
  Cart3 operator-=(double v);
  Cart3 operator-=(Cart3 v);
  Cart3 operator*=(double v);
  Cart3 operator*=(Cart3 v);
  Cart3 operator/=(double v);
  Cart3 operator/=(Cart3 v);

  Cart3 operator+(double v);
  Cart3 operator+(Cart3 v);
  Cart3 operator-(double v);
  Cart3 operator-(Cart3 v);
  Cart3 operator*(double v);
  Cart3 operator*(Cart3 v);
  Cart3 operator/(double v);
  Cart3 operator/(Cart3 v);
    double sumsq();
    string show();

  double x,y,z;

};

#endif
