/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "gravity_class.h"

// this header file contains the glade interface spec
#include "GladeSpec.h" 

/*
*
* compilation configuration must include:
* CXXFLAGS="$CXXFLAGS `pkg-config --cflags --libs libglademm-2.4 gthread-2.0`"
*
* also for distribution, put this same line
* in 'configure.in', before the line
* AC_OUTPUT(Makefile src/Makefile )
*
*/

int main ( int argc, char **argv )
{
	try
	{
		g_thread_init ( NULL );
		gdk_threads_init();
		Gtk::Main kit ( argc, argv );
		Glib::RefPtr<Gnome::Glade::Xml> refXml = Gnome::Glade::Xml::create_from_buffer ( GladeSpec::content.c_str(),GladeSpec::content.size() );
		Gravity* main_win = 0;
		refXml->get_widget_derived ( "GravityUI", main_win );
		if ( main_win )
		{
			gdk_threads_enter();
			kit.run ( *main_win );
			gdk_threads_leave();

		}
		return 0;
	}
	catch ( std::exception const& ex )
	{
		std::cerr << "Error: " << ex.what() << std::endl;
		return 1;
	}
}
