/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "orbitalphysics.h"

OrbitalPhysics::OrbitalPhysics()
{}


OrbitalPhysics::~OrbitalPhysics()
{}

const double OrbitalPhysics::G = 6.6742e-11;

void OrbitalPhysics::compute_acceleration ( Planet *pa,Planet *pb,double dt )
{
	// don't compute self-gravitation
	if ( pa != pb )
	{
		Cart3 radius = pa->pos - pb->pos;
		double sumsq = radius.sumsq();
		double hypot = sqrt ( sumsq );
		double acc = -G * pb->mass / sumsq;
		// this line assigns the acceleration to
		// the x,y,z velocity components along the
		// radius pa - pb without using trig functions
		pa->vel += radius / hypot * acc * dt;
	}
}

void OrbitalPhysics::process_planets ( vector<Planet *> planet_list,double dt,bool symmetric )
{
	if ( symmetric )
	{
		// compute gravitation interactively for all bodies
		// very slow ... requires p^2 time
		for ( unsigned int y = 0; y < planet_list.size();y++ )
		{
			for ( unsigned int x = 0; x < planet_list.size();x++ )
			{
				compute_acceleration ( planet_list[y],planet_list[x],dt );
			}
			planet_list[y]->pos += planet_list[y]->vel * dt;
		}
	}
	else
	{
		// compute gravitation only wrt the sun
		// which is assumed to be first member of array
		Planet *sun = planet_list[0];
		for ( unsigned int i = 0;i < planet_list.size();i++ )
		{
			compute_acceleration ( planet_list[i],sun,dt );
			planet_list[i]->pos += planet_list[i]->vel * dt;
		}
	}
}
