/***************************************************************************
 *   Copyright (C) 2008 by Paul Lutus   *
 *   lutusp@pl-alpha   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ORBITALPHYSICS_H
#define ORBITALPHYSICS_H

#include "cart3.h"
#include "planet.h"
#include <vector>
#include <cmath>

/**
	@author Paul Lutus <lutusp@pl-alpha>
*/
class OrbitalPhysics
{
public:
  OrbitalPhysics();

  ~OrbitalPhysics();
  static const double G;
  static void compute_acceleration(Planet *pa,Planet *pb,double dt);
  static void process_planets(vector <Planet *> planet_list,double dt,bool symmetric = false);

};

#endif
